/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.execution.internal;

import de.rcenvironment.components.evaluationmemory.execution.internal.EvaluationMemoryAccess;
import de.rcenvironment.components.evaluationmemory.execution.internal.EvaluationMemoryFileAccessImpl;
import de.rcenvironment.components.evaluationmemory.execution.internal.EvaluationMemoryFileAccessService;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class EvaluationMemoryFileAccessServiceImpl
implements EvaluationMemoryFileAccessService {
    private TypedDatumSerializer typedDatumSerializer;
    private Set<String> memoryFilesInUse = new HashSet<String>();

    @Override
    public synchronized EvaluationMemoryAccess acquireAccessToMemoryFile(String memoryFilePath) throws IOException {
        if (this.memoryFilesInUse.contains(memoryFilePath)) {
            throw new IOException(StringUtils.format((String)"Failed to give read access to memory file: '%s', because it seems to be already in use by another 'Evaluation Memory' component", (Object[])new Object[]{memoryFilePath}));
        }
        this.memoryFilesInUse.add(memoryFilePath);
        EvaluationMemoryFileAccessImpl memoryAccess = new EvaluationMemoryFileAccessImpl(memoryFilePath);
        memoryAccess.setTypedDatumSerializer(this.typedDatumSerializer);
        return memoryAccess;
    }

    @Override
    public synchronized boolean releaseAccessToMemoryFile(String memoryFilePath) {
        return this.memoryFilesInUse.remove(memoryFilePath);
    }

    protected void bindTypedDatumService(TypedDatumService service) {
        this.typedDatumSerializer = service.getSerializer();
    }
}

