/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.api;

import de.rcenvironment.core.component.model.api.ComponentColor;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentShape;
import de.rcenvironment.core.component.model.api.ComponentSize;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationExtensionDefinition;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationDefinitionImpl;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationExtensionDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDefinitionsProviderImpl;
import de.rcenvironment.core.component.model.impl.ComponentInterfaceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ComponentInterfaceBuilder {
    private final ComponentInterfaceImpl componentInterface = new ComponentInterfaceImpl();

    public ComponentInterfaceBuilder setIdentifier(String identifier) {
        this.componentInterface.setIdentifier(identifier);
        ArrayList<String> identifiers = new ArrayList<String>();
        identifiers.add(identifier);
        this.componentInterface.setIdentifiers(identifiers);
        return this;
    }

    public ComponentInterfaceBuilder setIdentifiers(List<String> identifiers) {
        this.componentInterface.setIdentifiers(identifiers);
        return this;
    }

    public ComponentInterfaceBuilder setDisplayName(String displayName) {
        this.componentInterface.setDisplayName(displayName);
        return this;
    }

    public ComponentInterfaceBuilder setGroupName(String groupName) {
        this.componentInterface.setGroupName(groupName);
        return this;
    }

    public ComponentInterfaceBuilder setIcon16(byte[] icon16) {
        this.componentInterface.setIcon16(icon16);
        return this;
    }

    public ComponentInterfaceBuilder setIcon24(byte[] icon24) {
        this.componentInterface.setIcon24(icon24);
        return this;
    }

    public ComponentInterfaceBuilder setIcon32(byte[] icon32) {
        this.componentInterface.setIcon32(icon32);
        return this;
    }

    public ComponentInterfaceBuilder setDocumentationHash(String docuHash) {
        this.componentInterface.setDocumentationHash(docuHash);
        return this;
    }

    public ComponentInterfaceBuilder setVersion(String version) {
        this.componentInterface.setVersion(version);
        return this;
    }

    public ComponentInterfaceBuilder setColor(ComponentColor color) {
        this.componentInterface.setColor(color);
        return this;
    }

    public ComponentInterfaceBuilder setShape(ComponentShape shape) {
        this.componentInterface.setShape(shape);
        return this;
    }

    public ComponentInterfaceBuilder setSize(ComponentSize size) {
        this.componentInterface.setSize(size);
        return this;
    }

    public ComponentInterfaceBuilder setInputDefinitionsProvider(EndpointDefinitionsProvider inputDefinitionsProvider) {
        this.componentInterface.setInputDefinitionsProvider((EndpointDefinitionsProviderImpl)inputDefinitionsProvider);
        return this;
    }

    public ComponentInterfaceBuilder setOutputDefinitionsProvider(EndpointDefinitionsProvider outputDefinitionsProvider) {
        this.componentInterface.setOutputDefinitionsProvider((EndpointDefinitionsProviderImpl)outputDefinitionsProvider);
        return this;
    }

    public ComponentInterfaceBuilder setConfigurationDefinition(ConfigurationDefinition configurationDefinition) {
        this.componentInterface.setConfigurationDefinition((ConfigurationDefinitionImpl)configurationDefinition);
        return this;
    }

    public ComponentInterfaceBuilder setConfigurationExtensionDefinitions(Set<ConfigurationExtensionDefinition> configurationExtensionDefinitions) {
        HashSet<ConfigurationExtensionDefinitionImpl> configurationDefinitionsImpls = new HashSet<ConfigurationExtensionDefinitionImpl>();
        for (ConfigurationExtensionDefinition definition : configurationExtensionDefinitions) {
            configurationDefinitionsImpls.add((ConfigurationExtensionDefinitionImpl)definition);
        }
        this.componentInterface.setConfigurationExtensionDefinitions(configurationDefinitionsImpls);
        return this;
    }

    public ComponentInterfaceBuilder setLocalExecutionOnly(boolean localExecutionOnly) {
        this.componentInterface.setLocalExecutionOnly(localExecutionOnly);
        return this;
    }

    public ComponentInterfaceBuilder setPerformLazyDisposal(boolean performLazyDisposal) {
        this.componentInterface.setPerformLazyDisposal(performLazyDisposal);
        return this;
    }

    public ComponentInterfaceBuilder setCanHandleUndefinedInputDatums(ConfigurationDefinition configurationDefinition) {
        this.componentInterface.setConfigurationDefinition((ConfigurationDefinitionImpl)configurationDefinition);
        return this;
    }

    public ComponentInterfaceBuilder setCanHandleNotAValueDataTypes(boolean canHandleNotAValueDataTypes) {
        this.componentInterface.setCanHandleNotAValueDataTypes(canHandleNotAValueDataTypes);
        return this;
    }

    public ComponentInterface build() {
        return this.componentInterface;
    }
}

