/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.embedded.ssh.internal.SshConsoleOutputAdapter;
import java.util.ArrayList;
import java.util.List;

public class InteractiveShellHandler {
    private StringBuffer commandBuffer;
    private StringBuffer preBuffer;
    private List<String> oldCommands;
    private int pointerForOldCmds;
    private int pointerForCmdBuffer;
    private SshConsoleOutputAdapter sshConsoleHandler;

    public InteractiveShellHandler(SshConsoleOutputAdapter sshConsoleHandler) {
        this.fullReset();
        this.sshConsoleHandler = sshConsoleHandler;
    }

    public boolean processInputChar(int newCharCode) {
        boolean doPrint = false;
        int charCode = this.preProcessSpecialKeys(newCharCode);
        if (charCode >= 32 || charCode == 9) {
            char newChar = (char)charCode;
            if (charCode == 127) {
                if (this.pointerForCmdBuffer > 0) {
                    if (this.pointerForCmdBuffer < this.commandBuffer.length()) {
                        this.printToConsole(this.commandBuffer.substring(this.pointerForCmdBuffer + 1));
                    }
                    this.commandBuffer.deleteCharAt(this.pointerForCmdBuffer - 1);
                    --this.pointerForCmdBuffer;
                    doPrint = true;
                } else {
                    doPrint = false;
                }
            } else {
                if (this.pointerForCmdBuffer == this.commandBuffer.length()) {
                    this.commandBuffer.append(newChar);
                } else {
                    this.commandBuffer.insert(this.pointerForCmdBuffer, newChar);
                }
                ++this.pointerForCmdBuffer;
                doPrint = true;
            }
        }
        return doPrint;
    }

    private int preProcessSpecialKeys(int newCharCode) {
        int result = newCharCode;
        String temp = null;
        if (newCharCode == 27) {
            this.preBuffer = new StringBuffer();
            result = -1;
        } else if (this.preBuffer != null && newCharCode != 127) {
            this.preBuffer.append((char)newCharCode);
            temp = this.preBuffer.toString();
            if (temp.matches("\\[([A-D]?|([1-6]([~0-9]~?)?)?)")) {
                result = -1;
                this.handleKnownCodes(temp);
            } else {
                this.preBuffer = null;
            }
        }
        return result;
    }

    private void handleKnownCodes(String subject) {
        if (subject.matches("\\[D")) {
            this.preBuffer = null;
        } else if (subject.matches("\\[C")) {
            this.preBuffer = null;
        } else if (subject.matches("\\[3~")) {
            if (this.pointerForCmdBuffer < this.commandBuffer.length() - 1) {
                this.commandBuffer.deleteCharAt(this.pointerForCmdBuffer + 1);
                this.printToConsole(String.valueOf('\u001b') + subject);
            }
            this.preBuffer = null;
        } else if (subject.matches("\\[A")) {
            if (this.pointerForOldCmds > 0) {
                --this.pointerForOldCmds;
                this.scrollThroughHistory(this.oldCommands.get(this.pointerForOldCmds));
            }
            this.preBuffer = null;
        } else if (subject.matches("\\[B")) {
            if (this.pointerForOldCmds < this.oldCommands.size()) {
                ++this.pointerForOldCmds;
                if (this.pointerForOldCmds == this.oldCommands.size()) {
                    this.scrollThroughHistory("");
                } else {
                    this.scrollThroughHistory(this.oldCommands.get(this.pointerForOldCmds));
                }
            }
        } else if (subject.matches("\\[[12][0-9]~|\\[2~|\\[1~|\\[4~|\\[5~|\\[6~")) {
            this.preBuffer = null;
        }
    }

    public String getCurrentCommand() {
        String command = this.commandBuffer.toString();
        this.addToCommandHistory(command);
        this.reset();
        return command;
    }

    public void addToCommandHistory(String command) {
        this.oldCommands.add(command);
        if (this.oldCommands.size() > 20) {
            this.oldCommands.remove(0);
        } else {
            this.pointerForOldCmds = this.oldCommands.size();
        }
    }

    private void scrollThroughHistory(String newCommand) {
        char delete = '\u007f';
        String deleteString = "";
        int i = 0;
        while (i < this.commandBuffer.length()) {
            deleteString = String.valueOf(deleteString) + delete;
            ++i;
        }
        this.reset();
        this.commandBuffer.append(newCommand);
        this.pointerForCmdBuffer = this.commandBuffer.length();
        this.printToConsole(String.valueOf(deleteString) + newCommand);
    }

    private void fullReset() {
        this.oldCommands = new ArrayList<String>();
        this.pointerForOldCmds = 0;
        this.reset();
    }

    private void reset() {
        this.commandBuffer = new StringBuffer();
        this.preBuffer = null;
        this.pointerForCmdBuffer = 0;
    }

    private void printToConsole(String string) {
        this.sshConsoleHandler.addOutput(string, false, false);
    }
}

