/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.login.internal;

import de.rcenvironment.core.authentication.AuthenticationService;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.login.internal.SingleUserAutoLogin;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.utils.common.ServiceUtils;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class ServiceHandler {
    private static String bundleSymbolicName;
    private static AuthenticationService nullAuthenticationService;
    private static DistributedNotificationService nullNotificationService;
    private static ConfigurationService nullConfigurationService;
    private static AuthenticationService authenticationService;
    private static DistributedNotificationService notificationService;
    private static ConfigurationService configurationService;
    private static final Log LOGGER;

    static {
        nullAuthenticationService = (AuthenticationService)ServiceUtils.createFailingServiceProxy(AuthenticationService.class);
        nullNotificationService = (DistributedNotificationService)ServiceUtils.createFailingServiceProxy(DistributedNotificationService.class);
        nullConfigurationService = (ConfigurationService)ServiceUtils.createFailingServiceProxy(ConfigurationService.class);
        authenticationService = nullAuthenticationService;
        notificationService = nullNotificationService;
        configurationService = nullConfigurationService;
        LOGGER = LogFactory.getLog(ServiceHandler.class);
    }

    public void activate(BundleContext context) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        bundleSymbolicName = context.getBundle().getSymbolicName();
        new SingleUserAutoLogin().login();
        notificationService.send("de.rcenvironment.rce.login.success", (Serializable)((Object)"Anonymouslogin"));
        LOGGER.debug((Object)"Using anonymous/default login");
    }

    public void deactivate(BundleContext context) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        notificationService.removePublisher("de.rcenvironment.rce.login.success");
    }

    public void bindConfigurationService(ConfigurationService newConfigurationService) {
        configurationService = newConfigurationService;
    }

    public void bindAuthenticationService(AuthenticationService newAuthenticationService) {
        authenticationService = newAuthenticationService;
    }

    public void bindNotificationService(DistributedNotificationService newNotificationService) {
        notificationService = newNotificationService;
    }

    public void unbindConfigurationService(ConfigurationService oldConfigurationService) {
        configurationService = nullConfigurationService;
    }

    public void unbindAuthenticationService(AuthenticationService oldAuthenticationService) {
        authenticationService = nullAuthenticationService;
    }

    protected void unbindNotificationService(DistributedNotificationService oldNotificationService) {
        notificationService = nullNotificationService;
    }

    public static String getBundleSymbolicName() {
        return bundleSymbolicName;
    }

    public static ConfigurationService getConfigurationService() {
        return configurationService;
    }

    public static AuthenticationService getAuthenticationService() {
        return authenticationService;
    }

    public static DistributedNotificationService getNotificationService() {
        return notificationService;
    }
}

