/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.ssh.jsch;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessage;

public final class JschFileTransfer {
    private static final String SLASH = "/";
    private static final int SHORT_WAIT_MSEC = 100;

    private JschFileTransfer() {
    }

    public static void uploadFile(Session session, File localFile, String remotePath) throws IOException, JSchException {
        ScpToMessage message = new ScpToMessage(session, localFile, remotePath);
        message.execute();
    }

    public static void uploadDirectory(Session session, File directory, String remotePath) throws IOException, JSchException, InterruptedException {
        remotePath = String.valueOf(remotePath) + SLASH + directory.getName();
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        channel.setCommand("mkdir -p " + remotePath);
        channel.connect();
        while (!channel.isClosed()) {
            Thread.sleep(100L);
        }
        channel.disconnect();
        if (channel.getExitStatus() != 0) {
            throw new IOException("Creating directory failed: " + remotePath);
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                JschFileTransfer.uploadDirectory(session, file, remotePath);
            } else {
                JschFileTransfer.uploadFile(session, file, remotePath);
            }
            ++n2;
        }
    }

    public static void uploadDirectoryToRCEInstance(Session session, File directory, String remotePath) throws IOException, JSchException, InterruptedException {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                JschFileTransfer.uploadDirectoryToRCEInstance(session, file, String.valueOf(remotePath) + SLASH + file.getName());
            } else {
                JschFileTransfer.uploadFile(session, file, String.valueOf(remotePath) + SLASH + file.getName());
            }
            ++n2;
        }
    }

    public static void downloadFile(Session session, String remotePath, File localFile) throws IOException, JSchException {
        ScpFromMessage message = new ScpFromMessage(session, remotePath, localFile, false);
        message.execute();
    }

    public static void downloadDirectory(Session session, String remotePath, File localDir) throws IOException, JSchException {
        ScpFromMessage message = new ScpFromMessage(session, remotePath, localDir, true);
        message.execute();
    }

    public static void remoteToRemoteCopy(Session jschSession, String source, String target) throws JSchException, IOException, InterruptedException {
        String mkdirCommandPrefix = "";
        int separatorPos = target.lastIndexOf(SLASH);
        if (separatorPos >= 0) {
            String directoryPart = target.substring(0, separatorPos);
            mkdirCommandPrefix = "mkdir -p " + directoryPart + " && ";
        }
        ChannelExec channel = (ChannelExec)jschSession.openChannel("exec");
        String fullCommand = String.valueOf(mkdirCommandPrefix) + "cp " + source + " " + target;
        LogFactory.getLog(JschFileTransfer.class).debug((Object)("Performing remote copy: " + fullCommand));
        channel.setCommand(fullCommand);
        channel.connect();
        while (!channel.isClosed()) {
            Thread.sleep(100L);
        }
        channel.disconnect();
        if (channel.getExitStatus() != 0) {
            throw new IOException("Remote copy operation failed: " + source + " -> " + target);
        }
    }
}

