/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.configuration.internal;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.configuration.CommunicationConfiguration;
import de.rcenvironment.core.communication.configuration.CommunicationIPFilterConfiguration;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.configuration.SshConnectionsConfiguration;
import de.rcenvironment.core.communication.configuration.UplinkConnectionsConfiguration;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.model.impl.InitialNodeInformationImpl;
import de.rcenvironment.core.communication.sshconnection.InitialSshConnectionConfig;
import de.rcenvironment.core.communication.sshconnection.InitialUplinkConnectionConfig;
import de.rcenvironment.core.communication.utils.NetworkContactPointUtils;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.PersistentSettingsService;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class NodeConfigurationServiceImpl
implements NodeConfigurationService {
    private static final int STARTUP_INITIAL_CONNECT_DELAY_MSEC = 2500;
    private final List<NetworkContactPoint> serverContactPoints;
    private final List<NetworkContactPoint> initialNetworkPeers;
    private InitialNodeInformationImpl localNodeInformation;
    private CommunicationConfiguration configuration;
    private SshConnectionsConfiguration sshConfiguration;
    private UplinkConnectionsConfiguration uplinkConfiguration;
    private ConfigurationService configurationService;
    private PersistentSettingsService persistentSettingsService;
    private CommunicationIPFilterConfiguration ipFilterConfiguration;
    private boolean initialIPFilterConfigLoaded = false;
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean localNodeIsRelay;
    private InstanceNodeId localInstanceId;
    private NodeIdentifierService nodeIdentifierService;
    private InstanceNodeSessionId localInstanceSessionId;

    public NodeConfigurationServiceImpl() {
        this.serverContactPoints = new ArrayList<NetworkContactPoint>();
        this.initialNetworkPeers = new ArrayList<NetworkContactPoint>();
    }

    @Override
    public NodeIdentifierService getNodeIdentifierService() {
        return this.nodeIdentifierService;
    }

    @Override
    public InstanceNodeSessionId getInstanceNodeSessionId() {
        return this.localNodeInformation.getInstanceNodeSessionId();
    }

    @Override
    @Deprecated
    public boolean isWorkflowHost() {
        return this.configurationService.getIsWorkflowHost();
    }

    @Override
    public InitialNodeInformation getInitialNodeInformation() {
        return this.localNodeInformation;
    }

    @Override
    public List<NetworkContactPoint> getServerContactPoints() {
        return Collections.unmodifiableList(this.serverContactPoints);
    }

    @Override
    public List<NetworkContactPoint> getInitialNetworkContactPoints() {
        return Collections.unmodifiableList(this.initialNetworkPeers);
    }

    @Override
    public boolean isRelay() {
        return this.localNodeIsRelay;
    }

    @Override
    public long getDelayBeforeStartupConnectAttempts() {
        return 2500L;
    }

    @Override
    public int getRequestTimeoutMsec() {
        return this.configuration.getRequestTimeoutMsec();
    }

    @Override
    public int getForwardingTimeoutMsec() {
        return this.configuration.getForwardingTimeoutMsec();
    }

    @Override
    public CommunicationIPFilterConfiguration getIPFilterConfiguration() {
        if (this.initialIPFilterConfigLoaded) {
            this.configurationService.reloadConfiguration();
        } else {
            this.initialIPFilterConfigLoaded = true;
        }
        ConfigurationSegment configurationSegment = this.configurationService.getConfigurationSegment("network/ipFilter");
        try {
            this.ipFilterConfiguration = (CommunicationIPFilterConfiguration)configurationSegment.mapToObject(CommunicationIPFilterConfiguration.class);
        }
        catch (IOException e) {
            this.log.error((Object)"Error parsing IP filter configuration; falling back to blocking all IPs!", (Throwable)e);
            this.ipFilterConfiguration = new CommunicationIPFilterConfiguration();
            this.ipFilterConfiguration.setEnabled(true);
        }
        this.log.info((Object)StringUtils.format((String)"IP filter enabled: %s, configured number of IPs: %d", (Object[])new Object[]{this.ipFilterConfiguration.getEnabled(), this.ipFilterConfiguration.getAllowedIPs().size()}));
        return this.ipFilterConfiguration;
    }

    @Override
    public File getStandardImportDirectory(String subdir) {
        return this.configurationService.getStandardImportDirectory(subdir);
    }

    public void activate(BundleContext context) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        ConfigurationSegment configurationSegment = this.configurationService.getConfigurationSegment("network");
        this.configuration = new CommunicationConfiguration(configurationSegment);
        this.createLocalNodeInformation();
        this.parseNetworkConfiguration();
        this.localNodeIsRelay = this.configurationService.getIsRelay();
        this.log.info((Object)("Local 'isRelay' setting: " + this.isRelay()));
        ConfigurationSegment sshConfigurationSegment = this.configurationService.getConfigurationSegment("sshRemoteAccess");
        ConfigurationSegment uplinkConfigurationSegment = this.configurationService.getConfigurationSegment("uplink");
        this.sshConfiguration = new SshConnectionsConfiguration(sshConfigurationSegment);
        this.uplinkConfiguration = new UplinkConnectionsConfiguration(uplinkConfigurationSegment);
    }

    public void bindConfigurationService(ConfigurationService newService) {
        this.configurationService = newService;
    }

    public void bindNodeIdentifierService(NodeIdentifierService newService) {
        this.nodeIdentifierService = newService;
    }

    public void bindPersistentSettingsService(PersistentSettingsService newService) {
        this.persistentSettingsService = newService;
    }

    private void createLocalNodeInformation() {
        String predefinedInstanceIdString = this.getStoredOrOverriddenInstanceId();
        if (predefinedInstanceIdString == null) {
            this.localInstanceId = this.nodeIdentifierService.generateInstanceNodeId();
            this.persistentSettingsService.saveStringValue("rce.network.nodeId", this.localInstanceId.getInstanceNodeIdString());
            this.log.info((Object)("Generated and stored id " + this.localInstanceId.getInstanceNodeIdString() + " for the local node"));
        } else {
            try {
                this.localInstanceId = this.nodeIdentifierService.parseInstanceNodeIdString(predefinedInstanceIdString);
                this.log.info((Object)("Reusing the previously stored id " + predefinedInstanceIdString + " for the local node"));
            }
            catch (IdentifierException identifierException) {
                throw new IllegalStateException("Invalid stored or overridden instance id '" + predefinedInstanceIdString + "'; aborting to avoid running with an inconsistent state");
            }
        }
        this.localInstanceSessionId = this.nodeIdentifierService.generateInstanceNodeSessionId(this.localInstanceId);
        String instanceName = this.configurationService.getInstanceName();
        this.localNodeInformation = new InitialNodeInformationImpl(this.localInstanceSessionId);
        this.localNodeInformation.setDisplayName(instanceName);
    }

    private String getStoredOrOverriddenInstanceId() {
        String nodeId = System.getProperty("rce.network.overrideNodeId");
        if (nodeId != null) {
            this.log.info((Object)("Using custom node id defined by system property: " + nodeId));
        }
        if (nodeId == null && (nodeId = this.configuration.getNodeIdOverrideValue()) != null) {
            this.log.info((Object)("Using custom node id defined by profile setting: " + nodeId));
        }
        if (nodeId == null) {
            nodeId = this.persistentSettingsService.readStringValue("rce.network.nodeId");
        }
        return nodeId;
    }

    private void parseNetworkConfiguration() {
        List<String> serverContactPointDefs = this.configuration.getProvidedContactPoints();
        this.log.info((Object)("Parsing " + serverContactPointDefs.size() + " server port entries"));
        for (String contactPointDef : serverContactPointDefs) {
            try {
                NetworkContactPoint ncp = NetworkContactPointUtils.parseStringRepresentation(contactPointDef);
                this.log.debug((Object)("Adding configured server NCP " + ncp));
                this.serverContactPoints.add(ncp);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.error((Object)("Unable to parse contact point definition: " + contactPointDef));
            }
        }
        List<String> remoteContactPointDefs = this.configuration.getRemoteContactPoints();
        this.log.info((Object)("Parsing " + remoteContactPointDefs.size() + " network connection entries"));
        for (String contactPointDef : remoteContactPointDefs) {
            try {
                NetworkContactPoint ncp = NetworkContactPointUtils.parseStringRepresentation(contactPointDef);
                this.log.debug((Object)("Adding configured remote NCP " + ncp));
                this.initialNetworkPeers.add(ncp);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.error((Object)("Unable to parse contact point definition: " + contactPointDef));
            }
        }
    }

    @Override
    public List<InitialSshConnectionConfig> getInitialSSHConnectionConfigs() {
        return this.sshConfiguration.getProvidedConnectionConfigs();
    }

    @Override
    public double[] getLocationCoordinates() {
        return this.configurationService.getLocationCoordinates();
    }

    @Override
    public String getLocationName() {
        return this.configurationService.getLocationName();
    }

    @Override
    public String getInstanceContact() {
        return this.configurationService.getInstanceContact();
    }

    @Override
    public String getInstanceAdditionalInformation() {
        return this.configurationService.getInstanceAdditionalInformation();
    }

    @Override
    public List<InitialUplinkConnectionConfig> getInitialUplinkConnectionConfigs() {
        return this.uplinkConfiguration.getProvidedConnectionConfigs();
    }
}

