/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.toolintegration;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.integration.common.PathChooserButtonListener;
import de.rcenvironment.core.gui.integration.toolintegration.Messages;
import de.rcenvironment.core.gui.integration.toolintegration.ToolIntegrationWizard;
import de.rcenvironment.core.gui.integration.toolintegration.WizardEndpointEditDialog;
import de.rcenvironment.core.gui.integration.toolintegration.api.ToolIntegrationWizardPage;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jodd.mail.EmailAddress;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class InOutputConfigurationPage
extends ToolIntegrationWizardPage {
    public static final String FOLDER = "endpointFolder";
    public static final String DATA_TYPE = "endpointDataType";
    public static final String NAME = "endpointName";
    public static final String FILENAME = "endpointFileName";
    public static final String USAGE = "endpointUsage";
    public static final String HANDLING = "inputHandling";
    public static final String CONSTRAINT = "inputExecutionConstraint";
    public static final String DEFAULT_HANDLING = "defaultInputHandling";
    public static final String DEFAULT_CONSTRAINT = "defaultInputExecutionConstraint";
    public static final String INPUTS = "inputs";
    private static final String HELP_CONTEXT_ID = "de.rcenvironment.core.gui.wizard.toolintegration.integration_inputOutput";
    private static final String OUTPUTS = "outputs";
    private Map<String, Object> configurationMap;
    private ButtonSelectionListener btnSelectionListener;
    private Table inputTable;
    private Table outputTable;
    private Table activTable;
    private Button waitForVerificationButton;
    private Button defaultTokenLocationButton;
    private Button customTokenLocationButton;
    private Text customTokenLocationText;
    private Button chooseCustomTokenLocationButton;
    private Button sendMailButton;
    private Text emailReciepientsText;
    private boolean validateVerificationTab = true;

    protected InOutputConfigurationPage(String pageName, Map<String, Object> configurationMap) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.inoutputPageDescription);
        this.configurationMap = configurationMap;
        if (configurationMap.get(INPUTS) == null) {
            configurationMap.put(INPUTS, new LinkedList());
        }
        if (configurationMap.get(OUTPUTS) == null) {
            configurationMap.put(OUTPUTS, new LinkedList());
        }
    }

    public void createControl(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        this.inputTable = this.createEndpointTableTab(Messages.inputs, INPUTS, tabFolder);
        this.outputTable = this.createEndpointTableTab(Messages.outputs, OUTPUTS, tabFolder);
        this.createResultVerificationTab(tabFolder);
        this.updateTable(INPUTS);
        this.updateTable(OUTPUTS);
        this.fillContextMenu(this.inputTable);
        this.fillContextMenu(this.outputTable);
        tabFolder.setSelection(0);
        this.setControl((Control)tabFolder);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HELP_CONTEXT_ID);
        this.setPageComplete(true);
    }

    private Table createEndpointTableTab(String name, final String type, CTabFolder tabFolder) {
        CTabItem item = new CTabItem(tabFolder, 0);
        item.setText(name);
        Composite client = new Composite((Composite)tabFolder, 0);
        client.setLayout((Layout)new GridLayout(2, false));
        item.setControl((Control)client);
        Composite tableComposite = new Composite(client, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        final Table table = new Table(tableComposite, 68356);
        table.setHeaderVisible(true);
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 5);
        tableLayoutData.heightHint = 140;
        tableComposite.setLayoutData((Object)tableLayoutData);
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText(name.substring(0, name.length() - 1));
        TableColumn col2 = new TableColumn(table, 0);
        col2.setText(Messages.dataType);
        TableColumn col3 = null;
        TableColumn col4 = null;
        if (type.equals(INPUTS)) {
            col3 = new TableColumn(table, 0);
            col3.setText(Messages.inputHandling);
            col4 = new TableColumn(table, 0);
            col4.setText(Messages.inputExecutionConstraint);
            table.setData((Object)INPUTS);
        } else {
            table.setData((Object)"output");
        }
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(20, true));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(20, true));
        if (type.equals(INPUTS)) {
            tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(20, true));
            tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(20, true));
        }
        Button buttonAdd = new Button(client, 0x800000);
        buttonAdd.setText(Messages.add);
        buttonAdd.setLayoutData((Object)new GridData(4, 128, false, false));
        buttonAdd.addSelectionListener((SelectionListener)new ButtonSelectionListener(buttonAdd, table, name.toLowerCase()));
        Button buttonEdit = new Button(client, 0x800000);
        buttonEdit.setText(Messages.edit);
        buttonEdit.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnSelectionListener = new ButtonSelectionListener(buttonEdit, table, name.toLowerCase());
        buttonEdit.addSelectionListener((SelectionListener)this.btnSelectionListener);
        buttonEdit.setEnabled(false);
        Button buttonRemove = new Button(client, 0x800000);
        buttonRemove.setText(Messages.remove);
        buttonRemove.setLayoutData((Object)new GridData(4, 128, false, false));
        buttonRemove.addSelectionListener((SelectionListener)new ButtonSelectionListener(buttonRemove, table, name.toLowerCase()));
        buttonRemove.setEnabled(false);
        table.addSelectionListener((SelectionListener)new TableSelectionListener(table, buttonEdit, buttonRemove));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selection = table.getSelection();
                InOutputConfigurationPage.this.editInputOutput(selection, type);
            }

            public void mouseDown(MouseEvent e) {
                InOutputConfigurationPage.this.activTable = table;
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TableItem[] selection = table.getSelection();
                    InOutputConfigurationPage.this.removeInputOutput(selection, type);
                }
            }
        });
        return table;
    }

    private void updateButtonActivation(Table table, Button edit, Button remove) {
        boolean enabled = table.getSelection() != null && table.getSelectionCount() > 0 && table.getItemCount() != 0;
        edit.setEnabled(enabled);
        remove.setEnabled(enabled);
    }

    private void fillTable(String type) {
        Table table = type.equals(INPUTS) ? this.inputTable : this.outputTable;
        table.removeAll();
        List staticEndpoints = (List)this.configurationMap.get(type);
        this.fillCells(staticEndpoints, table, type);
    }

    private void fillCells(List<Map<String, String>> staticEndpoints, Table table, String type) {
        if (staticEndpoints != null) {
            TreeMap<String, Map<String, String>> endpointNames = new TreeMap<String, Map<String, String>>();
            for (Map<String, String> map : staticEndpoints) {
                endpointNames.put(map.get(NAME), map);
            }
            for (Map.Entry entry : endpointNames.entrySet()) {
                int n;
                int n2;
                String[] stringArray;
                String text;
                Map endpoint = (Map)entry.getValue();
                TableItem item = new TableItem(table, 0);
                item.setText(0, (String)endpoint.get(NAME));
                item.setText(1, DataType.valueOf((String)((String)endpoint.get(DATA_TYPE))).getDisplayName());
                if (!type.equals(INPUTS)) continue;
                if (endpoint.containsKey(HANDLING)) {
                    text = "";
                    stringArray = StringUtils.splitAndUnescape((String)((String)endpoint.get(HANDLING)));
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        String handling = stringArray[n];
                        text = String.valueOf(text) + EndpointDefinition.InputDatumHandling.valueOf((String)handling).getDisplayName();
                        text = String.valueOf(text) + ", ";
                        ++n;
                    }
                    item.setText(2, text.substring(0, text.length() - 2));
                } else if (endpoint.containsKey(USAGE) && ((String)endpoint.get(USAGE)).equals("initial")) {
                    item.setText(2, EndpointDefinition.InputDatumHandling.Constant.getDisplayName());
                } else {
                    item.setText(2, EndpointDefinition.InputDatumHandling.Single.getDisplayName());
                }
                if (endpoint.containsKey(CONSTRAINT)) {
                    text = "";
                    stringArray = StringUtils.splitAndUnescape((String)((String)endpoint.get(CONSTRAINT)));
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        String constraint = stringArray[n];
                        text = String.valueOf(text) + EndpointDefinition.InputExecutionContraint.valueOf((String)constraint).getDisplayName();
                        text = String.valueOf(text) + ", ";
                        ++n;
                    }
                    item.setText(3, text.substring(0, text.length() - 2));
                    continue;
                }
                if (endpoint.containsKey(USAGE) && ((String)endpoint.get(USAGE)).equals("optional")) {
                    item.setText(3, EndpointDefinition.InputExecutionContraint.NotRequired.getDisplayName());
                    continue;
                }
                item.setText(3, EndpointDefinition.InputExecutionContraint.Required.getDisplayName());
            }
        }
    }

    private List<String> getAllEndpointNames(String type) {
        LinkedList<String> result = new LinkedList<String>();
        List inputEndpoints = (List)this.configurationMap.get(type);
        if (inputEndpoints != null) {
            for (Object endpoint : inputEndpoints) {
                Map endpointMap = (Map)endpoint;
                result.add((String)endpointMap.get(NAME));
            }
        }
        return result;
    }

    protected void updateTable(String name) {
        this.fillTable(name);
    }

    private void createResultVerificationTab(CTabFolder tabFolder) {
        CTabItem item = new CTabItem(tabFolder, 0);
        item.setText("Verification");
        Composite client = new Composite((Composite)tabFolder, 0);
        client.setLayout((Layout)new GridLayout(1, false));
        item.setControl((Control)client);
        this.waitForVerificationButton = new Button(client, 32);
        this.waitForVerificationButton.setText("Wait for manual output approval (allows manual tool result review and verification)");
        Label label = new Label(client, 64);
        label.setText("Output values are only sent further if they are approved manually. For that, a so called verification key is generated after tool execution.\nWith the key, the tool results can either be approved or rejected with a dialog under 'Run -> Verify tool results...'.   ");
        Group tokenGroup = new Group(client, 0);
        tokenGroup.setText("Verification Key");
        tokenGroup.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 0, true, false);
        tokenGroup.setLayoutData((Object)layoutData);
        this.defaultTokenLocationButton = new Button((Composite)tokenGroup, 16);
        this.defaultTokenLocationButton.setText("Store verification key in tool working directory (default)");
        this.defaultTokenLocationButton.setSelection(true);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.defaultTokenLocationButton.setLayoutData((Object)layoutData);
        this.customTokenLocationButton = new Button((Composite)tokenGroup, 16);
        this.customTokenLocationButton.setText("Store verification key at custom location (on the tool's machine)");
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.customTokenLocationButton.setLayoutData((Object)layoutData);
        this.customTokenLocationText = new Text((Composite)tokenGroup, 2048);
        layoutData = new GridData(4, 0, true, false);
        this.customTokenLocationText.setLayoutData((Object)layoutData);
        this.chooseCustomTokenLocationButton = new Button((Composite)tokenGroup, 8);
        this.chooseCustomTokenLocationButton.setText("  ...  ");
        this.chooseCustomTokenLocationButton.addSelectionListener((SelectionListener)new PathChooserButtonListener(this.customTokenLocationText, true, this.getShell()));
        this.sendMailButton = new Button((Composite)tokenGroup, 32);
        this.sendMailButton.setText("Send verification key via email (provide addresses below separated by ';')");
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.sendMailButton.setLayoutData((Object)layoutData);
        this.emailReciepientsText = new Text((Composite)tokenGroup, 2048);
        layoutData = new GridData(4, 0, true, false);
        layoutData.horizontalSpan = 2;
        this.emailReciepientsText.setLayoutData((Object)layoutData);
        this.setupVerificationTabListener();
        this.setEnabledStateForVerificationTabElements();
    }

    private void setupVerificationTabListener() {
        this.customTokenLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                InOutputConfigurationPage.this.validateVerificationTabAndStoreValues();
            }
        });
        this.customTokenLocationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                InOutputConfigurationPage.this.setEnabledStateForCustomVerificationTokenText();
                InOutputConfigurationPage.this.validateVerificationTabAndStoreValues();
            }
        });
        this.emailReciepientsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                InOutputConfigurationPage.this.validateVerificationTabAndStoreValues();
            }
        });
        this.sendMailButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                InOutputConfigurationPage.this.setEnabledStateForEmailRecipientText();
                InOutputConfigurationPage.this.validateVerificationTabAndStoreValues();
            }
        });
        this.waitForVerificationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                InOutputConfigurationPage.this.setEnabledStateForVerificationTabElements();
                InOutputConfigurationPage.this.validateVerificationTabAndStoreValues();
            }
        });
    }

    private void setEnabledStateForEmailRecipientText() {
        boolean enabled = this.waitForVerificationButton.getSelection() && this.sendMailButton.getSelection();
        this.emailReciepientsText.setEnabled(enabled);
    }

    private void setEnabledStateForCustomVerificationTokenText() {
        boolean enabled = this.waitForVerificationButton.getSelection() && this.customTokenLocationButton.getSelection();
        this.customTokenLocationText.setEnabled(enabled);
        this.chooseCustomTokenLocationButton.setEnabled(enabled);
    }

    private void setEnabledStateForVerificationTabElements() {
        boolean enabled = this.waitForVerificationButton.getSelection();
        this.defaultTokenLocationButton.setEnabled(enabled);
        this.customTokenLocationButton.setEnabled(enabled);
        this.customTokenLocationText.setEnabled(this.customTokenLocationButton.getSelection() && enabled);
        this.chooseCustomTokenLocationButton.setEnabled(this.customTokenLocationButton.getSelection() && enabled);
        this.sendMailButton.setEnabled(enabled);
        this.emailReciepientsText.setEnabled(this.sendMailButton.getSelection() && enabled);
    }

    private void updateVerificationTab() {
        boolean waitForVerification = this.configurationMap.containsKey("requiresOutputApproval") && (Boolean)this.configurationMap.get("requiresOutputApproval") != false;
        this.waitForVerificationButton.setSelection(waitForVerification);
        String customTokenLocation = (String)this.configurationMap.get("verificationKeyLocation");
        if (customTokenLocation != null && !customTokenLocation.isEmpty()) {
            this.customTokenLocationButton.setSelection(true);
            this.customTokenLocationText.setText(customTokenLocation);
            this.defaultTokenLocationButton.setSelection(false);
        } else {
            this.defaultTokenLocationButton.setSelection(true);
            this.customTokenLocationButton.setSelection(false);
        }
        String emailRecipients = (String)this.configurationMap.get("verificationKeyEmailRecipients");
        if (emailRecipients != null && !emailRecipients.isEmpty()) {
            this.sendMailButton.setSelection(true);
            this.emailReciepientsText.setText(emailRecipients);
        }
        this.setEnabledStateForVerificationTabElements();
    }

    private void validateVerificationTabAndStoreValues() {
        if (!this.validateVerificationTab) {
            return;
        }
        boolean validated = true;
        if (this.waitForVerificationButton.getSelection()) {
            if (this.sendMailButton.getSelection()) {
                if (this.emailReciepientsText.getText().isEmpty()) {
                    this.setMessage("Provide at least one email address.", 3);
                    validated = false;
                } else {
                    String[] stringArray = this.emailReciepientsText.getText().split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String emailAddress = stringArray[n2];
                        if (!emailAddress.replaceAll("\\s+", "").isEmpty() && !new EmailAddress(emailAddress.trim()).isValid()) {
                            this.setMessage("Email address not valid: " + emailAddress.trim(), 3);
                            validated = false;
                        }
                        ++n2;
                    }
                }
            }
            if (this.customTokenLocationButton.getSelection() && (this.customTokenLocationText.getText().trim().isEmpty() || !new File(this.customTokenLocationText.getText().trim()).isAbsolute())) {
                this.setMessage("Provide location for verification key (absolute path required).", 3);
                validated = false;
            }
        }
        if (validated) {
            this.setMessage(null, 0);
            this.configurationMap.put("requiresOutputApproval", this.waitForVerificationButton.getSelection());
            if (this.customTokenLocationButton.getSelection()) {
                this.configurationMap.put("verificationKeyLocation", this.customTokenLocationText.getText().trim());
            } else {
                this.configurationMap.remove("verificationKeyLocation");
            }
            if (this.sendMailButton.getSelection()) {
                this.configurationMap.put("verificationKeyEmailRecipients", this.emailReciepientsText.getText().trim());
            } else {
                this.configurationMap.remove("verificationKeyEmailRecipients");
            }
        }
        this.setPageComplete(validated);
    }

    @Override
    public void setConfigMap(Map<String, Object> newConfigurationMap) {
        this.configurationMap = newConfigurationMap;
        this.validateVerificationTab = false;
        this.updatePageValues();
        this.validateVerificationTab = true;
    }

    private void updatePageValues() {
        this.updateTable(INPUTS);
        this.updateTable(OUTPUTS);
        this.updateVerificationTab();
    }

    public void performHelp() {
        super.performHelp();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    private void addInputOutput(String type) {
        String title = String.valueOf(type.substring(0, 1).toUpperCase()) + type.substring(1, type.length() - 1);
        WizardEndpointEditDialog weed = new WizardEndpointEditDialog(null, String.valueOf(Messages.add) + " " + title, type, this.getAllEndpointNames(type));
        int exit = weed.open();
        if (exit == 0) {
            if ((List)this.configurationMap.get(type) == null) {
                this.configurationMap.put(type, new LinkedList());
            }
            ((List)this.configurationMap.get(type)).add(weed.getConfig());
            this.updateTable(type);
            ((ToolIntegrationWizard)this.getWizard()).updateAllPages();
        }
    }

    private void editInputOutput(TableItem[] selection, String type) {
        String title = String.valueOf(type.substring(0, 1).toUpperCase()) + type.substring(1, type.length() - 1);
        if (selection != null && selection.length > 0) {
            List endpointList = (List)this.configurationMap.get(type);
            Map oldConfig = null;
            HashMap<String, String> oldConfigCopy = new HashMap<String, String>();
            for (Map endpoint : endpointList) {
                if (endpoint.get(NAME) == null || !((String)endpoint.get(NAME)).equals(selection[0].getText())) continue;
                oldConfigCopy.putAll(endpoint);
                oldConfig = endpoint;
            }
            WizardEndpointEditDialog weed = new WizardEndpointEditDialog(null, String.valueOf(Messages.edit) + " " + title, type, oldConfigCopy, this.getAllEndpointNames(type));
            int exit = weed.open();
            if (exit == 0) {
                ((List)this.configurationMap.get(type)).remove(oldConfig);
                ((List)this.configurationMap.get(type)).add(weed.getConfig());
                this.updateTable(type);
                ((ToolIntegrationWizard)this.getWizard()).updateAllPages();
            }
        }
    }

    private void removeInputOutput(TableItem[] selection, String type) {
        if (selection != null && selection.length > 0) {
            List endpointList = (List)this.configurationMap.get(type);
            Map endpointToRemove = null;
            for (Map endpoint : endpointList) {
                if (endpoint.get(NAME) == null || !((String)endpoint.get(NAME)).equals(selection[0].getText())) continue;
                endpointToRemove = endpoint;
            }
            endpointList.remove(endpointToRemove);
            this.updateTable(type);
            ((ToolIntegrationWizard)this.getWizard()).updateAllPages();
        }
    }

    @Override
    public void updatePage() {
    }

    @Override
    protected void onAddClicked() {
        if (this.activTable.getData().equals(INPUTS)) {
            this.addInputOutput(INPUTS);
        } else {
            this.addInputOutput(OUTPUTS);
        }
    }

    @Override
    protected void onEditClicked() {
        TableItem[] selection = this.activTable.getSelection();
        if (this.activTable.getData().equals(INPUTS)) {
            this.editInputOutput(selection, INPUTS);
        } else {
            this.editInputOutput(selection, OUTPUTS);
        }
    }

    @Override
    protected void onRemoveClicked() {
        TableItem[] selection = this.activTable.getSelection();
        if (this.activTable.getData().equals(INPUTS)) {
            this.removeInputOutput(selection, INPUTS);
        } else {
            this.removeInputOutput(selection, OUTPUTS);
        }
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private final Button button;
        private final Table selectionTable;
        private final String type;

        ButtonSelectionListener(Button button, Table table, String name) {
            this.button = button;
            this.selectionTable = table;
            this.type = name;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            TableItem[] selection = this.selectionTable.getSelection();
            if (this.button.getText().equals(Messages.add)) {
                InOutputConfigurationPage.this.addInputOutput(this.type);
            } else if (this.button.getText().equals(Messages.edit)) {
                InOutputConfigurationPage.this.editInputOutput(selection, this.type);
            } else if (this.button.getText().equals(Messages.remove)) {
                InOutputConfigurationPage.this.removeInputOutput(selection, this.type);
            }
        }
    }

    private final class TableSelectionListener
    extends SelectionAdapter {
        private final Table table;
        private final Button editButton;
        private final Button removeButton;

        private TableSelectionListener(Table table, Button editButton, Button removeButton) {
            this.table = table;
            this.editButton = editButton;
            this.removeButton = removeButton;
        }

        public void widgetSelected(SelectionEvent e) {
            InOutputConfigurationPage.this.updateButtonActivation(this.table, this.editButton, this.removeButton);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

