/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.gui.workflow.editor.commands.BendpointCreateCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.BendpointDeleteCommand;
import de.rcenvironment.core.gui.workflow.editor.commands.BendpointMoveCommand;
import de.rcenvironment.core.gui.workflow.parts.ConnectionWrapper;
import de.rcenvironment.core.gui.workflow.parts.CustomConnectionBendpointTracker;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.handles.BendpointCreationHandle;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;

public class ConnectionBendpointEditPolicy
extends BendpointEditPolicy {
    private static final Log LOGGER = LogFactory.getLog(ConnectionBendpointEditPolicy.class);

    protected List createSelectionHandles() {
        List listOfHandles = super.createSelectionHandles();
        for (Object selectionHandle : listOfHandles) {
            CustomConnectionBendpointTracker tracker;
            int index;
            if (selectionHandle instanceof BendpointCreationHandle) {
                BendpointCreationHandle bendpointCreationHandle = (BendpointCreationHandle)selectionHandle;
                index = bendpointCreationHandle.getIndex();
                tracker = new CustomConnectionBendpointTracker((ConnectionEditPart)this.getHost(), index);
                tracker.setType("create bendpoint");
                bendpointCreationHandle.setDragTracker((DragTracker)tracker);
                continue;
            }
            if (!(selectionHandle instanceof BendpointMoveHandle)) continue;
            BendpointMoveHandle bendpointMoveHandle = (BendpointMoveHandle)selectionHandle;
            index = bendpointMoveHandle.getIndex();
            tracker = new CustomConnectionBendpointTracker((ConnectionEditPart)this.getHost(), index);
            tracker.setType("move bendpoint");
            bendpointMoveHandle.setDragTracker((DragTracker)tracker);
        }
        return listOfHandles;
    }

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        EditPart parent = request.getSource().getParent();
        if (parent == null) {
            return null;
        }
        Object model = ((ScalableFreeformRootEditPart)parent).getContents().getModel();
        if (model instanceof WorkflowDescription) {
            List<Connection> connections = this.getMatchingConnectionModelsForConnectionWrapper((ConnectionWrapper)request.getSource().getModel());
            List<Connection> connectionsInverse = this.getMatchingInverseConnectionModelsForConnectionWrapper((ConnectionWrapper)request.getSource().getModel());
            BendpointCreateCommand command = new BendpointCreateCommand();
            Point translatedPoint = this.getTranslatedPointByViewersOffset(request);
            command.setConnectionsInModel(connections);
            command.setConnectionsInModelInverse(connectionsInverse);
            command.setReferencedwrapper((ConnectionWrapper)request.getSource().getModel());
            command.setWorkflowDescription((WorkflowDescription)model);
            command.setNewLocation(translatedPoint);
            command.setIndex(request.getIndex());
            return command;
        }
        return null;
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        EditPart parent = request.getSource().getParent();
        if (parent == null) {
            return null;
        }
        Object model = ((ScalableFreeformRootEditPart)parent).getContents().getModel();
        if (model instanceof WorkflowDescription) {
            List<Connection> connections = this.getMatchingConnectionModelsForConnectionWrapper((ConnectionWrapper)request.getSource().getModel());
            List<Connection> connectionsInverse = this.getMatchingInverseConnectionModelsForConnectionWrapper((ConnectionWrapper)request.getSource().getModel());
            BendpointDeleteCommand command = new BendpointDeleteCommand();
            command.setConnectionsInModel(connections);
            command.setConnectionsInModelInverse(connectionsInverse);
            command.setReferencedwrapper((ConnectionWrapper)request.getSource().getModel());
            command.setWorkflowDescription((WorkflowDescription)model);
            command.setIndex(request.getIndex());
            return command;
        }
        return null;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        EditPart parent = request.getSource().getParent();
        if (parent == null) {
            return null;
        }
        Object model = ((ScalableFreeformRootEditPart)parent).getContents().getModel();
        if (model instanceof WorkflowDescription) {
            List<Connection> connections = this.getMatchingConnectionModelsForConnectionWrapper((ConnectionWrapper)request.getSource().getModel());
            List<Connection> connectionsInverse = this.getMatchingInverseConnectionModelsForConnectionWrapper((ConnectionWrapper)request.getSource().getModel());
            BendpointMoveCommand command = new BendpointMoveCommand();
            Point translatedPoint = this.getTranslatedPointByViewersOffset(request);
            command.setConnectionsInModel(connections);
            command.setConnectionsInModelInverse(connectionsInverse);
            command.setReferencedwrapper((ConnectionWrapper)request.getSource().getModel());
            command.setWorkflowDescription((WorkflowDescription)model);
            command.setNewLocation(translatedPoint);
            command.setIndex(request.getIndex());
            return command;
        }
        return null;
    }

    private List<Connection> getMatchingConnectionModelsForConnectionWrapper(ConnectionWrapper connectionWrapper) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Object parent = this.getHost().getParent().getViewer().getContents().getModel();
        WorkflowDescription description = null;
        if (parent instanceof WorkflowDescription) {
            description = (WorkflowDescription)parent;
            for (Connection connectionInModel : description.getConnections()) {
                if (!connectionWrapper.getSource().getIdentifierAsObject().equals((Object)connectionInModel.getSourceNode().getIdentifierAsObject()) || !connectionWrapper.getTarget().getIdentifierAsObject().equals((Object)connectionInModel.getTargetNode().getIdentifierAsObject())) continue;
                connections.add(connectionInModel);
            }
        } else {
            LOGGER.debug((Object)("Model's type is not WorkflowDescription, but " + parent.getClass()));
        }
        return connections;
    }

    private List<Connection> getMatchingInverseConnectionModelsForConnectionWrapper(ConnectionWrapper connectionWrapper) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Object parent = this.getHost().getParent().getViewer().getContents().getModel();
        WorkflowDescription description = null;
        if (parent instanceof WorkflowDescription) {
            description = (WorkflowDescription)parent;
            for (Connection connectionInModel : description.getConnections()) {
                if (!connectionWrapper.getSource().getIdentifierAsObject().equals((Object)connectionInModel.getTargetNode().getIdentifierAsObject()) || !connectionWrapper.getTarget().getIdentifierAsObject().equals((Object)connectionInModel.getSourceNode().getIdentifierAsObject())) continue;
                connections.add(connectionInModel);
            }
        } else {
            LOGGER.debug((Object)("Model's type is not WorkflowDescription, but " + parent.getClass()));
        }
        return connections;
    }

    private Point getTranslatedPointByViewersOffset(BendpointRequest request) {
        Point offsetPoint = ((FigureCanvas)((ScalableFreeformRootEditPart)request.getSource().getParent()).getContents().getViewer().getControl()).getViewport().getViewLocation();
        double zoomLevel = ((ScalableFreeformRootEditPart)request.getSource().getParent()).getZoomManager().getZoom();
        int coordinateWithOffsetAndZoomX = (int)((double)(request.getLocation().x + offsetPoint.x) / zoomLevel);
        int coordinateWithOffsetAndZoomY = (int)((double)(request.getLocation().y + offsetPoint.y) / zoomLevel);
        return new Point(coordinateWithOffsetAndZoomX, coordinateWithOffsetAndZoomY);
    }
}

