/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.headless.internal;

import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionContextImpl;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtendedHeadlessWorkflowExecutionContext
extends HeadlessWorkflowExecutionContextImpl {
    private final Log log = LogFactory.getLog(this.getClass());
    private final CountDownLatch workflowFinishedLatch;
    private final CountDownLatch consoleOutputFinishedLatch;
    private final CountDownLatch workflowDisposedLatch;
    private final List<Closeable> resourcesToCloseOnFinish = new ArrayList<Closeable>();
    private final List<NotificationSubscription> notificationSubscriptionsToUnsubscribeOnFinish = new ArrayList<NotificationSubscription>();
    private final long startTimestampMillis;
    private long executionDurationMillis;
    private WorkflowExecutionContext wfExeContext;
    private WorkflowState finalState;

    public ExtendedHeadlessWorkflowExecutionContext() {
        this.workflowFinishedLatch = new CountDownLatch(1);
        this.consoleOutputFinishedLatch = new CountDownLatch(1);
        this.workflowDisposedLatch = new CountDownLatch(1);
        this.startTimestampMillis = System.currentTimeMillis();
    }

    protected void setWorkflowExecutionContext(WorkflowExecutionContext wfExeCtx) {
        this.wfExeContext = wfExeCtx;
    }

    protected WorkflowExecutionContext getWorkflowExecutionContext() {
        return this.wfExeContext;
    }

    protected void addOutput(String verboseOutput) {
        this.addOutput(null, verboseOutput);
    }

    protected void addOutput(String compactOutput, String verboseOutput) {
        if (this.getTextOutputReceiver() != null) {
            if (this.isCompactOutput()) {
                if (compactOutput != null && !compactOutput.isEmpty()) {
                    this.getTextOutputReceiver().addOutput(compactOutput);
                }
            } else if (verboseOutput != null && !verboseOutput.isEmpty()) {
                this.getTextOutputReceiver().addOutput(verboseOutput);
            }
        }
    }

    public final void reportConsoleRowReceived(ConsoleRow consoleRow) {
        if (this.getSingleConsoleRowReceiver() != null) {
            this.getSingleConsoleRowReceiver().onConsoleRow(consoleRow);
        }
    }

    protected synchronized void reportWorkflowNotAliveAnymore(String errorMessage) {
        this.log.error((Object)StringUtils.format((String)"Final state of workflow '%s' (%s) is %s - %s", (Object[])new Object[]{this.getWorkflowExecutionContext().getInstanceName(), this.wfExeContext.getExecutionIdentifier(), WorkflowState.UNKNOWN.getDisplayName(), errorMessage}));
        this.finalState = WorkflowState.UNKNOWN;
        this.workflowFinishedLatch.countDown();
        this.consoleOutputFinishedLatch.countDown();
    }

    protected synchronized void reportWorkflowTerminated(WorkflowState newState) {
        if (this.finalState != null) {
            this.log.warn((Object)StringUtils.format((String)"Workflow '%s' (%s) was already marked as %s, new final state: %s (%s)", (Object[])new Object[]{this.getWorkflowExecutionContext().getInstanceName(), this.wfExeContext.getExecutionIdentifier(), this.finalState.getDisplayName(), newState.getDisplayName(), this.getWorkflowFile().getAbsolutePath()}));
        }
        this.finalState = newState;
        if (this.finalState != WorkflowState.FINISHED) {
            this.addOutput(StringUtils.format((String)"'%s' terminated abnormally: %s; check log and console output for details", (Object[])new Object[]{this.getWorkflowFile().getName(), this.finalState.getDisplayName()}));
        }
        this.log.debug((Object)StringUtils.format((String)"Workflow '%s' (%s) has terminated, final state: %s (%s)", (Object[])new Object[]{this.getWorkflowExecutionContext().getInstanceName(), this.wfExeContext.getExecutionIdentifier(), this.finalState.getDisplayName(), this.getWorkflowFile()}));
        this.executionDurationMillis = System.currentTimeMillis() - this.startTimestampMillis;
        this.workflowFinishedLatch.countDown();
    }

    public synchronized long getExecutionDuration() {
        return this.executionDurationMillis;
    }

    protected synchronized void reportWorkflowDisposed(WorkflowState newState) {
        this.log.debug((Object)StringUtils.format((String)"Workflow '%s' (%s) is done, disposed: %s (%s)", (Object[])new Object[]{this.getWorkflowExecutionContext().getInstanceName(), this.wfExeContext.getExecutionIdentifier(), newState == WorkflowState.DISPOSED, this.getWorkflowFile()}));
        this.workflowDisposedLatch.countDown();
    }

    public void reportConsoleOutputTerminated() {
        this.consoleOutputFinishedLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkflowState waitForTermination() throws InterruptedException {
        this.workflowFinishedLatch.await();
        this.consoleOutputFinishedLatch.await();
        ExtendedHeadlessWorkflowExecutionContext extendedHeadlessWorkflowExecutionContext = this;
        synchronized (extendedHeadlessWorkflowExecutionContext) {
            return this.finalState;
        }
    }

    protected void waitForDisposal() throws InterruptedException {
        this.workflowDisposedLatch.await();
    }

    protected synchronized void registerResourceToCloseOnFinish(Closeable resource) {
        this.resourcesToCloseOnFinish.add(resource);
    }

    protected synchronized void registerNotificationSubscriptionsToUnsubscribeOnFinish(NotificationSubscription subscriber) {
        this.notificationSubscriptionsToUnsubscribeOnFinish.add(subscriber);
    }

    protected void closeResourcesQuietly() {
        for (Closeable resource : this.getResourcesToCloseOnFinish()) {
            try {
                resource.close();
            }
            catch (IOException e) {
                this.log.warn((Object)StringUtils.format((String)"Error closing resource after end of workflow '%s' (%s) ", (Object[])new Object[]{this.wfExeContext.getInstanceName(), this.wfExeContext.getExecutionIdentifier()}), (Throwable)e);
            }
        }
    }

    protected void unsubscribeNotificationSubscribersQuietly(DistributedNotificationService notificationService) {
        for (NotificationSubscription subscription : this.getNotificationSubscribersToUnsubscribeOnFinish()) {
            try {
                notificationService.unsubscribe(subscription.notificationId, subscription.subscriber, subscription.nodeId);
            }
            catch (RemoteOperationException e) {
                this.log.warn((Object)StringUtils.format((String)"Failed to unsubscribe %s from notification service (workflow '%s' (%s)", (Object[])new Object[]{subscription.subscriber.getClass(), this.wfExeContext.getInstanceName(), this.wfExeContext.getExecutionIdentifier()}), (Throwable)e);
            }
        }
    }

    private synchronized List<Closeable> getResourcesToCloseOnFinish() {
        return new ArrayList<Closeable>(this.resourcesToCloseOnFinish);
    }

    private synchronized List<NotificationSubscription> getNotificationSubscribersToUnsubscribeOnFinish() {
        return new ArrayList<NotificationSubscription>(this.notificationSubscriptionsToUnsubscribeOnFinish);
    }

    protected class NotificationSubscription {
        protected NotificationSubscriber subscriber;
        protected String notificationId;
        protected ResolvableNodeId nodeId;

        protected NotificationSubscription() {
        }
    }
}

