/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.core.internal;

import de.rcenvironment.toolkit.core.api.Toolkit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ToolkitInstanceTracker {
    private static final ToolkitInstanceTracker sharedInstance = new ToolkitInstanceTracker();
    private final Set<Toolkit> activeInstances = new HashSet<Toolkit>();

    private ToolkitInstanceTracker() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    public static ToolkitInstanceTracker getInstance() {
        return sharedInstance;
    }

    public synchronized void register(Toolkit newInstance) {
        if (!this.activeInstances.add(newInstance)) {
            throw new IllegalArgumentException("This toolkit instance was already registered");
        }
    }

    public synchronized void markDisposed(Toolkit oldInstance) {
        if (!this.activeInstances.remove(oldInstance)) {
            throw new IllegalArgumentException("This toolkit instance was never registered or was already disposed");
        }
    }

    private synchronized void onJvmShutdown() {
        Log log = LogFactory.getLog(this.getClass());
        ArrayList<Toolkit> copyOfActiveInstancesList = new ArrayList<Toolkit>(this.activeInstances);
        int count = copyOfActiveInstancesList.size();
        if (count == 1) {
            log.debug((Object)"There is a single undisposed toolkit instance on JVM shutdown; this can be safely ignored after unit tests");
        } else if (count > 1) {
            log.warn((Object)("There are " + count + " undisposed toolkit instances left on JVM shutdown; these should be explicitly shut down instead if possible"));
        }
        if (count != 0) {
            log.debug((Object)("Shutting down " + count + " toolkit instance(s)"));
            for (Toolkit instance : copyOfActiveInstancesList) {
                instance.shutdown();
            }
        }
        if (this.activeInstances.size() != 0) {
            log.warn((Object)("Unexpected state: After disposing all toolkit instances, the tracking count is not zero, but " + this.activeInstances.size()));
        }
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            ToolkitInstanceTracker.this.onJvmShutdown();
        }
    }
}

