/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.jpedal;

import de.vonloesch.pdf4eclipse.model.IOutlineNode;
import de.vonloesch.pdf4eclipse.model.IPDFDestination;
import de.vonloesch.pdf4eclipse.model.jpedal.JPedalPDFDestination;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.raw.PdfObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JPedalOutlineNode
implements IOutlineNode {
    Node node;
    PdfDecoder decoder;

    public JPedalOutlineNode(Node n, PdfDecoder dec) {
        this.node = n;
        this.decoder = dec;
    }

    @Override
    public String getLabel() {
        Node namedItem = this.node.getAttributes().getNamedItem("title");
        return namedItem.getTextContent();
    }

    @Override
    public IOutlineNode getParent() {
        if (this.node.getParentNode() == null) {
            return null;
        }
        return new JPedalOutlineNode(this.node.getParentNode(), this.decoder);
    }

    @Override
    public IOutlineNode[] getChildren() {
        NodeList l = this.node.getChildNodes();
        IOutlineNode[] childs = new JPedalOutlineNode[l.getLength()];
        int i = 0;
        while (i < l.getLength()) {
            childs[i] = new JPedalOutlineNode(l.item(i), this.decoder);
            ++i;
        }
        return childs;
    }

    @Override
    public boolean hasChildren() {
        return this.node.hasChildNodes();
    }

    @Override
    public IPDFDestination getDestination() {
        String id = this.node.getAttributes().getNamedItem("objectRef").getTextContent();
        PdfObject o = this.decoder.getOutlineData().getAobj(id);
        if (o == null) {
            return null;
        }
        return new JPedalPDFDestination(o);
    }
}

