/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileUtils;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.start.common.validation.spi.InstanceValidator;
import java.io.File;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InstanceValidator.class})
public class ProfileDirectoriesAccessibleValidator
extends DefaultInstanceValidator {
    private static ConfigurationService configService;

    public InstanceValidationResult validate() {
        File commonProfileDir;
        try {
            commonProfileDir = ProfileUtils.getProfilesParentDirectory().toPath().resolve("common").toFile();
        }
        catch (ProfileException profileException) {
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)"Common profile not accessible", (String)"Could not open common profile.");
        }
        InstanceValidationResult commonProfileDirValidationResult = this.validateProfileDir(commonProfileDir);
        if (!InstanceValidationResult.InstanceValidationResultType.PASSED.equals((Object)commonProfileDirValidationResult.getType())) {
            return commonProfileDirValidationResult;
        }
        File originalProfileDir = configService.getOriginalProfileDirectory();
        return this.validateProfileDir(originalProfileDir);
    }

    private InstanceValidationResult validateProfileDir(File originalProfileDir) {
        if (!(originalProfileDir.exists() && originalProfileDir.isDirectory() && originalProfileDir.canRead() && originalProfileDir.canWrite())) {
            String errorMessage = "The specified profile folder " + originalProfileDir.getAbsolutePath() + " is either not readable or not writeable. Probably the proper permissions are not granted to your user account." + " Choose another profile directory. (See the user guide for more information about the profile directory.)";
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)"Profile folder not accessible.", (String)errorMessage, (String)errorMessage);
        }
        return InstanceValidationResultFactory.createResultForPassed((String)"Original profile directory is accessible.");
    }

    @Reference
    protected void bindConfigurationService(ConfigurationService configIn) {
        configService = configIn;
    }
}

