/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.model.internal;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PayloadTestFuzzer {
    public static final boolean ENABLED = false;
    private static final float MIN_P_TO_CORRUPT_PAYLOAD = 0.001f;
    private static final float MAX_P_TO_CORRUPT_PAYLOAD = 0.01f;
    private static final int PAYLOAD_SIZE_CEILING = 50000;
    private static final float P_INCREMENT_PER_BYTE = 1.7999999E-7f;
    private static final Random sharedRandom = new Random();
    private static final Log sharedLog = LogFactory.getLog(PayloadTestFuzzer.class);

    private PayloadTestFuzzer() {
    }

    public static void apply(byte[] payload) {
        int relevantSize = Math.min(payload.length, 50000);
        float p = 0.001f + (float)relevantSize * 1.7999999E-7f;
        int n = 0;
        while (sharedRandom.nextFloat() <= p) {
            int pos = sharedRandom.nextInt(payload.length);
            payload[pos] = (byte)sharedRandom.nextInt();
            ++n;
        }
        if (n > 0) {
            sharedLog.debug((Object)StringUtils.format((String)"Corrupted %d bytes of a payload at p=%.4f", (Object[])new Object[]{n, Float.valueOf(p)}));
        }
    }
}

