/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.common;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.common.NodeIdentifierTestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NodeIdentifierContextHolder {
    private static final String SERVICE_CLASS_NAME = NodeIdentifierService.class.getSimpleName();
    private static final transient ThreadLocal<NodeIdentifierService> sharedServiceThreadLocal = new ThreadLocal();
    private static volatile NodeIdentifierService defaultNodeIdentifierService;
    private static final Log sharedLog;

    static {
        sharedLog = LogFactory.getLog(NodeIdentifierContextHolder.class);
    }

    public static NodeIdentifierService setDeserializationServiceForCurrentThread(NodeIdentifierService serviceInstance) {
        NodeIdentifierService previous = sharedServiceThreadLocal.get();
        sharedServiceThreadLocal.set(serviceInstance);
        return previous;
    }

    public static NodeIdentifierService getRawDeserializationServiceForCurrentThread() {
        return sharedServiceThreadLocal.get();
    }

    public static NodeIdentifierService getDeserializationServiceForCurrentThread() {
        NodeIdentifierService result = sharedServiceThreadLocal.get();
        if (result == null) {
            if (defaultNodeIdentifierService != null) {
                return defaultNodeIdentifierService;
            }
            NodeIdentifierService testNodeIdentifierService = NodeIdentifierTestUtils.getTestNodeIdentifierService();
            if (testNodeIdentifierService != null) {
                sharedLog.warn((Object)("There is no " + SERVICE_CLASS_NAME + " instance registered for the current thread; falling back to the default test instance"));
                return testNodeIdentifierService;
            }
            throw new IllegalStateException("There is no " + SERVICE_CLASS_NAME + " instance registered for the current thread, which is required to deserialize distributed node identifiers, " + "and there is no global default instance (typical in test contexts); use " + NodeIdentifierContextHolder.class.getName() + " methods to fix this");
        }
        return result;
    }

    public synchronized void bindNodeIdentifierService(NodeIdentifierService newInstance) {
        if (defaultNodeIdentifierService != null) {
            throw new IllegalStateException("Tried to set a NodeIdentifierService instance, but it was already defined");
        }
        defaultNodeIdentifierService = newInstance;
        LogFactory.getLog(NodeIdentifierContextHolder.class).debug((Object)("Injected live " + newInstance.getClass() + " instance"));
    }

    public void transitionalDummy() {
    }
}

