/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function.internal;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import de.rcenvironment.core.workflow.execution.function.internal.InputAdapterNodeBuilder;
import de.rcenvironment.core.workflow.execution.function.internal.OutputAdapterNodeBuilder;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;

class WorkflowEditor {
    private final WorkflowDescription workflowDescription;
    private String inputDirectory;
    private String outputDirectory;
    private Collection<EndpointAdapter> inputAdapterDefinitions = new HashSet<EndpointAdapter>();
    private Collection<EndpointAdapter> outputAdapterDefinitions = new HashSet<EndpointAdapter>();
    private WorkflowNode inputAdapterNode;
    private WorkflowNode outputAdapterNode;

    WorkflowEditor(WorkflowDescription description) {
        this.workflowDescription = description;
    }

    public void addInputAdapter(EndpointAdapter definition) {
        assert (definition.isInputAdapter());
        this.inputAdapterDefinitions.add(definition);
    }

    public void addOutputAdapter(EndpointAdapter definition) {
        assert (definition.isOutputAdapter());
        this.outputAdapterDefinitions.add(definition);
    }

    public WorkflowDescription getResult() {
        if (!this.inputAdapterDefinitions.isEmpty()) {
            this.injectInputAdapterIntoWorkflow();
        }
        if (!this.outputAdapterDefinitions.isEmpty()) {
            this.injectOutputAdapterIntoWorkflow();
        }
        return this.workflowDescription;
    }

    private void injectInputAdapterIntoWorkflow() {
        InputAdapterNodeBuilder builder = new InputAdapterNodeBuilder().setHostId(this.workflowDescription.getControllerNode()).setInputDirectory(this.inputDirectory);
        for (EndpointAdapter definition : this.inputAdapterDefinitions) {
            builder.addExternalInputName(definition.getExternalName(), definition.getDataType());
        }
        this.inputAdapterNode = builder.build();
        this.workflowDescription.addWorkflowNode(this.inputAdapterNode);
        this.connectInputAdapter();
    }

    private void connectInputAdapter() {
        for (EndpointAdapter definition : this.inputAdapterDefinitions) {
            Connection adapterConnection = this.buildInputAdapterConnection(definition);
            this.workflowDescription.addConnection(adapterConnection);
        }
    }

    private Connection buildInputAdapterConnection(EndpointAdapter definition) {
        WorkflowNode adaptedWorkflowNode = this.workflowDescription.getWorkflowNodes().stream().filter(node -> node.getIdentifierAsObject().toString().equals(definition.getWorkflowNodeIdentifier())).findAny().get();
        HashSet adaptedInputs = new HashSet();
        EndpointDescriptionsManager inputDescriptionsManager = adaptedWorkflowNode.getInputDescriptionsManager();
        adaptedInputs.addAll(inputDescriptionsManager.getDynamicEndpointDescriptions());
        adaptedInputs.addAll(inputDescriptionsManager.getStaticEndpointDescriptions());
        if (adaptedInputs.isEmpty()) {
            throw new IllegalStateException(StringUtils.format((String)"Found no inputs to adapt on workflow node '%s'", (Object[])new Object[]{adaptedWorkflowNode}));
        }
        List potentialAdaptedInputs = adaptedInputs.stream().filter(input -> {
            LogFactory.getLog(this.getClass()).info((Object)StringUtils.format((String)"Checking input %s", (Object[])new Object[]{input.getName()}));
            return input.getName().equals(definition.getInternalName());
        }).collect(Collectors.toList());
        if (potentialAdaptedInputs.isEmpty()) {
            throw new IllegalStateException(StringUtils.format((String)"Found no inputs of name '%s' to adapt on workflow node '%s'", (Object[])new Object[]{definition.getInternalName(), adaptedWorkflowNode}));
        }
        if (potentialAdaptedInputs.size() > 1) {
            throw new IllegalStateException(StringUtils.format((String)"Found multiple inputs of name '%s' to adapt on workflow node '%s'", (Object[])new Object[]{definition.getInternalName(), adaptedWorkflowNode}));
        }
        EndpointDescription inputToAdapt = (EndpointDescription)potentialAdaptedInputs.get(0);
        EndpointDescription relevantInputAdapterOutput = this.inputAdapterNode.getOutputDescriptionsManager().getStaticEndpointDescriptions().stream().filter(endpointDescription -> endpointDescription.getName().equals(definition.getExternalName())).findAny().get();
        Connection adapterConnection = new Connection(this.inputAdapterNode, relevantInputAdapterOutput, adaptedWorkflowNode, inputToAdapt);
        return adapterConnection;
    }

    private void injectOutputAdapterIntoWorkflow() {
        OutputAdapterNodeBuilder builder = new OutputAdapterNodeBuilder().setHostId(this.workflowDescription.getControllerNode()).setOutputDirectory(this.outputDirectory);
        for (EndpointAdapter definition : this.outputAdapterDefinitions) {
            builder.addExternalOutputName(definition.getExternalName(), definition.getDataType());
        }
        this.outputAdapterNode = builder.build();
        this.workflowDescription.addWorkflowNode(this.outputAdapterNode);
        this.connectOutputAdapter();
    }

    private void connectOutputAdapter() {
        for (EndpointAdapter definition : this.outputAdapterDefinitions) {
            Connection adapterConnection = this.buildOutputAdapterConnection(definition);
            this.workflowDescription.addConnection(adapterConnection);
        }
    }

    private Connection buildOutputAdapterConnection(EndpointAdapter definition) {
        WorkflowNode adaptedWorkflowNode = this.workflowDescription.getWorkflowNodes().stream().filter(node -> node.getIdentifierAsObject().toString().equals(definition.getWorkflowNodeIdentifier())).findAny().get();
        HashSet adaptedOutputs = new HashSet();
        EndpointDescriptionsManager outputDescriptionsManager = adaptedWorkflowNode.getOutputDescriptionsManager();
        adaptedOutputs.addAll(outputDescriptionsManager.getDynamicEndpointDescriptions());
        adaptedOutputs.addAll(outputDescriptionsManager.getStaticEndpointDescriptions());
        if (adaptedOutputs.isEmpty()) {
            throw new IllegalStateException(StringUtils.format((String)"Found no outputs to adapt on workflow node '%s'", (Object[])new Object[]{adaptedWorkflowNode}));
        }
        List potentialAdaptedOutputs = adaptedOutputs.stream().filter(output -> output.getName().equals(definition.getInternalName())).collect(Collectors.toList());
        if (potentialAdaptedOutputs.isEmpty()) {
            throw new IllegalStateException(StringUtils.format((String)"Found no outputs of name '%s' to adapt on workflow node '%s'", (Object[])new Object[]{definition.getInternalName(), adaptedWorkflowNode}));
        }
        if (potentialAdaptedOutputs.size() > 1) {
            throw new IllegalStateException(StringUtils.format((String)"Found multiple outputs of name '%s' to adapt on workflow node '%s'", (Object[])new Object[]{definition.getInternalName(), adaptedWorkflowNode}));
        }
        EndpointDescription outputToAdapt = (EndpointDescription)potentialAdaptedOutputs.get(0);
        EndpointDescription relevantOutputAdapterInput = this.outputAdapterNode.getInputDescriptionsManager().getStaticEndpointDescriptions().stream().filter(endpointDescription -> endpointDescription.getName().equals(definition.getExternalName())).findAny().get();
        Connection adapterConnection = new Connection(adaptedWorkflowNode, outputToAdapt, this.outputAdapterNode, relevantOutputAdapterInput);
        return adapterConnection;
    }

    public static class Factory {
        private String inputDirectoryPath;
        private String outputDirectoryPath;

        public Factory setInputDirectory(File inputDirectory) {
            this.inputDirectoryPath = inputDirectory.getAbsolutePath();
            return this;
        }

        public Factory setOutputDirectory(File outputDirectory) {
            this.outputDirectoryPath = outputDirectory.getAbsolutePath();
            return this;
        }

        public WorkflowEditor buildFromWorkflowDescription(WorkflowDescription description) {
            WorkflowEditor product = new WorkflowEditor(description.clone());
            product.inputDirectory = this.inputDirectoryPath;
            product.outputDirectory = this.outputDirectoryPath;
            return product;
        }
    }
}

