/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.Location;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.gui.workflow.ConnectionUtils;
import de.rcenvironment.core.gui.workflow.parts.ConnectionWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.commands.Command;

public class BendpointDeleteAllCommand
extends Command {
    private static final String SOURCE_TARGET_SEPARATOR = ":";
    private List<Connection> connections = new ArrayList<Connection>();
    private ConnectionWrapper referencedWrapper;
    private WorkflowDescription workflowDescription;
    private Map<String, List<Location>> removedBendpointsPerConnection = new HashMap<String, List<Location>>();

    public void execute() {
        for (Connection connection : this.connections) {
            String key = String.valueOf(connection.getSourceNode().getIdentifierAsObject().toString()) + SOURCE_TARGET_SEPARATOR + connection.getTargetNode().getIdentifierAsObject().toString();
            this.removedBendpointsPerConnection.putIfAbsent(key, connection.getBendpoints());
            connection.removeAllBendpoints();
        }
        ConnectionUtils.validateConnectionWrapperForEqualBendpointLocations(this.workflowDescription, this.referencedWrapper, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " execute or redo");
    }

    public void undo() {
        for (String sourceTargetString : this.removedBendpointsPerConnection.keySet()) {
            String sourceId = sourceTargetString.split(SOURCE_TARGET_SEPARATOR)[0];
            String targetId = sourceTargetString.split(SOURCE_TARGET_SEPARATOR)[1];
            for (Connection connection : this.connections) {
                List<Object> bendpointsToRestore = new ArrayList();
                if (connection.getSourceNode().getIdentifierAsObject().toString().equals(sourceId) && connection.getTargetNode().getIdentifierAsObject().toString().equals(targetId)) {
                    bendpointsToRestore = this.removedBendpointsPerConnection.get(String.valueOf(sourceId) + SOURCE_TARGET_SEPARATOR + targetId);
                }
                connection.addBendpoints(bendpointsToRestore);
            }
        }
        ConnectionUtils.validateConnectionWrapperForEqualBendpointLocations(this.workflowDescription, this.referencedWrapper, String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " undo");
    }

    public void redo() {
        this.execute();
    }

    public void setConnections(List<Connection> connections) {
        this.connections = connections;
    }

    public void setReferencedModel(ConnectionWrapper referencedModel) {
        this.referencedWrapper = referencedModel;
    }

    public void setWorkflowDescription(WorkflowDescription workflowDescription) {
        this.workflowDescription = workflowDescription;
    }
}

