/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.helper;

import de.rcenvironment.extras.testscriptrunner.definitions.helper.CommonConnectionOptions;
import java.util.Optional;

public final class SSHConnectionOptions {
    private Optional<String> displayName = Optional.empty();
    private CommonConnectionOptions commonOptions = new CommonConnectionOptions();

    private SSHConnectionOptions() {
        this.setUserName("remote_access_user");
    }

    private void setConnectionName(String connectionName) {
        this.commonOptions.setConnectionName(connectionName);
    }

    private void setDisplayName(String displayName) {
        this.displayName = Optional.of(displayName);
    }

    private void setHost(String host) {
        this.commonOptions.setHost(host);
    }

    private void setPort(int port) {
        this.commonOptions.setPort(port);
    }

    private void setServerNumber(int serverNumber) {
        this.commonOptions.setServerNumber(serverNumber);
    }

    private void setUserName(String userName) {
        this.commonOptions.setUserName(userName);
    }

    private void setUserRole(String userRole) {
        this.commonOptions.setUserRole(userRole);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getConnectionName() {
        return this.commonOptions.getConnectionName();
    }

    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    public Optional<Integer> getPort() {
        return this.commonOptions.getPort();
    }

    public String getHost() {
        return this.commonOptions.getHost();
    }

    public Optional<String> getUserName() {
        return this.commonOptions.getUserName();
    }

    public Optional<String> getUserRole() {
        return this.commonOptions.getUserRole();
    }

    public int getServerNumber() {
        return this.commonOptions.getServerNumber();
    }

    public static class Builder {
        private SSHConnectionOptions options = new SSHConnectionOptions();

        Builder() {
        }

        public Builder connectionName(String connenctionNameValue) {
            this.options.setConnectionName(connenctionNameValue);
            return this;
        }

        public Builder displayName(String displayNameValue) {
            this.options.setDisplayName(displayNameValue);
            return this;
        }

        public Builder host(String hostValue) {
            this.options.setHost(hostValue);
            return this;
        }

        public Builder port(int portValue) {
            this.options.setPort(portValue);
            return this;
        }

        public Builder serverNumber(int serverNumberValue) {
            this.options.setServerNumber(serverNumberValue);
            return this;
        }

        public Builder userName(String userNameValue) {
            this.options.setUserName(userNameValue);
            return this;
        }

        public Builder userRole(String userRoleValue) {
            this.options.setUserRole(userRoleValue);
            return this;
        }

        public SSHConnectionOptions build() {
            return this.options;
        }
    }
}

