/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.headless.internal;

import de.rcenvironment.core.component.workflow.execution.api.FinalWorkflowState;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionVerificationRecorder;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionVerificationResult;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.LogFactory;

public final class HeadlessWorkflowExecutionVerification
implements HeadlessWorkflowExecutionVerificationRecorder,
HeadlessWorkflowExecutionVerificationResult {
    public static final String DATE_FORMAT = "yyyy-MM-dd - HH:mm:ss";
    public static final String FILE_SUFFIX_EXPECTED_LOG = ".log.expected";
    public static final String FILE_SUFFIX_PROHIBITED_LOG = ".log.prohibited";
    private static final String EMPTY_COLLECTION_STRING = "-";
    private static final int THOUSAND = 1000;
    private String wfFileRootDir = null;
    private final List<File> wfFilesSubmitted;
    private final int parallelRuns;
    private final int sequentialRuns;
    private Map<File, List<Long>> wfsWithExecutionDurationSec = new HashMap<File, List<Long>>();
    private Map<File, List<String>> wfsWithExpectedLogMessages = new HashMap<File, List<String>>();
    private Map<File, List<String>> wfsWithProhibitedLogMessages = new HashMap<File, List<String>>();
    private int wfsExpectedToFinishCount;
    private int wfsExpectedToFailCount;
    private List<File> wfsExpectedToFail = new ArrayList<File>();
    private int resultCount = 0;
    private int wfsFinishedAsExpectedCount = 0;
    private int wfsFailedAsExpectedCount = 0;
    private int wfsCanceledCount = 0;
    private int wfsWithErrorCount = 0;
    private int wfsWithUnexpectedFinalStateCount = 0;
    private int wfsWithUnexpectedMissingLogMessageCount = 0;
    private int wfsWithUnexpectedProhibitedLogMessageCount = 0;
    private Map<File, FinalWorkflowState> wfsWithUnexpectedFinalState = new HashMap<File, FinalWorkflowState>();
    private Map<File, String> wfsWithUnexpectedMissingLogMessage = new HashMap<File, String>();
    private Map<File, String> wfsWithUnexpectedProhibitedLogMessage = new HashMap<File, String>();
    private List<File> wfsCanceled = new ArrayList<File>();
    private Map<File, String> wfsWithError = new HashMap<File, String>();
    private List<File> wfRelatedFilesToDelete = new ArrayList<File>();
    private boolean verified = true;
    private Date startTime = null;
    private Date endTime = null;

    private HeadlessWorkflowExecutionVerification(String absolutePathToWorkflowRootDir, List<File> wfFilesExpectedToSucceed, List<File> wfFilesExpectedToFail, int parallelRuns, int sequentialRuns) {
        this.wfFilesSubmitted = Stream.concat(wfFilesExpectedToSucceed.stream(), wfFilesExpectedToFail.stream()).collect(Collectors.toList());
        this.parallelRuns = parallelRuns;
        this.sequentialRuns = sequentialRuns;
        this.wfFileRootDir = absolutePathToWorkflowRootDir;
        LogFactory.getLog(this.getClass()).debug((Object)("Using workflow verification root dir " + this.wfFileRootDir));
        this.wfsExpectedToFail = new LinkedList<File>(wfFilesExpectedToFail);
        for (File wfFile : this.wfFilesSubmitted) {
            this.wfsWithExecutionDurationSec.put(wfFile, new ArrayList());
        }
        this.wfsExpectedToFinishCount = this.wfFilesSubmitted.size() * parallelRuns * sequentialRuns;
    }

    public static HeadlessWorkflowExecutionVerificationRecorder createAndInitializeInstance(File wfFileRootDir, List<File> wfFilesExpectedToSucceed, List<File> wfFilesExpectedToFail, int parallelRuns, int sequentialRuns) throws IOException {
        HeadlessWorkflowExecutionVerification verification = new HeadlessWorkflowExecutionVerification(wfFileRootDir.getAbsolutePath(), wfFilesExpectedToSucceed, wfFilesExpectedToFail, parallelRuns, sequentialRuns);
        verification.initialize();
        return verification;
    }

    private void initialize() throws IOException {
        for (File wfFile : this.wfFilesSubmitted) {
            File wfProhibitedLogFile;
            String wfFileNameWithoutEnding = wfFile.getName().replace(".wf", "");
            File wfExpectedLogFile = new File(wfFile.getParentFile(), String.valueOf(wfFileNameWithoutEnding) + FILE_SUFFIX_EXPECTED_LOG);
            if (wfExpectedLogFile.exists()) {
                this.wfsWithExpectedLogMessages.put(wfFile, FileUtils.readLines((File)wfExpectedLogFile));
            }
            if (!(wfProhibitedLogFile = new File(wfFile.getParentFile(), String.valueOf(wfFileNameWithoutEnding) + FILE_SUFFIX_PROHIBITED_LOG)).exists()) continue;
            this.wfsWithProhibitedLogMessages.put(wfFile, FileUtils.readLines((File)wfProhibitedLogFile));
        }
        this.wfsExpectedToFailCount = this.wfsExpectedToFail.size() * this.parallelRuns * this.sequentialRuns;
        this.wfsExpectedToFinishCount -= this.wfsExpectedToFailCount;
    }

    @Override
    public synchronized void addWorkflowError(File wfFile, String errorMessage) {
        this.wfsWithError.put(wfFile, errorMessage);
        ++this.wfsWithErrorCount;
        ++this.resultCount;
        this.verifyOverall();
    }

    @Override
    public synchronized boolean addWorkflowExecutionResult(File wfFile, File[] wfLogFiles, FinalWorkflowState finalState, long executionDuration) throws IOException {
        if (!this.wfFilesSubmitted.contains(wfFile)) {
            throw new IllegalArgumentException("Given workflow file unknown: " + wfFile);
        }
        boolean behavedAsExpected = false;
        switch (finalState) {
            case FINISHED: {
                if (!this.wfsExpectedToFail.contains(wfFile)) {
                    ++this.wfsFinishedAsExpectedCount;
                    behavedAsExpected = this.verifyLog(wfFile, wfLogFiles, behavedAsExpected);
                    break;
                }
                this.wfsWithUnexpectedFinalState.put(wfFile, finalState);
                ++this.wfsWithUnexpectedFinalStateCount;
                break;
            }
            case FAILED: {
                if (this.wfsExpectedToFail.contains(wfFile)) {
                    ++this.wfsFailedAsExpectedCount;
                    behavedAsExpected = this.verifyLog(wfFile, wfLogFiles, behavedAsExpected);
                    break;
                }
                this.wfsWithUnexpectedFinalState.put(wfFile, finalState);
                ++this.wfsWithUnexpectedFinalStateCount;
                break;
            }
            case CANCELLED: {
                this.wfsCanceled.add(wfFile);
                ++this.wfsCanceledCount;
                break;
            }
            default: {
                throw new IllegalArgumentException("Given final workflow state unknown: " + (Object)((Object)finalState));
            }
        }
        ++this.resultCount;
        this.verifyOverall();
        this.wfsWithExecutionDurationSec.get(wfFile).add(executionDuration / 1000L);
        if (behavedAsExpected) {
            this.registerWorkflowRelatedFilesForDeletion(wfFile);
        }
        return behavedAsExpected;
    }

    private void registerWorkflowRelatedFilesForDeletion(File wfFile) {
        this.wfRelatedFilesToDelete.add(wfFile);
        File backupFile = new File(String.valueOf(wfFile.getAbsolutePath().replace(".wf", "")) + "_backup" + ".wf");
        if (backupFile.exists()) {
            this.wfRelatedFilesToDelete.add(backupFile);
        }
        if (this.wfsWithExpectedLogMessages.containsKey(wfFile)) {
            this.wfRelatedFilesToDelete.add(new File(wfFile.getParentFile(), String.valueOf(wfFile.getName().replace(".wf", "")) + FILE_SUFFIX_EXPECTED_LOG));
        }
        if (this.wfsWithProhibitedLogMessages.containsKey(wfFile)) {
            this.wfRelatedFilesToDelete.add(new File(wfFile.getParentFile(), String.valueOf(wfFile.getName().replace(".wf", "")) + FILE_SUFFIX_PROHIBITED_LOG));
        }
    }

    @Override
    public List<File> getWorkflowRelatedFilesToDelete() {
        return this.wfRelatedFilesToDelete;
    }

    private boolean verifyLog(File wfFile, File[] wfLogFiles, boolean behavedAsExpected) throws IOException {
        File[] fileArray = wfLogFiles;
        int n = wfLogFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File wfLogFile = fileArray[n2];
            behavedAsExpected = this.verifySingleLogFile(wfFile, wfLogFile);
            if (!behavedAsExpected) break;
            ++n2;
        }
        return behavedAsExpected;
    }

    private boolean verifySingleLogFile(File wfFile, File wfLogFile) throws IOException {
        boolean logVerified = true;
        String actualLogMessages = FileUtils.readFileToString((File)wfLogFile);
        if (this.wfsWithExpectedLogMessages.containsKey(wfFile)) {
            for (String expectedLogLine : this.wfsWithExpectedLogMessages.get(wfFile)) {
                boolean missed;
                boolean bl = missed = !actualLogMessages.contains(expectedLogLine);
                if (missed) {
                    this.wfsWithUnexpectedMissingLogMessage.put(wfFile, expectedLogLine);
                    ++this.wfsWithUnexpectedMissingLogMessageCount;
                }
                logVerified &= !missed;
            }
        }
        if (this.wfsWithProhibitedLogMessages.containsKey(wfFile)) {
            for (String prohibitedLogLine : this.wfsWithProhibitedLogMessages.get(wfFile)) {
                boolean contained = actualLogMessages.contains(prohibitedLogLine);
                if (contained) {
                    this.wfsWithUnexpectedProhibitedLogMessage.put(wfFile, prohibitedLogLine);
                    ++this.wfsWithUnexpectedProhibitedLogMessageCount;
                }
                logVerified &= !contained;
            }
        }
        this.verified &= logVerified;
        return logVerified;
    }

    private boolean verifyOverall() {
        if (this.verified) {
            this.verified &= this.wfsWithError.isEmpty() && this.wfsCanceled.isEmpty() && this.wfsWithUnexpectedFinalState.isEmpty() && this.wfsWithUnexpectedMissingLogMessage.isEmpty() && this.wfsWithUnexpectedProhibitedLogMessage.isEmpty();
        }
        return this.isVerified();
    }

    @Override
    public synchronized boolean isVerified() {
        return this.verified && this.wfsExpectedToFinishCount + this.wfsExpectedToFailCount == this.resultCount;
    }

    @Override
    public synchronized String getVerificationReport() {
        StringBuilder builder = new StringBuilder();
        builder.append("Workflow Statistics\n");
        builder.append(StringUtils.format((String)"- Finished (as expected): %d/%d, Failed (as expected): %d/%d, Canceled: %d/0, Error: %d/0, Unexpected final state: %d/0 [Total: %d/%d]\n", (Object[])new Object[]{this.wfsFinishedAsExpectedCount, this.wfsExpectedToFinishCount, this.wfsFailedAsExpectedCount, this.wfsExpectedToFailCount, this.wfsCanceledCount, this.wfsWithErrorCount, this.wfsWithUnexpectedFinalStateCount, this.resultCount, this.wfsExpectedToFinishCount + this.wfsExpectedToFailCount}));
        builder.append(StringUtils.format((String)"- Canceled (%d): %s\n- With error (%d): %s\n- With unexpected final state (%d): %s\n- With missing log message (%d): %s\n- With prohibited log message (%d): %s\n", (Object[])new Object[]{this.wfsCanceledCount, this.convertFileListToString(this.wfsCanceled), this.wfsWithErrorCount, this.convertFileMapToString(this.wfsWithError), this.wfsWithUnexpectedFinalStateCount, this.convertFileMapToString(this.wfsWithUnexpectedFinalState), this.wfsWithUnexpectedMissingLogMessageCount, this.convertFileMapToString(this.wfsWithUnexpectedMissingLogMessage), this.wfsWithUnexpectedProhibitedLogMessageCount, this.convertFileMapToString(this.wfsWithUnexpectedProhibitedLogMessage)}));
        builder.append("Durations per workflow [sec]\n");
        int sec = 0;
        for (Map.Entry<String, Object> durationEntry : this.reduceFilePathToFileName(this.wfsWithExecutionDurationSec).entrySet()) {
            int newValue;
            String duration = this.convertListToString((List)durationEntry.getValue());
            builder.append(StringUtils.format((String)"- %s: %s\n", (Object[])new Object[]{durationEntry.getKey(), duration}));
            try {
                newValue = Integer.parseInt(duration);
            }
            catch (NumberFormatException numberFormatException) {
                newValue = 0;
            }
            sec += newValue;
        }
        builder.append(StringUtils.format((String)"Durations (overall)\n", (Object[])new Object[0]));
        builder.append(StringUtils.format((String)"- Start time: %s \n", (Object[])new Object[]{new SimpleDateFormat(DATE_FORMAT).format(this.startTime)}));
        builder.append(StringUtils.format((String)"- End time: %s \n", (Object[])new Object[]{new SimpleDateFormat(DATE_FORMAT).format(this.endTime)}));
        builder.append(StringUtils.format((String)"- Aggregated: %s sec\n", (Object[])new Object[]{sec}));
        int totaltime = (int)((this.endTime.getTime() - this.startTime.getTime()) / 1000L);
        builder.append(StringUtils.format((String)"- Total: %s sec\n", (Object[])new Object[]{totaltime}));
        String result = this.isVerified() ? "SUCCEEDED" : "FAILED";
        builder.append("Summary Result\n");
        builder.append(StringUtils.format((String)"- Verification %s [%d workflow files, parallel: %d, sequential: %d]\n", (Object[])new Object[]{result, this.wfFilesSubmitted.size(), this.parallelRuns, this.sequentialRuns}));
        return builder.toString();
    }

    private SortedMap<String, Object> reduceFilePathToFileName(Map<File, ? extends Object> fileMap) {
        TreeMap<String, Object> fileNameMap = new TreeMap<String, Object>();
        for (File file : fileMap.keySet()) {
            fileNameMap.put(file.getName(), fileMap.get(file));
        }
        return fileNameMap;
    }

    private String convertFileMapToString(Map<File, ? extends Object> fileMap) {
        if (fileMap.isEmpty()) {
            return EMPTY_COLLECTION_STRING;
        }
        return this.reduceFilePathToFileName(fileMap).toString().replaceAll("\\{", "").replaceAll("\\}", "").trim();
    }

    private SortedSet<String> reduceFilePathToFileName(List<File> fileList) {
        TreeSet<String> fileNameSet = new TreeSet<String>();
        for (File file : fileList) {
            fileNameSet.add(file.getName());
        }
        return fileNameSet;
    }

    private String convertFileListToString(List<File> fileList) {
        return this.convertSetToString(this.reduceFilePathToFileName(fileList));
    }

    private String convertListToString(List<? extends Object> list) {
        if (list.isEmpty()) {
            return EMPTY_COLLECTION_STRING;
        }
        return list.toString().replaceAll("\\[", "").replaceAll("\\]", "").trim();
    }

    private String convertSetToString(Set<? extends Object> set) {
        if (set.isEmpty()) {
            return EMPTY_COLLECTION_STRING;
        }
        return set.toString().replaceAll("\\[", "").replaceAll("\\]", "").trim();
    }

    @Override
    public void setStartAndEndTime(Date start, Date end) {
        this.startTime = start;
        this.endTime = end;
    }
}

