/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractInteractableComponent;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextArea
extends AbstractInteractableComponent {
    private final List<String> lines;
    private final TerminalSize preferredSize;
    private TerminalSize lastSize;
    private TerminalSize maximumSize;
    private TerminalSize minimumSize;
    private int longestLine;
    private int scrollTopIndex;
    private int scrollLeftIndex;

    public TextArea() {
        this("");
    }

    public TextArea(String text) {
        this(new TerminalSize(0, 0), text);
    }

    public TextArea(TerminalSize preferredSize, String text) {
        if (text == null) {
            text = "";
        }
        this.lines = new ArrayList<String>();
        this.preferredSize = preferredSize;
        this.scrollTopIndex = 0;
        this.scrollLeftIndex = 0;
        this.maximumSize = null;
        this.minimumSize = new TerminalSize(10, 3);
        this.lastSize = null;
        this.lines.addAll(Arrays.asList(text.split("\n")));
        this.scanForLongestLine();
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        int height;
        int width = this.preferredSize.getColumns() > 0 ? this.preferredSize.getColumns() : this.longestLine + 1;
        int n = height = this.preferredSize.getRows() > 0 ? this.preferredSize.getRows() : this.lines.size() + 1;
        if (this.maximumSize != null) {
            if (width > this.maximumSize.getColumns()) {
                width = this.maximumSize.getColumns();
            }
            if (height > this.maximumSize.getRows()) {
                height = this.maximumSize.getRows();
            }
        }
        if (this.minimumSize != null) {
            if (width < this.minimumSize.getColumns()) {
                width = this.minimumSize.getColumns();
            }
            if (height < this.minimumSize.getRows()) {
                height = this.minimumSize.getRows();
            }
        }
        return new TerminalSize(width, height);
    }

    @Override
    public void repaint(TextGraphics graphics) {
        int tickPosition;
        double position;
        int scrollableSize;
        int i;
        this.lastSize = new TerminalSize(graphics.getWidth(), graphics.getHeight());
        if (this.lines.size() > graphics.getHeight() && this.lines.size() - this.scrollTopIndex < graphics.getHeight()) {
            this.scrollTopIndex = this.lines.size() - graphics.getHeight();
        }
        if (this.longestLine > graphics.getWidth() && this.longestLine - this.scrollLeftIndex < graphics.getWidth()) {
            this.scrollLeftIndex = this.longestLine - graphics.getWidth();
        }
        if (this.hasFocus()) {
            graphics.applyTheme(Theme.Category.TEXTBOX_FOCUSED);
        } else {
            graphics.applyTheme(Theme.Category.TEXTBOX);
        }
        graphics.fillArea(' ');
        for (int i2 = this.scrollTopIndex; i2 < this.lines.size() && i2 - this.scrollTopIndex < graphics.getHeight(); ++i2) {
            this.printItem(graphics, 0, 0 + i2 - this.scrollTopIndex, this.lines.get(i2));
        }
        boolean hasSetHotSpot = false;
        if (this.lines.size() > graphics.getHeight()) {
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            graphics.drawString(graphics.getWidth() - 1, 0, "\u2191", new ScreenCharacterStyle[0]);
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            for (i = 1; i < graphics.getHeight() - 1; ++i) {
                graphics.drawString(graphics.getWidth() - 1, i, "\u2592", new ScreenCharacterStyle[0]);
            }
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            graphics.drawString(graphics.getWidth() - 1, graphics.getHeight() - 1, "\u2193", new ScreenCharacterStyle[0]);
            scrollableSize = this.lines.size() - graphics.getHeight();
            position = (double)this.scrollTopIndex / (double)scrollableSize;
            tickPosition = (int)(((double)graphics.getHeight() - 3.0) * position);
            graphics.applyTheme(Theme.Category.SHADOW);
            graphics.drawString(graphics.getWidth() - 1, 1 + tickPosition, " ", new ScreenCharacterStyle[0]);
            if (this.hasFocus()) {
                this.setHotspot(graphics.translateToGlobalCoordinates(new TerminalPosition(graphics.getWidth() - 1, 1 + tickPosition)));
                hasSetHotSpot = true;
            }
        }
        if (this.longestLine > graphics.getWidth()) {
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            graphics.drawString(0, graphics.getHeight() - 1, "\u2190", new ScreenCharacterStyle[0]);
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            for (i = 1; i < graphics.getWidth() - 2; ++i) {
                graphics.drawString(i, graphics.getHeight() - 1, "\u2592", new ScreenCharacterStyle[0]);
            }
            graphics.applyTheme(Theme.Category.DIALOG_AREA);
            graphics.drawString(graphics.getWidth() - 2, graphics.getHeight() - 1, "\u2192", new ScreenCharacterStyle[0]);
            scrollableSize = this.longestLine - graphics.getWidth();
            position = (double)this.scrollLeftIndex / (double)scrollableSize;
            tickPosition = (int)(((double)graphics.getWidth() - 4.0) * position);
            graphics.applyTheme(Theme.Category.SHADOW);
            graphics.drawString(1 + tickPosition, graphics.getHeight() - 1, " ", new ScreenCharacterStyle[0]);
        }
        if (!hasSetHotSpot) {
            this.setHotspot(graphics.translateToGlobalCoordinates(new TerminalPosition(0, 0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable.Result keyboardInteraction(Key key) {
        try {
            switch (key.getKind()) {
                case Tab: 
                case Enter: {
                    Interactable.Result result = Interactable.Result.NEXT_INTERACTABLE_RIGHT;
                    return result;
                }
                case ReverseTab: {
                    Interactable.Result result = Interactable.Result.PREVIOUS_INTERACTABLE_LEFT;
                    return result;
                }
                case ArrowRight: {
                    if (this.lastSize == null || this.scrollLeftIndex >= this.longestLine - this.lastSize.getColumns()) break;
                    ++this.scrollLeftIndex;
                    break;
                }
                case ArrowLeft: {
                    if (this.scrollLeftIndex <= 0) break;
                    --this.scrollLeftIndex;
                    break;
                }
                case ArrowDown: {
                    if (this.lastSize == null || this.scrollTopIndex >= this.lines.size() - this.lastSize.getRows()) break;
                    ++this.scrollTopIndex;
                    break;
                }
                case ArrowUp: {
                    if (this.scrollTopIndex <= 0) break;
                    --this.scrollTopIndex;
                    break;
                }
                case PageUp: {
                    this.scrollTopIndex -= this.lastSize.getRows();
                    if (this.scrollTopIndex >= 0) break;
                    this.scrollTopIndex = 0;
                    break;
                }
                case PageDown: {
                    this.scrollTopIndex += this.lastSize.getRows();
                    if (this.scrollTopIndex < this.lines.size() - this.lastSize.getRows()) break;
                    this.scrollTopIndex = this.lines.size() - this.lastSize.getRows();
                    break;
                }
                case Home: {
                    this.scrollTopIndex = 0;
                    break;
                }
                case End: {
                    this.scrollTopIndex = Math.max(0, this.lines.size() - this.lastSize.getRows());
                    break;
                }
                default: {
                    Interactable.Result result = Interactable.Result.EVENT_NOT_HANDLED;
                    return result;
                }
            }
            Interactable.Result result = Interactable.Result.EVENT_HANDLED;
            return result;
        }
        finally {
            this.invalidate();
        }
    }

    @Override
    public boolean isScrollable() {
        return true;
    }

    public void setMaximumSize(TerminalSize maximumSize) {
        this.maximumSize = maximumSize;
    }

    public TerminalSize getMaximumSize() {
        return this.maximumSize;
    }

    public void setMinimumSize(TerminalSize minimumSize) {
        this.minimumSize = minimumSize;
    }

    @Override
    public TerminalSize getMinimumSize() {
        return this.minimumSize;
    }

    public void clear() {
        this.lines.clear();
        this.lines.add("");
        this.invalidate();
    }

    public String getLine(int index) {
        return this.lines.get(index);
    }

    public void appendLine(String line) {
        this.lines.add(line);
        if (line.length() > this.longestLine) {
            this.longestLine = line.length();
        }
        this.invalidate();
    }

    public void insertLine(int index, String line) {
        this.lines.add(index, line);
        if (line.length() > this.longestLine) {
            this.longestLine = line.length();
        }
        this.invalidate();
    }

    public void setLine(int index, String line) {
        String oldLine = this.lines.set(index, line);
        if (oldLine.length() == this.longestLine) {
            this.scanForLongestLine();
        } else if (line.length() > this.longestLine) {
            this.longestLine = line.length();
        }
        this.invalidate();
    }

    public void removeLine(int lineNumber) {
        String line = this.lines.get(lineNumber);
        this.lines.remove(lineNumber);
        if (line.length() >= this.longestLine) {
            this.scanForLongestLine();
        }
        this.invalidate();
    }

    protected void printItem(TextGraphics graphics, int x, int y, String text) {
        if ((text = this.scrollLeftIndex >= (text = text.replace("\t", "    ")).length() ? "" : text.substring(this.scrollLeftIndex)).length() > graphics.getWidth()) {
            text = text.substring(0, graphics.getWidth());
        }
        graphics.drawString(x, y, text, new ScreenCharacterStyle[0]);
    }

    private void scanForLongestLine() {
        this.longestLine = 0;
        for (String line : this.lines) {
            if (line.replace("\t", "    ").length() <= this.longestLine) continue;
            this.longestLine = line.replace("\t", "    ").length();
        }
    }
}

