/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstanceStateStepDefinitions
extends InstanceManagementStepDefinitionBase {
    public InstanceStateStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @When(value="^starting( all)? instance[s]?(?: \"([^\"]*)\")?(?: (in the given order|concurrently|in a random order))?( in GUI mode)?(?: with console command[s]? (-{1,2}.+))?$")
    public void whenStartingInstances(String allFlag, String instanceIds, String executionDesc, String startWithGuiFlag, String commandArguments) throws OperationFailureException {
        StartInstanceAction startInstanceAction;
        if (startWithGuiFlag == null) {
            startInstanceAction = new StartInstanceAction(startWithGuiFlag != null);
        } else {
            startInstanceAction = new StartInstanceAction(startWithGuiFlag != null, commandArguments);
            this.log.debug((Object)commandArguments);
        }
        this.performActionOnInstances(startInstanceAction, this.resolveInstanceList(allFlag != null, instanceIds), this.resolveExecutionMode(executionDesc, InstanceManagementStepDefinitionBase.InstanceActionExecutionType.RANDOM));
    }

    @When(value="^stopping( all)? instance[s]?(?: \"([^\"]*)\")?(?: (in the given order|concurrently|in a random order))?$")
    public void whenStoppingInstances(String allFlag, String instanceIds, String executionDesc) throws OperationFailureException {
        this.performActionOnInstances(new StopInstanceAction(), this.resolveInstanceList(allFlag != null, instanceIds), this.resolveExecutionMode(executionDesc, InstanceManagementStepDefinitionBase.InstanceActionExecutionType.RANDOM));
    }

    @When(value="^scheduling (?:a|an instance) (shutdown|restart|reconnect) of \"([^\"]+)\" after (\\d+) second[s]?$")
    public void whenSchedulingNodeActionsAfterDelay(final String action, final String instanceId, int delaySeconds) throws OperationFailureException {
        final ManagedInstance instance = this.resolveInstance(instanceId);
        String taskDesc = StringUtils.format((String)"delayed %s of instance %s", (Object[])new Object[]{action, instanceId});
        ConcurrencyUtils.getAsyncTaskService().scheduleAfterDelay(taskDesc, new Runnable(){

            @Override
            public void run() {
                try {
                    switch (action) {
                        case "shutdown": {
                            InstanceStateStepDefinitions.this.stopSingleInstance(instance);
                            break;
                        }
                        case "restart": {
                            InstanceStateStepDefinitions.this.stopSingleInstance(instance);
                            InstanceStateStepDefinitions.this.startSingleInstance(instance, false, "", 60L);
                            break;
                        }
                        case "reconnect": {
                            InstanceStateStepDefinitions.this.cycleAllOutgoingConnectionsOf(instance);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(action);
                        }
                    }
                }
                catch (OperationFailureException e) {
                    InstanceStateStepDefinitions.this.log.error((Object)("Error while executing aynchonous action '" + action + "' on instance '" + instanceId + "'"), (Throwable)e);
                }
            }
        }, TimeUnit.SECONDS.toMillis(delaySeconds));
        this.printToCommandConsole(StringUtils.format((String)"Scheduling a '%s' action for instance '%s' after %d second(s)", (Object[])new Object[]{action, instanceId, delaySeconds}));
    }

    @Then(value="^(all )?(?:instance[s]? )?(?:\"([^\"]*)\" )?should be (stopped|running)$")
    public void thenInstancesShouldBeInState(String allFlag, String instanceIds, String state) throws AssertionError, OperationFailureException {
        int tmax = 15;
        String operationTitle = StringUtils.format((String)"Expect instances \"%s\" to be in state \"%s\"", (Object[])new Object[]{this.resolveInstanceList(allFlag != null, instanceIds).toString(), state});
        this.executeWithRetry((attemptCount, isLastAttempt) -> {
            try {
                AssertStateIterator assertStateIterator = new AssertStateIterator("running".equals(state));
                this.iterateInstances(assertStateIterator, allFlag, instanceIds);
                return true;
            }
            catch (AssertionError ae) {
                if (isLastAttempt) {
                    throw ae;
                }
                return false;
            }
        }, operationTitle, tmax);
    }

    private void cycleAllOutgoingConnectionsOf(ManagedInstance instance) throws OperationFailureException {
        String cnListOutput = this.executeCommandOnInstance(instance, "cn list", false);
        Pattern connectionIdPattern = Pattern.compile("^\\s*\\((\\d+)\\) ");
        Matcher matcher = connectionIdPattern.matcher(cnListOutput);
        int count = 0;
        while (matcher.find()) {
            ++count;
            String connectionIndex = matcher.group(1);
            this.executeCommandOnInstance(instance, "cn stop " + connectionIndex, false);
            this.executeCommandOnInstance(instance, "cn start " + connectionIndex, false);
        }
        if (count == 0) {
            this.printToCommandConsole("  WARNING: Attempted to stop and restart all outgoing connections of " + instance.getId() + ", but no connections were found");
        } else {
            this.printToCommandConsole("  Stopped and restarted " + count + " outgoing connection(s) of " + instance.getId());
        }
    }

    private void startSingleInstance(ManagedInstance instance, boolean withGUI, String commandArguments, long timeout) throws OperationFailureException {
        instance.onStarting();
        String installationId = instance.getInstallationId();
        this.printToCommandConsole(StringUtils.format((String)"Launching instance \"%s\" using installation \"%s\"", (Object[])new Object[]{instance, installationId}));
        try {
            INSTANCE_MANAGEMENT_SERVICE.startInstance(installationId, this.listOfSingleStringElement(instance.getId()), this.getTextoutReceiverForIMOperations(), timeout, withGUI, commandArguments);
        }
        catch (IOException e) {
            throw this.testExecutionError("Failed to start instance " + instance.getId(), e);
        }
    }

    private void stopSingleInstance(ManagedInstance instance) throws OperationFailureException {
        this.printToCommandConsole(StringUtils.format((String)"Stopping instance \"%s\"", (Object[])new Object[]{instance}));
        try {
            INSTANCE_MANAGEMENT_SERVICE.stopInstance(this.listOfSingleStringElement(instance.getId()), this.getTextoutReceiverForIMOperations(), TimeUnit.SECONDS.toMillis(60L));
        }
        catch (IOException e) {
            throw this.testExecutionError("Failed to start instance " + instance.getId(), e);
        }
        instance.onStopped();
    }

    private class AssertStateIterator
    implements InstanceManagementStepDefinitionBase.InstanceIterator {
        private boolean shouldBeRunning;

        AssertStateIterator(boolean shouldBeRunning) {
            this.shouldBeRunning = shouldBeRunning;
        }

        @Override
        public void iterateActionOverInstance(ManagedInstance instance) throws IOException {
            boolean isRunning = INSTANCE_MANAGEMENT_SERVICE.isInstanceRunning(instance.getId());
            if (isRunning != this.shouldBeRunning) {
                throw new AssertionError((Object)StringUtils.format((String)"Instance state did not match expectation: Instance \"%s\" was in running state [%s] when it should have been [%s]", (Object[])new Object[]{instance, isRunning, this.shouldBeRunning}));
            }
        }
    }

    private class StartInstanceAction
    implements InstanceManagementStepDefinitionBase.InstanceAction {
        private boolean startWithGUI;
        private String startWithCommands;

        StartInstanceAction(boolean startWithGUI) {
            this.startWithGUI = startWithGUI;
            this.startWithCommands = "";
        }

        StartInstanceAction(boolean startWithGUI, String startWithCommands) {
            this.startWithGUI = startWithGUI;
            this.startWithCommands = startWithCommands;
        }

        @Override
        public void performActionOnInstance(ManagedInstance instance, long timeout) throws OperationFailureException {
            InstanceStateStepDefinitions.this.startSingleInstance(instance, this.startWithGUI, this.startWithCommands, timeout);
        }
    }

    private class StopInstanceAction
    implements InstanceManagementStepDefinitionBase.InstanceAction {
        private StopInstanceAction() {
        }

        @Override
        public void performActionOnInstance(ManagedInstance instance, long timeout) throws OperationFailureException {
            InstanceStateStepDefinitions.this.stopSingleInstance(instance);
        }
    }
}

