/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.management.WorkflowHostService;
import de.rcenvironment.core.datamanagement.DataReferenceService;
import de.rcenvironment.core.datamanagement.RemotableMetaDataService;
import de.rcenvironment.core.datamanagement.commons.DataReference;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.util.Collection;
import org.osgi.framework.BundleContext;

public class DataReferenceServiceImpl
implements DataReferenceService {
    private WorkflowHostService workflowHostService;
    private CommunicationService communicationService;
    private PlatformService platformService;

    protected void activate(BundleContext bundleContext) {
    }

    protected void bindWorkflowHostService(WorkflowHostService newWorkflowHostService) {
        this.workflowHostService = newWorkflowHostService;
    }

    protected void bindCommunicationService(CommunicationService newCommunicationService) {
        this.communicationService = newCommunicationService;
    }

    protected void bindPlatformService(PlatformService newPlatformService) {
        this.platformService = newPlatformService;
    }

    @Override
    public DataReference getReference(String dataReferenceKey, NetworkDestination platform) throws CommunicationException {
        if (platform == null) {
            platform = this.platformService.getLocalInstanceNodeSessionId();
        }
        try {
            return this.getRemoteMetaDataBackendService(platform).getDataReference(dataReferenceKey);
        }
        catch (RemoteOperationException e) {
            throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to get data reference from remote node @%s: ", (Object[])new Object[]{platform})) + e.getMessage());
        }
    }

    @Override
    public DataReference getReference(String dataReferenceKey) throws CommunicationException {
        return this.getReference(dataReferenceKey, this.workflowHostService.getWorkflowHostNodesAndSelf());
    }

    @Override
    public DataReference getReference(String dataReferenceKey, Collection<? extends NetworkDestination> platforms) throws CommunicationException {
        DataReference reference = null;
        for (InstanceNodeSessionId pi : this.workflowHostService.getWorkflowHostNodesAndSelf()) {
            try {
                reference = this.getRemoteMetaDataBackendService((NetworkDestination)pi).getDataReference(dataReferenceKey);
                if (reference == null) continue;
                break;
            }
            catch (RemoteOperationException e) {
                throw new CommunicationException(String.valueOf(StringUtils.format((String)"Failed to get data reference from remote node @%s: ", (Object[])new Object[]{pi})) + e.getMessage());
            }
        }
        return reference;
    }

    private RemotableMetaDataService getRemoteMetaDataBackendService(NetworkDestination nodeId) throws RemoteOperationException {
        return (RemotableMetaDataService)this.communicationService.getRemotableService(RemotableMetaDataService.class, nodeId);
    }
}

