/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.execution;

import de.rcenvironment.components.parametricstudy.common.Dimension;
import de.rcenvironment.components.parametricstudy.common.Measure;
import de.rcenvironment.components.parametricstudy.common.ParametricStudyService;
import de.rcenvironment.components.parametricstudy.common.StudyDataset;
import de.rcenvironment.components.parametricstudy.common.StudyPublisher;
import de.rcenvironment.components.parametricstudy.common.StudyStructure;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.model.api.LazyDisposal;
import de.rcenvironment.core.component.model.spi.AbstractNestedLoopComponent;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.NoSuchElementException;

@LazyDisposal
public class ParametricStudyComponent
extends AbstractNestedLoopComponent {
    private static final String TRUE = "true";
    private static final String GET_STUDYPARAMETERS_STRING = "Not-a-value at '%s' Input.";
    private static final int MINUS_ONE = -1;
    private static ParametricStudyService parametricStudyService;
    private StudyPublisher study;
    private double from;
    private double to;
    private double stepSize;
    private double designVariable;
    private long steps;
    private boolean fitStepSizeToBounds = true;
    private int stepCount = 1;
    private boolean isDone;
    private volatile boolean canceled = false;

    private static StudyStructure createStructure(ComponentContext compExeCtx) {
        StudyStructure structure = new StudyStructure();
        for (String outputName : compExeCtx.getOutputs()) {
            if (!outputName.equals("Design variable")) continue;
            Dimension dimension = new Dimension(outputName, Boolean.valueOf(true));
            structure.addDimension(dimension);
        }
        for (String inputName : compExeCtx.getInputs()) {
            Measure measure = new Measure(inputName);
            structure.addMeasure(measure);
        }
        return structure;
    }

    public boolean treatStartAsComponentRun() {
        return !this.hasForwardingStartInputs() && !this.hasStudyParameterInputs();
    }

    public void startNestedComponentSpecific() throws ComponentException {
        parametricStudyService = (ParametricStudyService)this.componentContext.getService(ParametricStudyService.class);
        if (this.treatStartAsComponentRun()) {
            this.setStudyParameters();
            this.checkStepSize();
            this.initilizeStudy();
            this.sendDesignVariableToOutput(this.calculateInitialDesignVariable());
            if (!this.hasEvaluationResultFromLoopInput()) {
                this.runFullStudyAtOnce();
            }
        } else {
            if (this.isNestedLoop() && !this.hasEvaluationResultFromLoopInput() && !this.hasForwardingStartInputs()) {
                throw new ComponentException("Component is in a nested loop and thus needs at least one 'foward' or 'evaluation result' input to control the flow of the inner loop.");
            }
            this.setComponentDone(false);
        }
    }

    public void processInputsNestedComponentSpecific() throws ComponentException {
        if (this.stepCount == 1) {
            this.setStudyParameters();
            this.checkStepSize();
            this.initilizeStudy();
            if (!this.hasEvaluationResultFromLoopInput() && !this.hasForwardingStartInputs()) {
                this.runFullStudyAtOnce();
            }
        }
        if (this.componentContext.isOutputClosed("Design variable")) {
            throw new ComponentException(StringUtils.format((String)"Too many values received. Expect exactly one value per input per design variable sent. %s design variables(s) sent and %s value(s) received", (Object[])new Object[]{this.steps, this.steps + 1L}));
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.fitStepSizeToBounds) {
            values.put("Design variable", this.getLastDesignVariableFittingStepSizeToBounds());
        } else {
            values.put("Design variable", this.getLastDesignVariableNotFittingStepSizeToBounds());
        }
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.componentContext.isDynamicInput(inputName)) continue;
            TypedDatum input = this.componentContext.readInput(inputName);
            switch (input.getDataType()) {
                case NotAValue: {
                    values.put(inputName, Double.NaN);
                    break;
                }
                case Integer: {
                    values.put(inputName, ((IntegerTD)input).getIntValue());
                    break;
                }
                case Float: {
                    values.put(inputName, ((FloatTD)input).getFloatValue());
                    break;
                }
                default: {
                    values.put(inputName, "Not applicable");
                }
            }
        }
        this.study.add(new StudyDataset(values));
        this.setComponentDone(this.allDesignVariablesSent());
    }

    protected void sendValuesNestedComponentSpecific() {
        if (this.fitStepSizeToBounds) {
            this.sendDesignVariableToOutput(this.calculateDesignVariableFittingStepSizeToBounds(this.stepCount));
        } else {
            this.sendDesignVariableToOutput(this.calculateDesignVariableNotFittingStepSizeToBounds());
        }
    }

    public void onStartInterrupted(ThreadHandler executingThreadHandler) {
        this.canceled = true;
    }

    private void runFullStudyAtOnce() throws ComponentException {
        if (this.fitStepSizeToBounds) {
            int step = this.stepCount;
            while ((long)step <= this.steps) {
                this.sendDesignVariableToOutput(this.calculateDesignVariableFittingStepSizeToBounds(step));
                if (!this.canceled) {
                    ++step;
                    continue;
                }
                break;
            }
        } else {
            double nextDesignVariable = this.calculateDesignVariableNotFittingStepSizeToBounds();
            while (this.designVariableIsInBounds(nextDesignVariable)) {
                this.sendDesignVariableToOutput(this.calculateDesignVariableNotFittingStepSizeToBounds());
                nextDesignVariable = this.calculateDesignVariableNotFittingStepSizeToBounds();
                if (!this.canceled) {
                    continue;
                }
                break;
            }
        }
        this.setComponentDone(true);
    }

    public void dispose() {
        if (this.study != null) {
            this.study.clearStudy();
        }
    }

    protected boolean isDoneNestedComponentSpecific() {
        return this.isDone;
    }

    protected void resetNestedComponentSpecific() {
        this.stepCount = 1;
        this.setComponentDone(false);
    }

    protected void finishLoopNestedComponentSpecific() {
    }

    protected void sendFinalValues() throws ComponentException {
    }

    private void sendDesignVariableToOutput(double value) {
        this.writeOutput("Design variable", (TypedDatum)this.typedDatumFactory.createFloat(value));
        this.componentLog.componentInfo(StringUtils.format((String)"Wrote to output '%s': %s", (Object[])new Object[]{"Design variable", value}));
        ++this.stepCount;
    }

    private double calculateInitialDesignVariable() {
        if (this.fitStepSizeToBounds) {
            return this.calculateInitialDesignVariableFittingStepSizeToBounds();
        }
        return this.calculateInitialDesignVariableNotFittingStepSizeToBounds();
    }

    private double calculateInitialDesignVariableFittingStepSizeToBounds() {
        this.designVariable = this.from;
        return this.designVariable;
    }

    private double calculateDesignVariableFittingStepSizeToBounds(int step) {
        if (step == 1) {
            return this.from;
        }
        this.designVariable = BigDecimal.valueOf(this.to).subtract(BigDecimal.valueOf(this.from)).multiply(BigDecimal.valueOf((long)step - 1L)).divide(BigDecimal.valueOf(this.steps - 1L), 64, RoundingMode.HALF_UP).add(BigDecimal.valueOf(this.from)).doubleValue();
        return this.designVariable;
    }

    private double getLastDesignVariableFittingStepSizeToBounds() {
        return this.designVariable;
    }

    private double calculateInitialDesignVariableNotFittingStepSizeToBounds() {
        return this.from;
    }

    private double calculateDesignVariableNotFittingStepSizeToBounds() {
        return BigDecimal.valueOf(this.from).add(BigDecimal.valueOf(this.stepSize).multiply(BigDecimal.valueOf(this.stepCount))).subtract(BigDecimal.valueOf(this.stepSize)).doubleValue();
    }

    private double getLastDesignVariableNotFittingStepSizeToBounds() {
        return BigDecimal.valueOf(this.from).add(BigDecimal.valueOf(this.stepSize).multiply(BigDecimal.valueOf((double)this.stepCount - 1.0))).subtract(BigDecimal.valueOf(this.stepSize)).doubleValue();
    }

    private boolean allDesignVariablesSent() {
        return !(this.fitStepSizeToBounds ? (long)this.stepCount <= this.steps : this.designVariableIsInBounds(this.calculateDesignVariableNotFittingStepSizeToBounds()));
    }

    private void setComponentDone(boolean done) {
        this.isDone = done;
    }

    private boolean hasStudyParameterInputs() {
        for (String inputName : this.componentContext.getInputs()) {
            if (!this.componentContext.getDynamicInputIdentifier(inputName).equals("paramericStudyParameters")) continue;
            return true;
        }
        return false;
    }

    private boolean hasEvaluationResultFromLoopInput() {
        for (String inputName : this.componentContext.getInputs()) {
            if (!this.componentContext.getDynamicInputIdentifier(inputName).equals("parameters")) continue;
            return true;
        }
        return false;
    }

    private void setStudyParameters() throws ComponentException {
        try {
            double value;
            TypedDatum input;
            if (this.componentContext.getOutputMetaDataValue("Design variable", "UseInputAsFromValue").equals(TRUE)) {
                input = this.componentContext.readInput("From Value");
                switch (input.getDataType()) {
                    case NotAValue: {
                        throw new ComponentException(StringUtils.format((String)GET_STUDYPARAMETERS_STRING, (Object[])new Object[]{"From Value"}));
                    }
                    case Integer: {
                        value = ((IntegerTD)input).getIntValue();
                        break;
                    }
                    case Float: {
                        value = ((FloatTD)input).getFloatValue();
                        break;
                    }
                    default: {
                        value = 0.0;
                    }
                }
                this.from = value;
            } else {
                this.from = Double.valueOf(this.componentContext.getOutputMetaDataValue("Design variable", "FromValue"));
            }
            if (this.componentContext.getOutputMetaDataValue("Design variable", "UseInputAsToValue").equals(TRUE)) {
                input = this.componentContext.readInput("To Value");
                switch (input.getDataType()) {
                    case NotAValue: {
                        throw new ComponentException(StringUtils.format((String)GET_STUDYPARAMETERS_STRING, (Object[])new Object[]{"To Value"}));
                    }
                    case Integer: {
                        value = ((IntegerTD)input).getIntValue();
                        break;
                    }
                    case Float: {
                        value = ((FloatTD)input).getFloatValue();
                        break;
                    }
                    default: {
                        value = 0.0;
                    }
                }
                this.to = value;
            } else {
                this.to = Double.valueOf(this.componentContext.getOutputMetaDataValue("Design variable", "ToValue"));
            }
            if (this.componentContext.getOutputMetaDataValue("Design variable", "UseInputAsStepSizeValue").equals(TRUE)) {
                input = this.componentContext.readInput("StepSize Value");
                switch (input.getDataType()) {
                    case NotAValue: {
                        throw new ComponentException(StringUtils.format((String)GET_STUDYPARAMETERS_STRING, (Object[])new Object[]{"StepSize Value"}));
                    }
                    case Integer: {
                        value = ((IntegerTD)input).getIntValue();
                        break;
                    }
                    case Float: {
                        value = ((FloatTD)input).getFloatValue();
                        break;
                    }
                    default: {
                        value = 0.0;
                    }
                }
                this.stepSize = value;
            } else {
                this.stepSize = Double.valueOf(this.componentContext.getOutputMetaDataValue("Design variable", "StepSize"));
            }
        }
        catch (NoSuchElementException e) {
            throw new ComponentException("Expected Input not connected: " + e.getMessage(), e.getCause());
        }
    }

    private void checkStepSize() throws ComponentException {
        if (this.stepSize <= 0.0) {
            throw new ComponentException(StringUtils.format((String)"Invalid step size: %f , must be > 0", (Object[])new Object[]{this.stepSize}));
        }
        if (this.from > this.to) {
            this.stepSize *= -1.0;
        }
    }

    private void initilizeStudy() throws ComponentException {
        this.study = parametricStudyService.createPublisher(this.componentContext.getExecutionIdentifier(), this.componentContext.getInstanceName(), ParametricStudyComponent.createStructure(this.componentContext));
        double stepsDouble = Math.round((this.to - this.from) / this.stepSize) + 1L;
        if (stepsDouble >= 9.223372036854776E18) {
            throw new ComponentException("The number of values produced by the Component exceeds the numerical limits.");
        }
        this.steps = (long)stepsDouble;
        this.componentLog.componentInfo(StringUtils.format((String)"Sampling from %s to %s with step size %s -> %d value(s)", (Object[])new Object[]{this.from, this.to, this.stepSize, this.steps}));
        if (!this.hasForwardingStartInputs() && !this.hasEvaluationResultFromLoopInput()) {
            this.componentLog.componentInfo("No 'forwarding' or 'evaluation result' inputs defined -> writing all values at once");
        }
        if (this.componentContext.getOutputMetaDataValue("Design variable", "fitStepSizeToBounds") != null) {
            this.fitStepSizeToBounds = Boolean.valueOf(this.componentContext.getOutputMetaDataValue("Design variable", "fitStepSizeToBounds"));
        }
    }

    private boolean designVariableIsInBounds(double designVariableToTest) {
        if (this.stepSize < 0.0) {
            return designVariableToTest <= this.from && designVariableToTest >= this.to;
        }
        return designVariableToTest >= this.from && designVariableToTest <= this.to;
    }
}

