/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.execution;

import de.rcenvironment.components.evaluationmemory.common.EvaluationMemoryComponentConstants;
import de.rcenvironment.components.evaluationmemory.common.EvaluationMemoryComponentHistoryDataItem;
import de.rcenvironment.components.evaluationmemory.execution.internal.EvaluationMemoryAccess;
import de.rcenvironment.components.evaluationmemory.execution.internal.EvaluationMemoryFileAccessService;
import de.rcenvironment.components.evaluationmemory.execution.internal.ToleranceHandling;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvaluationMemoryComponent
extends DefaultComponent {
    static final double PERCENT_TO_REAL_NUMBER_FACTOR = 0.01;
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ComponentLog componentLog;
    private EvaluationMemoryFileAccessService memoryFileAccessService;
    private ComponentDataManagementService dataManagementService;
    private ComponentContext componentContext;
    private boolean considerLoopFailures;
    private EvaluationMemoryAccess memoryAccess;
    private SortedMap<String, DataType> inputsToEvaluate = new TreeMap<String, DataType>();
    private SortedMap<String, DataType> outputsEvaluationResult = new TreeMap<String, DataType>();
    private SortedMap<String, TypedDatum> valuesToEvaluate;
    private String memoryFilePath;
    private File memoryFile;
    private EvaluationMemoryComponentHistoryDataItem historyData;

    public void setComponentContext(ComponentContext componentContext) {
        super.setComponentContext(componentContext);
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
        this.considerLoopFailures = Boolean.valueOf(componentContext.getConfigurationValue("store_failures"));
    }

    public void start() throws ComponentException {
        this.memoryFileAccessService = (EvaluationMemoryFileAccessService)this.componentContext.getService(EvaluationMemoryFileAccessService.class);
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.setInputsAndOutputs();
        this.initializeMemoryFileAccess(this.getMemoryFilePath());
    }

    private void setInputsAndOutputs() {
        for (String input : this.getInputsOfTypeToEvaluateSortedByName()) {
            this.inputsToEvaluate.put(input, this.componentContext.getInputDataType(input));
        }
        for (String output : this.getOutputsOfTypeEvaluationResultsSortedByName()) {
            this.outputsEvaluationResult.put(output, this.componentContext.getInputDataType(output));
        }
    }

    private String getMemoryFilePath() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("select_at_wf_start")).booleanValue()) {
            return this.componentContext.getConfigurationValue("mem_file_wf_start");
        }
        return this.componentContext.getConfigurationValue("mem_file");
    }

    private void initializeMemoryFileAccess(String path) throws ComponentException {
        if (path == null || path.isEmpty()) {
            throw new ComponentException("No memory file given. Did you forget to configure one?");
        }
        this.memoryFile = new File(path);
        this.memoryFilePath = this.memoryFile.getAbsolutePath();
        try {
            this.memoryAccess = this.memoryFileAccessService.acquireAccessToMemoryFile(this.memoryFilePath);
            if (this.memoryFile.exists() && FileUtils.sizeOf((File)this.memoryFile) > 0L) {
                this.memoryAccess.validateEvaluationMemory(this.inputsToEvaluate, this.outputsEvaluationResult);
            } else {
                this.memoryFile.createNewFile();
                this.memoryAccess.setInputsOutputsDefinition(this.inputsToEvaluate, this.outputsEvaluationResult);
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to access memory file: " + this.memoryFilePath, (Throwable)e);
        }
    }

    public void processInputs() throws ComponentException {
        Set inputsWithDatum = this.componentContext.getInputsWithDatum();
        SortedMap<String, TypedDatum> inputValues = this.getInputValuesSortedByInputsName(inputsWithDatum);
        switch (this.getInputProcessingMode(inputsWithDatum)) {
            case Check: {
                this.initializeNewHistoryData();
                this.processInputsInCheckMode(inputValues);
                break;
            }
            case Store: {
                this.initializeNewHistoryData();
                this.processInputsInStoreMode();
                break;
            }
        }
        try {
            this.addMemoryFileToHistoryData();
        }
        catch (IOException e) {
            String errorMessage = StringUtils.format((String)"Failed to store memory file into the data management for '%s' (%s)", (Object[])new Object[]{this.componentContext.getComponentName(), this.componentContext.getExecutionIdentifier()});
            String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)this.log, (String)errorMessage, (Throwable)e);
            this.componentLog.componentError(errorMessage, (Throwable)e, errorId);
        }
        this.writeFinalHistoryData();
    }

    private void initializeNewHistoryData() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyData = new EvaluationMemoryComponentHistoryDataItem("de.rcenvironment.evaluationmemory");
            this.historyData.setMemoryFilePath(this.memoryFilePath);
        }
    }

    private void addMemoryFileToHistoryData() throws IOException {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            String memoryFileReference = this.dataManagementService.createTaggedReferenceFromLocalFile(this.componentContext, this.memoryFile, this.memoryFile.getName());
            this.historyData.setMemoryFileReference(memoryFileReference);
        }
    }

    private void writeFinalHistoryData() {
        if (this.historyData != null && Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyData);
            this.historyData = null;
        }
    }

    private void processInputsInCheckMode(SortedMap<String, TypedDatum> inputValues) throws ComponentException {
        if (this.valuesToEvaluate != null) {
            this.componentLog.componentWarn(StringUtils.format((String)"Values to evaluate left: '%s' - no result values received (usually in case of component failure in loop) -> skip values", (Object[])new Object[]{inputValues}));
            this.valuesToEvaluate = null;
        }
        SortedMap<String, TypedDatum> evaluationResults = null;
        try {
            SortedMap<String, Double> tolerances = this.constructTolerances(inputValues.keySet());
            ToleranceHandling toleranceHandling = this.constructToleranceHandling();
            evaluationResults = this.memoryAccess.getEvaluationResult(inputValues, this.outputsEvaluationResult, tolerances, toleranceHandling);
        }
        catch (IOException e) {
            String errorMessage = StringUtils.format((String)"Failed to get evaluation results for values '%s' from evaluation memory '%s'; cause: %s - as it is not workflow-critical, continue with execution...", (Object[])new Object[]{inputValues, this.memoryFile, e.getMessage()});
            this.log.error((Object)errorMessage, (Throwable)e);
            this.componentLog.componentError(errorMessage);
        }
        if (evaluationResults == null) {
            this.componentLog.componentInfo(StringUtils.format((String)"Forward values '%s' - no evaluation results in memory", (Object[])new Object[]{inputValues}));
            this.forwardValues(inputValues);
            this.valuesToEvaluate = inputValues;
        } else if (this.evaluationResultsContainValuesOfTypeNotAValue(evaluationResults) && !this.considerLoopFailures) {
            this.componentLog.componentInfo(StringUtils.format((String)"Forward values '%s' - found evaluation results in memory, but they are ignored as they contain values of type not-a-value (loop failures) and component is configured to not consider loop failures as loop result", (Object[])new Object[]{inputValues, evaluationResults}));
            this.forwardValues(inputValues);
            this.valuesToEvaluate = inputValues;
        } else {
            this.componentLog.componentInfo(StringUtils.format((String)"Found evaluation results for values '%s' in memory: %s -> directly feed back", (Object[])new Object[]{inputValues, evaluationResults}));
            for (Map.Entry<String, TypedDatum> entry : evaluationResults.entrySet()) {
                this.componentContext.writeOutput(entry.getKey(), entry.getValue());
            }
        }
    }

    private SortedMap<String, Double> constructTolerances(Set<String> inputs) throws ComponentException {
        TreeMap<String, Double> tolerances = new TreeMap<String, Double>();
        for (String input : inputs) {
            Double toleranceValuePercent;
            String toleranceString = this.componentContext.getInputMetaDataValue(input, "tolerance");
            if (toleranceString == null) {
                String errorMessage = String.format("No tolerance configuration found for input '%s'", input);
                this.componentLog.componentError(errorMessage);
                throw new ComponentException(errorMessage);
            }
            if (toleranceString.isEmpty()) {
                tolerances.put(input, null);
                continue;
            }
            try {
                toleranceValuePercent = Double.valueOf(toleranceString.substring(0, toleranceString.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                String errorMessage = String.format("Invalid tolerance specification stored for input '%s': '%s'", input, toleranceString);
                this.componentLog.componentError(errorMessage);
                throw new ComponentException(errorMessage);
            }
            tolerances.put(input, toleranceValuePercent * 0.01);
        }
        return tolerances;
    }

    private ToleranceHandling constructToleranceHandling() throws ComponentException {
        String overlapBehaviorString = this.componentContext.getConfigurationValue("tolerance_overlap_behavior");
        switch (EvaluationMemoryComponentConstants.OverlapBehavior.parseConfigValue((String)overlapBehaviorString)) {
            case LENIENT: {
                return ToleranceHandling.constructLenientHandling(this.componentLog);
            }
            case STRICT: {
                return ToleranceHandling.constructStrictHandling(this.componentLog);
            }
        }
        throw new ComponentException("Unknown overlap behavior found in configuration");
    }

    private boolean evaluationResultsContainValuesOfTypeNotAValue(SortedMap<String, TypedDatum> evaluationResults) {
        for (TypedDatum result : evaluationResults.values()) {
            if (!result.getDataType().equals((Object)DataType.NotAValue)) continue;
            return true;
        }
        return false;
    }

    private void processInputsInStoreMode() throws ComponentException {
        Set inputsWithDatum = this.componentContext.getInputsWithDatum();
        SortedMap<String, TypedDatum> evaluationResults = this.getDynamicInputValuesSortedByInputsName(inputsWithDatum);
        for (Map.Entry<String, TypedDatum> inputEntry : evaluationResults.entrySet()) {
            if (!this.componentContext.isDynamicInput(inputEntry.getKey())) continue;
            this.componentContext.writeOutput(inputEntry.getKey(), inputEntry.getValue());
        }
        if (this.valuesToEvaluate == null) {
            throw new ComponentException(StringUtils.format((String)"Failed to store evaluation results in evaluation memory file: %s - no values (to evaluate) stored from a previous run", (Object[])new Object[]{this.memoryFilePath}));
        }
        SortedMap<String, TypedDatum> values = this.valuesToEvaluate;
        try {
            this.memoryAccess.addEvaluationValues(values, evaluationResults);
            this.componentLog.componentInfo(StringUtils.format((String)"Stored evaluation results for values '%s' in memory: %s", (Object[])new Object[]{values, evaluationResults}));
        }
        catch (IOException e) {
            String errorMessage = StringUtils.format((String)"Failed to write evaluation values '%s' with '%s' to evaluation memory '%s'; cause: %s - as it is not workflow-critical, continue with execution...", (Object[])new Object[]{values, evaluationResults, this.memoryFile, e.getMessage()});
            this.log.error((Object)errorMessage, (Throwable)e);
            this.componentLog.componentError(errorMessage);
        }
        this.valuesToEvaluate = null;
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.writeFinalHistoryData();
    }

    public void tearDown(Component.FinalComponentState state) {
        if (this.memoryAccess != null) {
            if (!this.memoryFileAccessService.releaseAccessToMemoryFile(this.memoryFilePath)) {
                this.log.warn((Object)("Access to memory file wasn't acquired earlier, but access to it should released anyway now: " + this.memoryFilePath));
            }
        } else {
            this.log.debug((Object)("No need to release access to memory file as it wasn't acquired before: " + this.memoryFilePath));
        }
    }

    private Mode getInputProcessingMode(Set<String> inputsWithDatum) throws ComponentException {
        String input = inputsWithDatum.iterator().next();
        if (this.componentContext.isDynamicInput(input)) {
            if (this.componentContext.getDynamicInputIdentifier(input).equals("to_evaluate")) {
                return Mode.Check;
            }
            if (this.componentContext.getDynamicInputIdentifier(input).equals("evaluation_results")) {
                return Mode.Store;
            }
        }
        throw new ComponentException("Unexpected set of input values");
    }

    private SortedMap<String, TypedDatum> getInputValuesSortedByInputsName(Set<String> inputsWithDatum) {
        TreeMap<String, TypedDatum> inputValues = new TreeMap<String, TypedDatum>();
        for (String input : inputsWithDatum) {
            inputValues.put(input, this.componentContext.readInput(input));
        }
        return inputValues;
    }

    private SortedSet<String> getOutputsOfTypeEvaluationResultsSortedByName() {
        TreeSet<String> outputs = new TreeSet<String>();
        for (String output : this.componentContext.getOutputs()) {
            if (!this.componentContext.isDynamicOutput(output) || !this.componentContext.getDynamicOutputIdentifier(output).equals("evaluation_results")) continue;
            outputs.add(output);
        }
        return outputs;
    }

    private SortedSet<String> getInputsOfTypeToEvaluateSortedByName() {
        TreeSet<String> inputs = new TreeSet<String>();
        for (String input : this.componentContext.getOutputs()) {
            if (!this.componentContext.isDynamicInput(input) || !this.componentContext.getDynamicInputIdentifier(input).equals("to_evaluate")) continue;
            inputs.add(input);
        }
        return inputs;
    }

    private SortedMap<String, TypedDatum> getDynamicInputValuesSortedByInputsName(Set<String> inputsWithDatum) {
        TreeMap<String, TypedDatum> inputValues = new TreeMap<String, TypedDatum>();
        for (String input : inputsWithDatum) {
            if (!this.componentContext.isDynamicInput(input)) continue;
            inputValues.put(input, this.componentContext.readInput(input));
        }
        return inputValues;
    }

    private void forwardValues(SortedMap<String, TypedDatum> inputValues) {
        for (Map.Entry<String, TypedDatum> inputEntry : inputValues.entrySet()) {
            this.componentContext.writeOutput(inputEntry.getKey(), inputEntry.getValue());
        }
    }

    private static enum Mode {
        Check,
        Store;

    }
}

