/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.introduction;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

final class ProjectFile {
    private static final String PROJECT_FILE_NAME = ".project";
    private final IPath absolutePathToProjectFolder;

    private ProjectFile(IPath absolutePathToProjectFolder) {
        this.absolutePathToProjectFolder = absolutePathToProjectFolder;
    }

    public static ProjectFile createForProjectFolder(IPath absolutePathToProjectFolder) {
        return new ProjectFile(absolutePathToProjectFolder);
    }

    public IProjectDescription getProjectDescription() throws CoreException {
        IPath pathToProjectFile = this.getPathToProjectFile();
        return ResourcesPlugin.getWorkspace().loadProjectDescription(pathToProjectFile);
    }

    private IPath getPathToProjectFile() {
        return this.absolutePathToProjectFolder.append(PROJECT_FILE_NAME);
    }

    public IProject getProjectFromWorkspaceByName() throws CoreException {
        IProjectDescription projectDescription = this.getProjectDescription();
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectDescription.getName());
    }

    public boolean exists() {
        return this.getPathToProjectFile().toFile().exists();
    }
}

