/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.matching;

import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamodel.types.api.FloatTD;

public class FloatTDMatcher
implements Matcher<FloatTD> {
    private static final double EPSILON = 1.0E-6;
    private final double epsilon;

    public FloatTDMatcher() {
        this(1.0E-6);
    }

    public FloatTDMatcher(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public MatchResult matches(FloatTD actual, FloatTD expected) {
        MatchResult result = new MatchResult();
        double absDiff = Math.abs(actual.getFloatValue() - expected.getFloatValue());
        if (absDiff > this.epsilon) {
            result.addFailureCause("The float value differs more than the allowed epsilon.");
        }
        return result;
    }
}

