/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.droidparts.dexmaker.stock.ProxyBuilder;
import org.easymock.ConstructorArgs;
import org.easymock.internal.BridgeMethodResolver;
import org.easymock.internal.ClassProxyFactory;
import org.easymock.internal.DefaultClassInstantiator;
import org.easymock.internal.IProxyFactory;

public final class AndroidClassProxyFactory
implements IProxyFactory {
    @Override
    public <T> T createProxy(Class<T> toMock, InvocationHandler handler, Method[] mockedMethods, ConstructorArgs constructorArgs) {
        MockHandler interceptor = new MockHandler(handler, mockedMethods);
        try {
            ProxyBuilder builder = ProxyBuilder.forClass(toMock).handler((InvocationHandler)interceptor);
            if (constructorArgs != null) {
                builder.constructorArgTypes((Class[])constructorArgs.getConstructor().getParameterTypes()).constructorArgValues(constructorArgs.getInitArgs());
            } else {
                try {
                    DefaultClassInstantiator instantiator = new DefaultClassInstantiator();
                    Constructor<?> constructor = instantiator.getConstructorToUse(toMock);
                    Object[] params = instantiator.getArgsForTypes(constructor.getParameterTypes());
                    builder.constructorArgTypes((Class[])constructor.getParameterTypes()).constructorArgValues(params);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Fail to instantiate mock for " + toMock);
                }
            }
            return (T)builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to mock " + toMock, e);
        }
    }

    @Override
    public InvocationHandler getInvocationHandler(Object mock) {
        MockHandler mockHandler = (MockHandler)ProxyBuilder.getInvocationHandler((Object)mock);
        return mockHandler.delegate;
    }

    private static class MockHandler
    implements InvocationHandler {
        private final InvocationHandler delegate;
        private final Set<Method> mockedMethods;

        public MockHandler(InvocationHandler delegate, Method ... mockedMethods) {
            this.delegate = delegate;
            this.mockedMethods = mockedMethods != null ? new HashSet<Method>(Arrays.asList(mockedMethods)) : null;
        }

        @Override
        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            boolean internalFillInStackTraceCall;
            if (method.isBridge()) {
                method = BridgeMethodResolver.findBridgedMethod(method);
            }
            boolean bl = internalFillInStackTraceCall = obj instanceof Throwable && method.getName().equals("fillInStackTrace") && ClassProxyFactory.isCallerMockInvocationHandlerInvoke(new Throwable());
            if (internalFillInStackTraceCall || this.isMocked(method) && !Modifier.isAbstract(method.getModifiers())) {
                return ProxyBuilder.callSuper((Object)obj, (Method)method, (Object[])args);
            }
            return this.delegate.invoke(obj, method, args);
        }

        private boolean isMocked(Method method) {
            return this.mockedMethods != null && !this.mockedMethods.contains(method);
        }
    }
}

