/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionStatsService;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class WorkflowExecutionStatsServiceImpl
implements WorkflowExecutionStatsService {
    private static final int THOUSAND = 1000;
    private static final String CAT_WF_EXEC = "Workflow Execution: Workflow runs by number of components";
    private static final String CAT_WF_EXEC_DURATION = "Workflow Execution: Duration by number of components [sec]";
    private static final String CAT_WF_EXEC_DISTR = "Workflow Execution: Components distribution per workflow run";
    private static final String CAT_WF_EXEC_FINAL_STATES = "Workflow Execution: Final states";
    private static final String KEY_00_05_COMPS = "00..05 components";
    private static final String KEY_06_10_COMPS = "06..10 components";
    private static final String KEY_11_20_COMPS = "11..20 components";
    private static final String KEY_21_30_COMPS = "21..30 components";
    private static final String KEY_31_50_COMPS = "31..50 components";
    private static final String KEY_MORE_THAN_50_COMPS = ">50 components";
    private static final String KEY_TOTAL = "[total]";
    private static final String KEY_LOCAL_COMPS = "local components only";
    private static final String KEY_DISTR_COMPS = "components distributed";
    private static final int FIFTY = 50;
    private static final int THIRTY = 30;
    private static final int TWENTY = 20;
    private PlatformService platformService;
    private Map<String, Long> wfExeStartTimestamps = Collections.synchronizedMap(new HashMap());

    @Override
    public void addStatsAtWorkflowStart(WorkflowExecutionContext wfExeCtx) {
        if (this.wfExeStartTimestamps.containsKey(wfExeCtx.getExecutionIdentifier())) {
            LogFactory.getLog(this.getClass()).error((Object)StringUtils.format((String)"Stats about duration for component '%s' (%s) not recorded properly: last time (start record but no termination record existed)", (Object[])new Object[]{wfExeCtx.getInstanceName(), wfExeCtx.getExecutionIdentifier()}));
        }
        this.wfExeStartTimestamps.put(wfExeCtx.getExecutionIdentifier(), System.currentTimeMillis());
        StatsCounter.count((String)CAT_WF_EXEC, (String)KEY_TOTAL);
        int compCount = wfExeCtx.getWorkflowDescription().getWorkflowNodes().size();
        if (compCount <= 5) {
            StatsCounter.count((String)CAT_WF_EXEC, (String)KEY_00_05_COMPS);
        } else if (compCount <= 10) {
            StatsCounter.count((String)CAT_WF_EXEC, (String)KEY_06_10_COMPS);
        } else if (compCount <= 20) {
            StatsCounter.count((String)CAT_WF_EXEC, (String)KEY_11_20_COMPS);
        } else if (compCount <= 30) {
            StatsCounter.count((String)CAT_WF_EXEC, (String)KEY_21_30_COMPS);
        } else if (compCount <= 50) {
            StatsCounter.count((String)CAT_WF_EXEC, (String)KEY_31_50_COMPS);
        } else {
            StatsCounter.count((String)CAT_WF_EXEC, (String)KEY_MORE_THAN_50_COMPS);
        }
        boolean localOnly = true;
        for (WorkflowNode wn : wfExeCtx.getWorkflowDescription().getWorkflowNodes()) {
            if (this.platformService.matchesLocalInstance((ResolvableNodeId)wn.getComponentDescription().getNode())) continue;
            localOnly = false;
            break;
        }
        if (localOnly) {
            StatsCounter.count((String)CAT_WF_EXEC_DISTR, (String)KEY_LOCAL_COMPS);
        } else {
            StatsCounter.count((String)CAT_WF_EXEC_DISTR, (String)KEY_DISTR_COMPS);
        }
    }

    @Override
    public void addStatsAtWorkflowTermination(WorkflowExecutionContext wfExeCtx, WorkflowState finalWorkflowState) {
        if (this.wfExeStartTimestamps.containsKey(wfExeCtx.getExecutionIdentifier())) {
            int compCount = wfExeCtx.getWorkflowDescription().getWorkflowNodes().size();
            String statsKey = compCount <= 5 ? KEY_00_05_COMPS : (compCount <= 10 ? KEY_06_10_COMPS : (compCount <= 20 ? KEY_11_20_COMPS : (compCount <= 30 ? KEY_21_30_COMPS : (compCount <= 50 ? KEY_31_50_COMPS : KEY_MORE_THAN_50_COMPS))));
            StatsCounter.registerValue((String)CAT_WF_EXEC_DURATION, (String)statsKey, (long)Math.abs((System.currentTimeMillis() - this.wfExeStartTimestamps.get(wfExeCtx.getExecutionIdentifier())) / 1000L));
            this.wfExeStartTimestamps.remove(wfExeCtx.getExecutionIdentifier());
        } else {
            LogFactory.getLog(this.getClass()).error((Object)StringUtils.format((String)"Failed to add stats about duration for workflow '%s' (%s)", (Object[])new Object[]{wfExeCtx.getInstanceName(), wfExeCtx.getExecutionIdentifier()}));
        }
        StatsCounter.count((String)CAT_WF_EXEC_FINAL_STATES, (String)finalWorkflowState.getDisplayName());
    }

    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }
}

