/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.inputprovider.execution;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.components.inputprovider.common.InputProviderComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InputProviderPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String VERSION_3_0 = "3.0";
    private static final String VERSION_3_1 = "3.1";
    private static final String VERSION_3_2 = "3.2";
    private static final String CURRENT_VERSION = "3.2";

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return InputProviderComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int update = 0;
        if (!silent) {
            if (persistentComponentDescriptionVersion == null || persistentComponentDescriptionVersion.compareTo(VERSION_3_0) < 0) {
                update |= 2;
            }
            if (persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo("3.2") < 0) {
                update |= 4;
            }
        }
        return update;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        if (!silent) {
            switch (formatVersion) {
                case 2: {
                    description = this.updateTo30(description);
                    break;
                }
                case 4: {
                    if (description.getComponentVersion().compareTo(VERSION_3_1) < 0) {
                        description = this.updateFrom30To31(description);
                    }
                    if (description.getComponentVersion().compareTo("3.2") >= 0) break;
                    description = this.updateFrom31To32(description);
                    break;
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updateTo30(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)"dynamicOutputs", (String)"default", (PersistentComponentDescription)description);
        description.setComponentVersion(VERSION_3_0);
        return description;
    }

    private PersistentComponentDescription updateFrom30To31(PersistentComponentDescription description) throws JsonParseException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode configNode = node.get("dynamicOutputs");
        Iterator iterator = configNode.elements();
        while (iterator.hasNext()) {
            ObjectNode outputNode = (ObjectNode)iterator.next();
            if (!outputNode.get("datatype").textValue().equals(DataType.FileReference.name())) continue;
            ObjectNode metaDataNode = (ObjectNode)outputNode.get("metadata");
            metaDataNode.set("startValue", (JsonNode)TextNode.valueOf((String)StringUtils.format((String)"${%s}", (Object[])new Object[]{outputNode.get("name").textValue()})));
            metaDataNode.set("fileSourceType", (JsonNode)TextNode.valueOf((String)"atWorkflowStart"));
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(VERSION_3_1);
        return description;
    }

    private PersistentComponentDescription updateFrom31To32(PersistentComponentDescription description) throws JsonParseException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectNode configurationsNode = (ObjectNode)node.get("configuration");
        if (configurationsNode != null) {
            Iterator fields = configurationsNode.fields();
            HashMap<String, String> fileOutputs = new HashMap<String, String>();
            HashMap<String, String> dirOutputs = new HashMap<String, String>();
            while (fields.hasNext()) {
                Map.Entry configurationNode = (Map.Entry)fields.next();
                String ouputName = (String)configurationNode.getKey();
                String value = ((TextNode)configurationNode.getValue()).textValue();
                if (value.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}") || value.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*) \\(File\\)\\}")) {
                    fields.remove();
                    fileOutputs.put(ouputName, value);
                    continue;
                }
                if (!value.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*) \\(Directory\\)\\}")) continue;
                fields.remove();
                dirOutputs.put(ouputName, value);
            }
            for (String outputName : fileOutputs.keySet()) {
                configurationsNode.put(outputName, ((String)fileOutputs.get(outputName)).replace(" (File)", ""));
                configurationsNode.put(String.valueOf(outputName) + "_datatype_799ef365", "file");
            }
            for (String outputName : dirOutputs.keySet()) {
                configurationsNode.put(outputName, ((String)dirOutputs.get(outputName)).replace(" (Directory)", ""));
                configurationsNode.put(String.valueOf(outputName) + "_datatype_799ef365", "dir");
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion("3.2");
        return description;
    }
}

