/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.eventlog.api;

import java.util.Optional;

public enum EventType {
    APPLICATION_STARTING("application.starting", "Application Starting", new String[]{"user_home", "user_name", "profile_location", "work_dir", "rce_version", "os_name", "jvm_version"}, new String[]{"User home directory", "User system id", "Profile location", "Working directory", "RCE version id", "OS name and version", "JVM version"}),
    APPLICATION_SHUTDOWN_REQUESTED("application.shutdown.requested", "Application Shutdown Requested", new String[]{"method", "is_restart"}, new String[]{"Shutdown trigger", "Part of a restart"}),
    APPLICATION_TERMINATING("application.terminating", "Application Terminating", new String[0], new String[0]),
    SERVERPORT_OPENED("serverport.opened", "Server Port Opened", new String[]{"type", "port", "bind_ip"}, new String[]{"Port type", "IP port number", "IP bind address"}),
    SERVERPORT_CLOSED("serverport.closed", "Server Port Closed", new String[]{"type", "port", "bind_ip"}, new String[]{"Port type", "IP port number", "IP bind address"}),
    CONNECTION_INCOMING_ACCEPTED("connection.incoming.accepted", "Incoming Connection Accepted", new String[]{"type", "connection_id", "client_version", "remote_node_id", "login_name", "auth_method", "auth_failure_count", "remote_ip", "remote_port", "server_port"}, new String[]{"Connection type", "Connection id", "Client software id", "Remote node id", "Login/user name", "Authentication method", "Failure count", "Remote IP address", "Remote IP port", "Server IP port"}),
    CONNECTION_INCOMING_AUTH_FAILED("connection.incoming.auth.failed", "Incoming Connection Failed To Authenticate", new String[]{"type", "connection_id", "client_version", "login_name", "auth_method", "auth_failure_reason", "auth_failure_count", "remote_ip", "remote_port", "server_port"}, new String[]{"Connection type", "Connection id", "Client software id", "Login/user name", "Authentication method", "Failure reason", "Failure count", "Remote IP address", "Remote IP port", "Server IP port"}),
    CONNECTION_INCOMING_REFUSED("connection.incoming.refused", "Incoming Connection Refused", new String[]{"type", "connection_id", "client_version", "close_reason", "last_login_name", "last_auth_failure_reason", "last_auth_method", "auth_failure_count", "remote_ip", "remote_port", "server_port", "duration"}, new String[]{"Connection type", "Connection id", "Client software id", "Reason", "Last login/user name", "Last auth. failure", "Last auth. method", "Auth. failure count", "Remote IP address", "Remote IP port", "Server IP port", "Duration"}),
    CONNECTION_INCOMING_CLOSED("connection.incoming.closed", "Incoming Connection Closed", new String[]{"type", "connection_id", "client_version", "remote_node_id", "close_reason", "remote_ip", "remote_port", "server_port", "duration"}, new String[]{"Connection type", "Connection id", "Client software id", "Remote node id", "Reason", "Remote IP address", "Remote IP port", "Server IP port", "Duration"}),
    UPLINK_INCOMING_ACCEPTED("uplink.incoming.accepted", "Incoming Uplink Connection Accepted", new String[]{"session_id", "connection_id", "client_version", "protocol_version", "login_name", "original_login_name", "client_id", "original_client_id", "namespace"}, new String[]{"Uplink session id", "SSH connection id", "Client software id", "Protocol version", "Effective login name", "Original login name", "Effective client id", "Original client id", "Assigned namespace"}),
    UPLINK_INCOMING_REFUSED("uplink.incoming.refused", "Incoming Uplink Connection Refused", new String[]{"session_id", "connection_id", "client_version", "protocol_version", "login_name", "client_id", "reason"}, new String[]{"Uplink session id", "SSH connection id", "Client software id", "Protocol version", "Original login name", "Original client id", "Reason"}),
    UPLINK_INCOMING_CLOSED("uplink.incoming.closed", "Incoming Uplink Connection Closed", new String[]{"session_id", "connection_id", "final_state"}, new String[]{"Uplink session id", "SSH connection id", "Final connection state"}),
    NETWORK_NODE_NAMED("network.node.named", "Network Node Discovered/Named", new String[]{"instance_id", "session_id", "logical_sub_node_id", "name", "is_local_node"}, new String[]{"Persistent instance id", "Instance session id", "Logical sub-node id", "Announced name", "Is local/own node"}),
    WORKFLOW_REQUEST_INITIATED("workflow.request.initiated", "Workflow Request Initiated (Request Sent)", new String[]{"workflow_run_id", "workflow_controller_node", "workflow_controller_is_local_node", "local_workflow_file", "workflow_metadata", "success"}, new String[]{"Workflow run id", "Workflow controller node", "Controller is local", "Workflow file path", "Workflow metadata (WIP)", "success"}),
    WORKFLOW_EXECUTION_REQUESTED("workflow.execution.requested", "Workflow Execution Requested (Request Received)", new String[]{"workflow_run_id", "start_ts", "initiator_node", "initiator_is_local_node", "workflow_metadata", "success"}, new String[]{"Workflow run id", "Start timestamp", "Initiator node", "Initiator is local", "Workflow metadata (WIP)", "success"}),
    WORKFLOW_EXECUTION_COMPLETED("workflow.execution.completed", "Workflow Execution Completed", new String[]{"workflow_run_id", "end_ts", "duration", "final_state"}, new String[]{"Workflow run id", "End timestamp", "Duration", "Final workflow state"}),
    WORKFLOW_REQUEST_COMPLETED("workflow.request.completed", "Workflow Request Completed", new String[]{"workflow_run_id", "final_state"}, new String[]{"Workflow run id", "Final workflow state"}),
    COMPONENT_REQUEST_INITIATED("component.request.initiated", "Component/Tool Execution Initiated (Request Sent)", new String[]{"workflow_run_id", "component_run_id", "execution_controller_node", "execution_controller_is_local_node"}, new String[]{"Workflow run id", "Component run id", "Executing node", "Executing node is local"}),
    COMPONENT_EXECUTION_REQUESTED("component.execution.requested", "Component/Tool Execution Requested", new String[]{"workflow_run_id", "component_run_id", "workflow_controller_node", "workflow_controller_is_local_node", "start_ts"}, new String[]{"Workflow run id", "Component run id", "Workflow controller node", "Workflow contr. is local", "Start timestamp"}),
    COMPONENT_EXECUTION_COMPLETED("component.execution.completed", "Component/Tool Execution Completed", new String[]{"workflow_run_id", "component_run_id", "end_ts", "duration", "final_state"}, new String[]{"Workflow run id", "Component run id", "End timestamp", "Duration", "Final component state"}),
    COMPONENT_REQUEST_COMPLETED("component.request.completed", "Component/Tool Execution Request Completed", new String[]{"workflow_run_id", "component_run_id", "end_ts", "duration", "final_state"}, new String[]{"Workflow run id", "Component run id", "End timestamp", "Duration", "Final component state"}),
    ACCOUNTS_INITIALIZED("accounts.initialized", "Login/Account Data Initialized", new String[]{"type", "number_of_accounts", "origin"}, new String[]{"Account type", "New number of accounts", "Account data origin"}),
    ACCOUNTS_UPDATED("accounts.updated", "Login/Account Data Updated", new String[]{"type", "number_of_accounts", "origin"}, new String[]{"Account type", "New number of accounts", "Account data origin"}),
    SYSMON_INITIALIZED("sysmon.initialized", "System Monitoring Initialized", new String[]{"jvm_pid", "jvm_processor_count", "jvm_heap_limit", "system_total_ram", "system_logical_cpus"}, new String[]{"Java process id", "Processor count (JVM)", "Heap limit (JVM)", "System RAM (native)", "Logical CPUs (native)"}),
    CUSTOM("custom", "Custom Event", new String[]{"type"}, new String[]{"Custom event type id"});

    private final String id;
    private final String title;
    private String[] attributeKeys;
    private String[] attributeTitles;

    private EventType(String typeId, String title, String[] attributeKeys, String[] attributeTitles) {
        this.id = typeId;
        this.title = title;
        this.attributeKeys = attributeKeys;
        this.attributeTitles = attributeTitles;
        if (attributeKeys.length != attributeTitles.length) {
            throw new IllegalArgumentException();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getAttributeKeys() {
        return this.attributeKeys;
    }

    public Optional<String> getAttributeTitle(String key) {
        int i = 0;
        while (i < this.attributeKeys.length) {
            if (key.equals(this.attributeKeys[i])) {
                return Optional.of(this.attributeTitles[i]);
            }
            ++i;
        }
        return Optional.empty();
    }

    public static class Attributes {
        public static final String USER_HOME = "user_home";
        public static final String USER_NAME = "user_name";
        public static final String PROFILE_LOCATION = "profile_location";
        public static final String WORK_DIR = "work_dir";
        public static final String RCE_VERSION = "rce_version";
        public static final String OS_NAME = "os_name";
        public static final String JVM_VERSION = "jvm_version";
        public static final String METHOD = "method";
        public static final String IS_RESTART = "is_restart";
        public static final String TYPE = "type";
        public static final String PORT = "port";
        public static final String BIND_IP = "bind_ip";
        public static final String CONNECTION_ID = "connection_id";
        public static final String CLIENT_VERSION = "client_version";
        public static final String REMOTE_NODE_ID = "remote_node_id";
        public static final String LOGIN_NAME = "login_name";
        public static final String AUTH_METHOD = "auth_method";
        public static final String AUTH_FAILURE_COUNT = "auth_failure_count";
        public static final String REMOTE_IP = "remote_ip";
        public static final String REMOTE_PORT = "remote_port";
        public static final String SERVER_PORT = "server_port";
        public static final String AUTH_FAILURE_REASON = "auth_failure_reason";
        public static final String CLOSE_REASON = "close_reason";
        public static final String LAST_LOGIN_NAME = "last_login_name";
        public static final String LAST_AUTH_FAILURE_REASON = "last_auth_failure_reason";
        public static final String LAST_AUTH_METHOD = "last_auth_method";
        public static final String DURATION = "duration";
        public static final String SESSION_ID = "session_id";
        public static final String PROTOCOL_VERSION = "protocol_version";
        public static final String ORIGINAL_LOGIN_NAME = "original_login_name";
        public static final String CLIENT_ID = "client_id";
        public static final String ORIGINAL_CLIENT_ID = "original_client_id";
        public static final String NAMESPACE = "namespace";
        public static final String REASON = "reason";
        public static final String FINAL_STATE = "final_state";
        public static final String INSTANCE_ID = "instance_id";
        public static final String LOGICAL_SUB_NODE_ID = "logical_sub_node_id";
        public static final String NAME = "name";
        public static final String IS_LOCAL_NODE = "is_local_node";
        public static final String WORKFLOW_RUN_ID = "workflow_run_id";
        public static final String WORKFLOW_CONTROLLER_NODE = "workflow_controller_node";
        public static final String WORKFLOW_CONTROLLER_IS_LOCAL_NODE = "workflow_controller_is_local_node";
        public static final String LOCAL_WORKFLOW_FILE = "local_workflow_file";
        public static final String WORKFLOW_METADATA = "workflow_metadata";
        public static final String SUCCESS = "success";
        public static final String START_TS = "start_ts";
        public static final String INITIATOR_NODE = "initiator_node";
        public static final String INITIATOR_IS_LOCAL_NODE = "initiator_is_local_node";
        public static final String END_TS = "end_ts";
        public static final String COMPONENT_RUN_ID = "component_run_id";
        public static final String EXECUTION_CONTROLLER_NODE = "execution_controller_node";
        public static final String EXECUTION_CONTROLLER_IS_LOCAL_NODE = "execution_controller_is_local_node";
        public static final String NUMBER_OF_ACCOUNTS = "number_of_accounts";
        public static final String ORIGIN = "origin";
        public static final String JVM_PID = "jvm_pid";
        public static final String JVM_PROCESSOR_COUNT = "jvm_processor_count";
        public static final String JVM_HEAP_LIMIT = "jvm_heap_limit";
        public static final String SYSTEM_TOTAL_RAM = "system_total_ram";
        public static final String SYSTEM_LOGICAL_CPUS = "system_logical_cpus";
    }
}

