/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.handlers;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.gui.workflow.ConnectionUtils;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.editor.commands.BendpointDeleteAllCommand;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.ConnectionWrapper;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ConnectionBendpointDeleteHandler
extends AbstractHandler {
    protected GraphicalViewer viewer;
    protected CommandStack commandStack;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (activePart instanceof WorkflowEditor) {
            WorkflowEditor editor = (WorkflowEditor)activePart;
            this.viewer = editor.getViewer();
            this.commandStack = (CommandStack)editor.getAdapter(CommandStack.class);
        }
        WorkflowDescription model = (WorkflowDescription)this.viewer.getContents().getModel();
        ConnectionWrapper connectionWrapper = null;
        List selections = this.viewer.getSelectedEditParts();
        for (Object element : selections) {
            if (!(element instanceof ConnectionPart)) continue;
            ConnectionPart part = (ConnectionPart)element;
            connectionWrapper = (ConnectionWrapper)part.getModel();
            BendpointDeleteAllCommand bendpointDeleteCommand = new BendpointDeleteAllCommand();
            bendpointDeleteCommand.setConnections(ConnectionUtils.getConnectionsFromSourceToTarget(connectionWrapper.getSource(), connectionWrapper.getTarget(), model));
            bendpointDeleteCommand.setReferencedModel(connectionWrapper);
            bendpointDeleteCommand.setWorkflowDescription(model);
            this.commandStack.execute((Command)bendpointDeleteCommand);
        }
        return null;
    }
}

