/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.update.api;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentComponentDescription
implements Serializable {
    private static final long serialVersionUID = -1647564436671866175L;
    private static final String PLATFORM = "platform";
    private static final String VERSION = "version";
    private static final String IDENTIFIER = "identifier";
    private static final String COMPONENT = "component";
    private static final Log LOGGER = LogFactory.getLog(PersistentComponentDescription.class);
    private String componentIdentifier;
    private String componentVersion = "";
    private LogicalNodeId componentNodeIdentifier = null;
    private String persistentComponentDescriptionString;

    public PersistentComponentDescription(String persistentComponentDescription) throws JsonParseException, IOException {
        JsonNode node;
        this.persistentComponentDescriptionString = persistentComponentDescription;
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var5_5 = null;
        try (JsonParser jsonParser = jsonFactory.createJsonParser(persistentComponentDescription);){
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            node = (JsonNode)mapper.readTree(jsonParser);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!node.has(COMPONENT)) {
            throw new IOException("Required attribute 'component' missing in node delcaration");
        }
        if (!node.get(COMPONENT).has(IDENTIFIER)) {
            throw new IOException("Required attribute 'identifier' missing in node's component delcaration");
        }
        this.componentIdentifier = node.get(COMPONENT).get(IDENTIFIER).textValue();
        if (node.get(COMPONENT).has(VERSION)) {
            this.componentVersion = node.get(COMPONENT).get(VERSION).textValue();
        }
        if (node.has(PLATFORM)) {
            String encodedNodeId = node.get(PLATFORM).textValue();
            try {
                this.componentNodeIdentifier = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeId((String)encodedNodeId);
            }
            catch (IdentifierException identifierException) {
                throw new IOException("Invalid node id string: " + encodedNodeId);
            }
        }
    }

    public String getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
        this.setComponentValueInDescription(VERSION, componentVersion);
    }

    private void setComponentValueInDescription(String componentKey, String value) {
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (JsonParser jsonParser = jsonFactory.createJsonParser(this.persistentComponentDescriptionString);){
                ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                JsonNode node = (JsonNode)mapper.readTree(jsonParser);
                JsonNode componentNode = node.get(COMPONENT);
                ((ObjectNode)componentNode).remove(componentKey);
                ((ObjectNode)componentNode).put(componentKey, (JsonNode)TextNode.valueOf((String)value));
                this.persistentComponentDescriptionString = mapper.writeValueAsString((Object)node);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException e) {
            LOGGER.debug((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug((Object)"", (Throwable)e);
        }
    }

    public void setNodeIdentifier(LogicalNodeId nodeId) {
        this.componentNodeIdentifier = nodeId;
        JsonFactory jsonFactory = new JsonFactory();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (JsonParser jsonParser = jsonFactory.createJsonParser(this.persistentComponentDescriptionString);){
                ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
                JsonNode node = (JsonNode)mapper.readTree(jsonParser);
                ((ObjectNode)node).remove(PLATFORM);
                if (nodeId != null) {
                    ((ObjectNode)node).put(PLATFORM, (JsonNode)TextNode.valueOf((String)nodeId.getLogicalNodeIdString()));
                }
                this.persistentComponentDescriptionString = mapper.writeValueAsString((Object)node);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException e) {
            LOGGER.debug((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug((Object)"", (Throwable)e);
        }
    }

    public LogicalNodeId getComponentNodeIdentifier() {
        return this.componentNodeIdentifier;
    }

    public String getComponentDescriptionAsString() {
        return this.persistentComponentDescriptionString;
    }
}

