/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;

public class ResizableEditPolicy
extends NonResizableEditPolicy {
    private int resizeDirections = 29;

    @Override
    protected List createSelectionHandles() {
        if (this.resizeDirections == 0) {
            return super.createSelectionHandles();
        }
        ArrayList list = new ArrayList();
        this.createMoveHandle(list);
        this.createResizeHandle(list, 1);
        this.createResizeHandle(list, 16);
        this.createResizeHandle(list, 4);
        this.createResizeHandle(list, 8);
        this.createResizeHandle(list, 20);
        this.createResizeHandle(list, 12);
        this.createResizeHandle(list, 9);
        this.createResizeHandle(list, 17);
        return list;
    }

    protected void createResizeHandle(List handles, int direction) {
        if ((this.resizeDirections & direction) == direction) {
            ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), handles, direction, this.getResizeTracker(direction), Cursors.getDirectionalCursor((int)direction, (boolean)this.getHostFigure().isMirrored()));
        } else {
            this.createDragHandle(handles, direction);
        }
    }

    protected ResizeTracker getResizeTracker(int direction) {
        return new ResizeTracker((GraphicalEditPart)this.getHost(), direction);
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    @Override
    public Command getCommand(Request request) {
        if ("resize".equals(request.getType())) {
            return this.getResizeCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest("resize children");
        req.setEditParts(this.getHost());
        req.setCenteredResize(request.isCenteredResize());
        req.setConstrainedMove(request.isConstrainedMove());
        req.setConstrainedResize(request.isConstrainedResize());
        req.setSnapToEnabled(request.isSnapToEnabled());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        return this.getHost().getParent().getCommand(req);
    }

    public void setResizeDirections(int newDirections) {
        this.resizeDirections = newDirections;
    }

    @Override
    public void showSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.showSourceFeedback(request);
        }
    }

    @Override
    public boolean understandsRequest(Request request) {
        if ("resize".equals(request.getType())) {
            int resizeDirections = ((ChangeBoundsRequest)request).getResizeDirection();
            return (resizeDirections & this.getResizeDirections()) == resizeDirections;
        }
        return super.understandsRequest(request);
    }

    public int getResizeDirections() {
        return this.resizeDirections;
    }
}

