/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap;

import de.rcenvironment.core.configuration.bootstrap.BundleTracker;
import de.rcenvironment.core.configuration.bootstrap.EclipseLaunchParameters;
import de.rcenvironment.core.configuration.bootstrap.LogArchiver;
import de.rcenvironment.core.configuration.bootstrap.LogSystemConfigurator;
import de.rcenvironment.core.configuration.bootstrap.ParameterException;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.configuration.bootstrap.SystemExitException;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfile;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileUtils;
import de.rcenvironment.core.configuration.bootstrap.ui.ProfileSelectionUI;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BootstrapConfiguration {
    public static final String SYSTEM_PROPERTY_EXIT_ON_LOCKED_PROFILE = "rce.launch.exitOnLockedProfile";
    public static final String SYSTEM_PROPERTY_OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String USING_SHUTDOWN_PROFILE = "Using shutdown profile.";
    private static final String USING_FALLBACK_PROFILE = "Using fallback profile.";
    private static final String FAILED_TO_LOCK_PROFILE_TEMPLATE = "Failed to lock profile directory %s - most likely, another instance is already using it.";
    private static final String NO_LOCK_ON_FALLBACK_TEMPLATE = "Could not acquire a lock on the fallback profile directory %s either - giving up";
    private static final String FALLBACK_PROFILE_IS_DISABLED_SHUTTING_DOWN = "Fallback profile is disabled, shutting down.";
    private static final String PROFILE_OPTION_HINT = " (use -p/--profile <id or path> to override)";
    private static final String NEWER_PROFILE_VERSION_TEMPLATE = "The required version of the profile directory is %d but the profile directory's current version is newer. Most likely, this is the case  because it has been used with a newer RCE version before. As downgrading of profiles is not supported, the configured profile directory cannot be used with this RCE version. Choose another profile directory. (See the user guide for more information about the profile directory.)";
    private static final String PROFILE_OPTION_LONG_KEY = "--profile";
    private static final String PROFILE_OPTION_SHORT_KEY = "-p";
    private static volatile BootstrapConfiguration instance;
    private Profile originalProfile;
    private Profile finalProfile;
    private final boolean runningInTestEnvironment;
    private final boolean launchedAsShutdownTrigger;
    private String profileOptionHintToPrint;
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean shouldPerformProfileInitialization;

    private BootstrapConfiguration() throws ProfileException, ParameterException, SystemExitException {
        EclipseLaunchParameters launchParameters = EclipseLaunchParameters.getInstance();
        this.launchedAsShutdownTrigger = launchParameters.containsToken("--shutdown");
        this.shouldPerformProfileInitialization = !RuntimeDetection.isImplicitServiceActivationDenied();
        this.runningInTestEnvironment = RuntimeDetection.isTestEnvironment();
        if (this.shouldPerformProfileInitialization) {
            this.initializeProfileAndRelatedOptions();
            LogArchiver.run(this.finalProfile.getProfileDirectory());
        }
        if (!this.runningInTestEnvironment) {
            this.reconfigureLogSystemWithProfileDir();
            BundleTracker.install();
        }
    }

    private void initializeProfileAndRelatedOptions() throws ProfileException, ParameterException, SystemExitException {
        PrintStream stderr = System.err;
        PrintStream stdout = System.out;
        EclipseLaunchParameters launchParameters = EclipseLaunchParameters.getInstance();
        Profile preliminaryProfile = this.originalProfile = this.openOriginalProfileDir(launchParameters);
        boolean fallbackProfileDisabled = System.getProperties().containsKey(SYSTEM_PROPERTY_EXIT_ON_LOCKED_PROFILE) || launchParameters.containsToken("--headless") || launchParameters.containsToken("--batch");
        boolean profileUpgradeRequested = launchParameters.containsToken("--upgrade-profile");
        if (!preliminaryProfile.hasCurrentVersion()) {
            if (preliminaryProfile.hasUpgradeableVersion()) {
                if (profileUpgradeRequested) {
                    try {
                        preliminaryProfile.upgradeToCurrentVersion();
                    }
                    catch (IOException e) {
                        String errorMessage = String.format("Could not upgrade profile \"%s\" to current version.", this.originalProfile.getName());
                        throw new ProfileException(errorMessage, e);
                    }
                }
            } else {
                if (fallbackProfileDisabled) {
                    this.log.error((Object)StringUtils.format((String)NEWER_PROFILE_VERSION_TEMPLATE, (Object[])new Object[]{Profile.PROFILE_VERSION_NUMBER}));
                    stderr.println(StringUtils.format((String)NEWER_PROFILE_VERSION_TEMPLATE, (Object[])new Object[]{Profile.PROFILE_VERSION_NUMBER}));
                    throw new SystemExitException(0);
                }
                stderr.println(USING_FALLBACK_PROFILE);
                preliminaryProfile = ProfileUtils.getFallbackProfile();
            }
        }
        if (this.launchedAsShutdownTrigger) {
            preliminaryProfile = new CommonProfile.Builder(new File(this.originalProfile.getInternalDirectory(), "shutdown")).create(true).migrate(true).buildUserProfile();
            stdout.println(USING_SHUTDOWN_PROFILE);
        }
        if (preliminaryProfile.attemptToLockProfileDirectory()) {
            this.finalProfile = preliminaryProfile;
        } else {
            stderr.println(StringUtils.format((String)FAILED_TO_LOCK_PROFILE_TEMPLATE, (Object[])new Object[]{preliminaryProfile.getProfileDirectory()}));
            if (fallbackProfileDisabled) {
                this.log.error((Object)FALLBACK_PROFILE_IS_DISABLED_SHUTTING_DOWN);
                stderr.println(FALLBACK_PROFILE_IS_DISABLED_SHUTTING_DOWN);
                throw new SystemExitException(0);
            }
            preliminaryProfile = ProfileUtils.getFallbackProfile();
            stderr.println(USING_FALLBACK_PROFILE);
            if (preliminaryProfile.attemptToLockProfileDirectory()) {
                this.finalProfile = preliminaryProfile;
            } else {
                throw new ProfileException(StringUtils.format((String)NO_LOCK_ON_FALLBACK_TEMPLATE, (Object[])new Object[]{preliminaryProfile.getProfileDirectory()}));
            }
        }
        if (this.finalProfile.equals(this.originalProfile)) {
            stdout.println(StringUtils.format((String)"Using profile directory %s %s", (Object[])new Object[]{this.finalProfile.getProfileDirectory().getAbsolutePath(), this.profileOptionHintToPrint}));
        }
        if (this.finalProfile.equals(this.originalProfile)) {
            try {
                this.originalProfile.markAsRecentlyUsed();
            }
            catch (ProfileException e) {
                this.log.warn((Object)"Unable to mark the profile as recently used.", (Throwable)e);
            }
        }
    }

    public static void initialize() throws ProfileException, ParameterException, SystemExitException {
        instance = new BootstrapConfiguration();
    }

    public static BootstrapConfiguration getInstance() {
        if (instance == null) {
            try {
                instance = new BootstrapConfiguration();
            }
            catch (ParameterException | SystemExitException | ProfileException e) {
                throw new RuntimeException("No " + BootstrapConfiguration.class.getSimpleName() + " instance available, and creating an implicit instance failed as well; aborting", e);
            }
            if (!BootstrapConfiguration.instance.runningInTestEnvironment) {
                LogFactory.getLog(BootstrapConfiguration.class).error((Object)("No " + BootstrapConfiguration.class.getSimpleName() + " instance available - most likely, its containing bundle has not been properly initialized, " + "or the instance is not accessible due to a classloading issue; created an implicit one to proceed"));
            }
        }
        return instance;
    }

    private Profile openOriginalProfileDir(EclipseLaunchParameters launchParams) throws ProfileException, ParameterException, SystemExitException {
        File profileDir;
        File configuredPath;
        String profilePath = null;
        profilePath = launchParams.getNamedParameter(PROFILE_OPTION_SHORT_KEY, PROFILE_OPTION_LONG_KEY);
        if (profilePath != null) {
            this.profileOptionHintToPrint = "(as specified by the -p/--profile option)";
        } else if (launchParams.containsToken(PROFILE_OPTION_SHORT_KEY, PROFILE_OPTION_LONG_KEY)) {
            Profile selectedProfile = new ProfileSelectionUI().run();
            if (selectedProfile == null) {
                throw new SystemExitException(0);
            }
            profilePath = selectedProfile.getProfileDirectory().getAbsolutePath();
            this.profileOptionHintToPrint = "(as specified by the profile selection dialog)";
        } else if (!this.shouldPerformProfileInitialization) {
            TempFileServiceAccess.setupUnitTestEnvironment();
            try {
                profilePath = TempFileServiceAccess.getInstance().createManagedTempDir("launchProfile").getAbsolutePath();
            }
            catch (IOException e) {
                throw new ProfileException("Failed to initialize temporary test profile", e);
            }
            this.profileOptionHintToPrint = "(temporary launch profile for test environment)";
        }
        if (profilePath == null) {
            this.profileOptionHintToPrint = PROFILE_OPTION_HINT;
            profilePath = ProfileUtils.getDefaultProfilePath().getAbsolutePath();
        }
        if ((configuredPath = new File(profilePath)).isAbsolute()) {
            profileDir = configuredPath;
        } else {
            File profilesRootDirectory = ProfileUtils.getProfilesParentDirectory();
            profileDir = new File(profilesRootDirectory, profilePath).getAbsoluteFile();
        }
        return new CommonProfile.Builder(profileDir).create(true).migrate(false).buildUserProfile();
    }

    private void reconfigureLogSystemWithProfileDir() {
        String logfilesPrefix = "";
        if (this.launchedAsShutdownTrigger) {
            logfilesPrefix = "shutdown-";
        }
        new LogSystemConfigurator().relocateLogFilesToProfileDirectory(this.finalProfile.getProfileDirectory(), logfilesPrefix);
    }

    public File getProfileDirectory() {
        return this.finalProfile.getProfileDirectory();
    }

    public Profile getProfile() {
        return this.finalProfile;
    }

    public File getInternalDataDirectory() {
        return this.finalProfile.getInternalDirectory();
    }

    public boolean deleteInternalDataDirectoryIfEmpty() {
        new File(this.getInternalDataDirectory(), "profile.version").delete();
        return this.getInternalDataDirectory().delete();
    }

    public Profile getOriginalProfile() {
        return this.originalProfile;
    }

    public boolean isShutdownRequested() {
        return this.launchedAsShutdownTrigger;
    }

    public File getOwnShutdownDataDirectory() {
        return this.finalProfile.getInternalDirectory();
    }

    public File getTargetShutdownDataDirectory() {
        return this.originalProfile.getInternalDirectory();
    }

    public static File getInstallationDir() {
        String osgiInstallArea = System.getProperty(SYSTEM_PROPERTY_OSGI_INSTALL_AREA);
        if (osgiInstallArea != null) {
            String installationLocationPath = osgiInstallArea.replace("file:", "");
            File installationLocation = new File(installationLocationPath);
            if (installationLocation.isDirectory()) {
                return installationLocation.getAbsoluteFile();
            }
            throw new IllegalStateException("Property 'osgi.install.area' is defined but does not point to a directory");
        }
        throw new IllegalStateException("Property 'osgi.install.area' is null when it is required to determine the installation data directory");
    }
}

