/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.view.internal;

import de.rcenvironment.core.gui.cluster.internal.ErrorMessageDialogFactory;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobInformationModel;
import de.rcenvironment.core.utils.cluster.ClusterJobInformation;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class KillClusterJobListenerListener
implements SelectionListener {
    private static final String CANCELLING_JOBS_FAILED = "Cancelling jobs failed";
    private static final Log LOGGER = LogFactory.getLog(KillClusterJobListenerListener.class);
    private TableViewer tableViewer;
    private Action refreshAction;

    public KillClusterJobListenerListener(TableViewer tableViewer, Action refreshAction) {
        this.tableViewer = tableViewer;
        this.refreshAction = refreshAction;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        ISelection selection = this.tableViewer.getSelection();
        ArrayList<String> jobIds = new ArrayList<String>();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (ClusterJobInformation informationEntry : sel) {
                jobIds.add(informationEntry.getJobId());
            }
        }
        try {
            ClusterJobInformationModel.getInstance().getClusterInformationService().cancelClusterJobs(jobIds);
        }
        catch (IOException e) {
            LOGGER.error((Object)CANCELLING_JOBS_FAILED, (Throwable)e);
            ErrorMessageDialogFactory.createMessageDialogForCancelingJobsFailure((Composite)this.tableViewer.getTable(), e.getMessage()).open();
        }
        this.refreshAction.run();
    }
}

