/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.osgi.service.component.annotations.Component;

@Component(service={FileService.class})
public class FileService {
    public File createFile(String parent, String child) {
        return new File(parent, child);
    }

    public Path getPath(String absolutePath) {
        return FileSystems.getDefault().getPath(absolutePath, new String[0]);
    }

    public void walkFileTree(Path path, FileVisitor<? super Path> fileVisitor) throws IOException {
        Files.walkFileTree(path, fileVisitor);
    }

    public boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public boolean isRegularFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    public File createFile(File parent, String child) {
        return new File(parent, child);
    }

    public Path getPath(String parent, String child) {
        return FileSystems.getDefault().getPath(parent, child);
    }
}

