/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.eventlog.backends.api;

import de.rcenvironment.core.eventlog.api.EventType;
import de.rcenvironment.core.eventlog.backends.api.EventLogBackend;
import de.rcenvironment.core.eventlog.internal.EventLogEntryImpl;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class EventLogStructuredPlainTextFileBackend
extends EventLogBackend {
    private static final String ATTTRIBUTE_LINE_FIXED_INDENT = "    ";
    private static final int MAX_ATTRIBUTE_ID_LENGTH = 24;
    private static final String ATTRIBUTE_KEY_PADDING_STRING = "                        ";
    private static final String APPLICATION_START_SEPARATOR_LINE = "------------------------------------------------------------------------------";
    private final BufferedWriter writer;

    public EventLogStructuredPlainTextFileBackend(Path filePath) throws IOException {
        this.writer = Files.newBufferedWriter(filePath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        if (ATTRIBUTE_KEY_PADDING_STRING.length() < 24) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void append(EventLogEntryImpl logEntry) throws IOException {
        EventType eventType = logEntry.getEventType();
        if (eventType == EventType.APPLICATION_STARTING) {
            this.writer.append(APPLICATION_START_SEPARATOR_LINE);
            this.writer.newLine();
            this.writer.newLine();
        }
        this.writer.append(logEntry.getEventTypeTitle());
        this.writer.newLine();
        String timestamp = logEntry.getHumanReadableLocalTimestamp();
        this.writer.append(this.generateAttributeLine("Event time", timestamp.replace('T', ' ')));
        this.writer.newLine();
        Map<String, String> attributeData = logEntry.getAttributeData();
        if (eventType == EventType.CUSTOM) {
            attributeData = new TreeMap<String, String>(attributeData);
            for (Map.Entry<String, String> e : attributeData.entrySet()) {
                this.writer.append(this.generateAttributeLine(e.getKey(), e.getValue()));
                this.writer.newLine();
            }
        } else {
            String[] stringArray = eventType.getAttributeKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = attributeData.get(key);
                if (value != null) {
                    Optional<String> optionalTitle = eventType.getAttributeTitle(key);
                    String effectiveTitle = optionalTitle.orElse(key);
                    this.writer.append(this.generateAttributeLine(effectiveTitle, value));
                    this.writer.newLine();
                }
                ++n2;
            }
        }
        this.writer.newLine();
        this.writer.flush();
    }

    private String generateAttributeLine(String title, String value) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(ATTTRIBUTE_LINE_FIXED_INDENT);
        buffer.append(title);
        buffer.append(":  ");
        int paddingLength = Math.max(24 - title.length(), 0);
        buffer.append(ATTRIBUTE_KEY_PADDING_STRING.substring(0, paddingLength));
        String sanitizedValue = value.replace("\n", "\\n").replace("\r", "\\r");
        buffer.append(sanitizedValue);
        return buffer.toString();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

