/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionEventHandler;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequest;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequestResponse;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionResult;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSessionEventHandler;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolExecutionHandle;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractExecutionChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionChannelState;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionProviderEventTransferObject;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.util.List;

public class ToolExecutionChannelInitiatorEndpoint
extends AbstractExecutionChannelEndpoint {
    private volatile ToolExecutionHandle executionHandle;
    private ToolExecutionEventHandler executionEventHandler;
    private AbstractExecutionChannelEndpoint.DirectoryDownloadWrapper directoryDownloadWrapper;

    public ToolExecutionChannelInitiatorEndpoint(ClientSideUplinkSession session, long channelId, ClientSideUplinkSessionEventHandler sessionEventHandler) {
        super(session, channelId);
    }

    public void initiateToolExecution(ToolExecutionRequest toolExecutionRequest, ToolExecutionEventHandler eventHandler) throws IOException {
        this.setExecutionEventHandler(eventHandler);
        this.executionHandle = new ToolExecutionHandle(){

            @Override
            public void requestCancel() {
                try {
                    ToolExecutionChannelInitiatorEndpoint.this.enqueueMessageBlockForSending(ToolExecutionChannelInitiatorEndpoint.this.messageConverter.createToolCancellationRequest(), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
                }
                catch (IOException e) {
                    ToolExecutionChannelInitiatorEndpoint.this.log.error((Object)(String.valueOf(ToolExecutionChannelInitiatorEndpoint.this.channelLogPrefix) + "Failed to deliver a tool cancellation request through an Uplink connection: " + e.toString()));
                }
            }
        };
        this.enqueueMessageBlockForSending(this.messageConverter.encodeToolExecutionRequest(toolExecutionRequest), MessageBlockPriority.BLOCKABLE_CHANNEL_OPERATION, true);
        this.setChannelState(ToolExecutionChannelState.EXPECTING_EXECUTION_REQUEST_RESPONSE);
    }

    @Override
    public void dispose() {
    }

    @Override
    protected boolean processMessageInternal(MessageBlock messageBlock) throws IOException {
        MessageType messageType = messageBlock.getType();
        if (messageType == MessageType.CHANNEL_CLOSE) {
            return false;
        }
        switch (this.getChannelState()) {
            case EXPECTING_EXECUTION_REQUEST_RESPONSE: {
                this.validateActualVersusExpectedMessageType(messageType, MessageType.TOOL_EXECUTION_REQUEST_RESPONSE);
                ToolExecutionRequestResponse response = this.messageConverter.decodeToolExecutionRequestResponse(messageBlock);
                if (!response.isAccepted()) {
                    this.log.debug((Object)(String.valueOf(this.channelLogPrefix) + "Failed to set up remote tool execution, aborting"));
                    this.getExecutionEventHandler().onContextClosing();
                    return false;
                }
                if (VERBOSE_FILE_TRANSFER_LOGGING_ENABLED) {
                    this.log.debug((Object)(String.valueOf(this.channelLogPrefix) + "Successfully set up remote tool execution, preparing to upload the input files"));
                }
                this.setChannelState(ToolExecutionChannelState.EXPECTING_NO_MESSAGES);
                this.getExecutionEventHandler().onInputUploadsStarting();
                ConcurrencyUtils.getAsyncTaskService().execute("Uplink: upload input files for remote tool execution", () -> {
                    try {
                        this.uploadInputFiles();
                    }
                    catch (IOException e) {
                        this.log.warn((Object)(String.valueOf(this.channelLogPrefix) + "Error while uploading input files for remote tool execution: " + e.toString()));
                        return;
                    }
                    this.getExecutionEventHandler().onInputUploadsFinished();
                    this.setChannelState(ToolExecutionChannelState.EXPECTING_EXECUTION_EVENTS);
                    this.getExecutionEventHandler().onExecutionStarting();
                });
                return true;
            }
            case EXPECTING_EXECUTION_EVENTS: {
                if (messageType == MessageType.TOOL_EXECUTION_EVENTS) {
                    List<ToolExecutionProviderEventTransferObject> toolExecutionEvents = this.messageConverter.decodeToolExecutionEvents(messageBlock);
                    for (ToolExecutionProviderEventTransferObject event : toolExecutionEvents) {
                        this.getExecutionEventHandler().processToolExecutionEvent(event.t, event.d);
                    }
                    return true;
                }
                this.validateActualVersusExpectedMessageType(messageType, MessageType.TOOL_EXECUTION_FINISHED);
                ToolExecutionResult toolExecutionResult = this.messageConverter.decodeToolExecutionResult(messageBlock);
                this.getExecutionEventHandler().onExecutionFinished(toolExecutionResult);
                this.ensureNotDefinedYet(this.getDirectoryDownloadWrapper());
                this.setDirectoryDownloadWrapper(new AbstractExecutionChannelEndpoint.DirectoryDownloadWrapper(this, this.getExecutionEventHandler().getOutputDirectoryReceiver()));
                this.getExecutionEventHandler().onOutputDownloadsStarting();
                this.setChannelState(ToolExecutionChannelState.EXPECTING_DIRECTORY_DOWNLOAD);
                return true;
            }
            case EXPECTING_DIRECTORY_DOWNLOAD: {
                this.ensure(this.getDirectoryDownloadWrapper() != null);
                this.getDirectoryDownloadWrapper().processMessageBlock(messageBlock);
                if (this.getDirectoryDownloadWrapper().isFinished()) {
                    this.setChannelState(ToolExecutionChannelState.EXPECTING_NO_MESSAGES);
                    this.getExecutionEventHandler().onOutputDownloadsFinished();
                    this.getExecutionEventHandler().onContextClosing();
                    return false;
                }
                return true;
            }
        }
        throw new ProtocolException(String.valueOf(this.channelLogPrefix) + "Received an unexpected message block (type: " + (Object)((Object)messageType) + ") while in state " + (Object)((Object)this.getChannelState()));
    }

    private void uploadInputFiles() throws IOException {
        new AbstractExecutionChannelEndpoint.DirectoryUploadWrapper(this, this.getExecutionEventHandler().getInputDirectoryProvider()).performDirectoryUpload();
    }

    public ToolExecutionHandle getExecutionHandle() {
        return this.executionHandle;
    }

    private synchronized ToolExecutionEventHandler getExecutionEventHandler() {
        return this.executionEventHandler;
    }

    private synchronized void setExecutionEventHandler(ToolExecutionEventHandler executionEventHandler) {
        this.executionEventHandler = executionEventHandler;
    }

    private synchronized AbstractExecutionChannelEndpoint.DirectoryDownloadWrapper getDirectoryDownloadWrapper() {
        return this.directoryDownloadWrapper;
    }

    private synchronized void setDirectoryDownloadWrapper(AbstractExecutionChannelEndpoint.DirectoryDownloadWrapper directoryDownloadWrapper) {
        this.directoryDownloadWrapper = directoryDownloadWrapper;
    }
}

