/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.gui.communication.views.contributors.CustomPasteHandler;
import de.rcenvironment.core.gui.utils.incubator.PasteListeningText;
import de.rcenvironment.core.utils.common.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractUplinkConnectionDialog
extends Dialog
implements PasteListeningText.PasteListener,
VerifyListener {
    private static final String KEYFILE_AUTH_WITH_PASSPHRASE = "Key file with passphrase protection";
    private static final String KEYFILE_AUTH_WITHOUT_PASSPHRASE = "Key file without passphrase protection";
    private static final String PASSPHRASE_AUTH = "Passphrase";
    private static final int DIALOG_WINDOW_OFFSET_Y = 100;
    private static final int DIALOG_WINDOW_OFFSET_X = 150;
    private static final String COLON = ":";
    private static final String NAME_LABEL = "Name:";
    private static final String HOST_LABEL = "Host:";
    private static final String PORT_LABEL = "Port:";
    private static final String QUALIFIER_LABEL = "Client ID:";
    private static final String USERNAME_LABEL = "Username:";
    private static final String AUTH_TYPE_LABEL = "Authentication type:";
    private static final String KEYFILE_LABEL = "SSH key file:";
    private static final String PASSPHRASE_LABEL = "Passphrase:";
    private static Text portTextField;
    private static PasteListeningText hostTextField;
    protected String connectionName = "";
    protected String host = "";
    protected String port = "";
    protected String qualifier = "";
    protected String username = "";
    protected String passphrase = "";
    protected String keyfileLocation = "";
    protected String hint = "";
    protected String networkContactPointID = "";
    private boolean isGateway = false;
    private boolean storePassphrase = true;
    private boolean useKeyFile = false;
    private boolean connectImmediately = true;
    private boolean autoRetry = true;
    private boolean usePassphrase = true;
    private Button useDefaultNameButton;
    private Button storePasswordButton;
    private Button isGatewayButton;
    private Button immediateConnectButton;
    private Button autoRetryButton;
    private Label nameLabel;
    private boolean isDefaultName = true;

    protected AbstractUplinkConnectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public AbstractUplinkConnectionDialog(Shell parentShell, String connectionName, String host, int port, String qualifier, String username, String keyfileLocation, boolean usePassphrase, boolean storePassphrase, boolean connectImmediately, boolean autoRetry, boolean isGateway) {
        super(parentShell);
        this.connectionName = connectionName;
        this.host = host;
        this.port = Integer.toString(port);
        String hostAndPortString = StringUtils.format((String)"%s:%s", (Object[])new Object[]{host, port});
        this.qualifier = qualifier;
        this.username = username;
        this.connectImmediately = connectImmediately;
        this.autoRetry = autoRetry;
        this.storePassphrase = storePassphrase;
        this.isDefaultName = connectionName.equals(hostAndPortString);
        this.keyfileLocation = keyfileLocation;
        if (keyfileLocation == null) {
            this.keyfileLocation = "";
        }
        this.useKeyFile = !this.keyfileLocation.isEmpty();
        this.usePassphrase = usePassphrase;
        this.isGateway = isGateway;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (shell.getHorizontalBar() != null) {
            shell.getHorizontalBar().dispose();
        }
        shell.setLocation(shell.getParent().getLocation().x + shell.getParent().getSize().x / 2 - 150, shell.getParent().getLocation().y + shell.getParent().getSize().y / 2 - 100);
        shell.setText("Connection");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        GridData containerGridData = new GridData(4, 4, false, false);
        container.setLayoutData((Object)containerGridData);
        container.setLayout((Layout)layout);
        GridData useDefaultCheckboxGridData = new GridData();
        useDefaultCheckboxGridData.horizontalSpan = 1;
        GridData storePassphraseCheckboxGridData = new GridData();
        storePassphraseCheckboxGridData.horizontalSpan = 1;
        GridData isGatewayCheckboxGridData = new GridData();
        isGatewayCheckboxGridData.horizontalSpan = 2;
        GridData connectImmediateCheckboxGridData = new GridData();
        connectImmediateCheckboxGridData.horizontalSpan = 2;
        GridData autoRetryCheckboxGridData = new GridData();
        autoRetryCheckboxGridData.horizontalSpan = 2;
        GridData experimentalNoticeGridData = new GridData();
        experimentalNoticeGridData.horizontalSpan = 2;
        Label experimentalNotice = new Label(container, 0);
        experimentalNotice.setLayoutData((Object)experimentalNoticeGridData);
        experimentalNotice.setText("Please note that Uplink is still an experimental feature!");
        experimentalNotice.setForeground(Display.getDefault().getSystemColor(3));
        Label cpLabelHost = new Label(container, 0);
        cpLabelHost.setText(HOST_LABEL);
        hostTextField = new PasteListeningText(container, 2052);
        hostTextField.setLayoutData((Object)new GridData(256));
        if (!this.host.isEmpty()) {
            hostTextField.setText(this.host);
        }
        hostTextField.addPasteListener((PasteListeningText.PasteListener)this);
        Label cpLabelPort = new Label(container, 0);
        cpLabelPort.setText(PORT_LABEL);
        portTextField = new Text(container, 2052);
        portTextField.setLayoutData((Object)new GridData(256));
        if (!this.port.isEmpty()) {
            portTextField.setText(this.port);
        }
        portTextField.addVerifyListener((VerifyListener)this);
        GridData separatorGridData = new GridData();
        separatorGridData.horizontalAlignment = 4;
        separatorGridData.grabExcessHorizontalSpace = true;
        separatorGridData.horizontalSpan = 2;
        this.nameLabel = new Label(container, 0);
        this.nameLabel.setText(NAME_LABEL);
        final Text nameText = new Text(container, 2052);
        nameText.setLayoutData((Object)new GridData(256));
        nameText.setText(this.connectionName);
        nameText.setEnabled(!this.isDefaultName);
        Label placeholderLabel = new Label(container, 0);
        placeholderLabel.setText("");
        this.useDefaultNameButton = new Button(container, 32);
        this.useDefaultNameButton.setText("Use default name (host:port)");
        this.useDefaultNameButton.setLayoutData((Object)useDefaultCheckboxGridData);
        this.useDefaultNameButton.setSelection(this.isDefaultName);
        this.useDefaultNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                nameText.setEnabled(!AbstractUplinkConnectionDialog.this.useDefaultNameButton.getSelection());
                nameText.setText("");
                if (AbstractUplinkConnectionDialog.this.useDefaultNameButton.getSelection() && !hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                    nameText.setText(String.valueOf(hostTextField.getText()) + AbstractUplinkConnectionDialog.COLON + portTextField.getText());
                }
                AbstractUplinkConnectionDialog.this.updateOkButtonActivation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        Label usernameLabel = new Label(container, 0);
        usernameLabel.setText(USERNAME_LABEL);
        Text usernameText = new Text(container, 2052);
        usernameText.setLayoutData((Object)new GridData(256));
        usernameText.setTextLimit(8);
        usernameText.setText(this.username);
        new Label(container, 0);
        Label characterRestrictionNotice = new Label(container, 0);
        characterRestrictionNotice.setText("Note: The username is limited to eight characters.");
        Label authTypeLabel = new Label(container, 0);
        authTypeLabel.setText(AUTH_TYPE_LABEL);
        Combo authTypeCombo = new Combo(container, 8);
        String[] authTypes = new String[]{PASSPHRASE_AUTH, KEYFILE_AUTH_WITH_PASSPHRASE, KEYFILE_AUTH_WITHOUT_PASSPHRASE};
        authTypeCombo.setItems(authTypes);
        if (this.useKeyFile) {
            if (this.usePassphrase) {
                authTypeCombo.select(1);
            } else {
                authTypeCombo.select(2);
            }
        } else {
            authTypeCombo.select(0);
        }
        Label keyfileLabel = new Label(container, 0);
        keyfileLabel.setText(KEYFILE_LABEL);
        keyfileLabel.setVisible(this.useKeyFile);
        Composite keyfileComposite = new Composite(container, 0);
        GridLayout klayout = new GridLayout(2, false);
        klayout.marginWidth = 0;
        keyfileComposite.setLayout((Layout)klayout);
        keyfileComposite.setVisible(this.useKeyFile);
        keyfileComposite.setLayoutData((Object)new GridData(768));
        Text keyfileText = new Text(keyfileComposite, 2052);
        keyfileText.setLayoutData((Object)new GridData(768));
        keyfileText.setText(this.keyfileLocation);
        this.createFileChooserButton(parent, keyfileComposite, keyfileText);
        Label passphraseLabel = new Label(container, 0);
        passphraseLabel.setText(PASSPHRASE_LABEL);
        passphraseLabel.setVisible(this.usePassphrase);
        Text passphraseText = this.appendAndReturnPassphraseText(container);
        new Label(container, 0);
        this.appendAndReturnStorePasswordButton(container, storePassphraseCheckboxGridData);
        this.appendAndReturnQualifierLabel(container);
        Text qualifierText = this.appendAndReturnQualifierText(container);
        new Label(container, 0);
        Label qualifierNote = new Label(container, 0);
        qualifierNote.setText("Note: A Client ID must be configured if more than\none RCE instance uses the same user credentials for\nuplink connections. Can otherwise be left blank.\nA Client ID is currently limited to eight characters.");
        this.createButtonsAndHint(container, isGatewayCheckboxGridData, connectImmediateCheckboxGridData, autoRetryCheckboxGridData, separatorGridData);
        this.defineListenerForAuthenticationType(authTypeCombo, keyfileLabel, keyfileComposite, passphraseLabel, passphraseText);
        this.initVariablesAndCreateListeners(nameText, usernameText, passphraseText, keyfileText, qualifierText);
        return container;
    }

    private Text appendAndReturnPassphraseText(Composite container) {
        Text passphraseText = new Text(container, 2052);
        passphraseText.setLayoutData((Object)new GridData(256));
        passphraseText.setText(this.passphrase);
        passphraseText.setEchoChar('*');
        passphraseText.setVisible(this.usePassphrase);
        return passphraseText;
    }

    private void appendAndReturnStorePasswordButton(Composite container, GridData storePassphraseCheckboxGridData) {
        this.storePasswordButton = new Button(container, 32);
        this.storePasswordButton.setSelection(true);
        this.storePasswordButton.setText("Store passphrase");
        this.storePasswordButton.setLayoutData((Object)storePassphraseCheckboxGridData);
        this.storePasswordButton.setSelection(this.storePassphrase);
        this.storePasswordButton.setVisible(this.usePassphrase);
    }

    private void appendAndReturnQualifierLabel(Composite container) {
        Label qualifierLabel = new Label(container, 0);
        qualifierLabel.setText(QUALIFIER_LABEL);
    }

    private Text appendAndReturnQualifierText(Composite container) {
        Text qualifierText = new Text(container, 2052);
        qualifierText.setLayoutData((Object)new GridData(256));
        qualifierText.setTextLimit(8);
        qualifierText.setText(this.qualifier);
        return qualifierText;
    }

    private void createButtonsAndHint(Composite container, GridData isGatewayCheckboxGridData, GridData connectImmediateCheckboxGridData, GridData autoRetryCheckboxGridData, GridData separatorGridData) {
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)separatorGridData);
        this.isGatewayButton = new Button(container, 32);
        this.isGatewayButton.setSelection(this.isGateway);
        this.isGatewayButton.setText("Is Gateway");
        this.isGatewayButton.setLayoutData((Object)isGatewayCheckboxGridData);
        this.immediateConnectButton = new Button(container, 32);
        this.immediateConnectButton.setSelection(this.connectImmediately);
        this.immediateConnectButton.setText("Connect immediately");
        this.immediateConnectButton.setLayoutData((Object)connectImmediateCheckboxGridData);
        this.autoRetryButton = new Button(container, 32);
        this.autoRetryButton.setSelection(this.autoRetry);
        this.autoRetryButton.setText("Try reconnect after error (requires stored passphrase)");
        this.autoRetryButton.setLayoutData((Object)autoRetryCheckboxGridData);
        Label persistHint = new Label(container, 0);
        GridData hintGridData = new GridData();
        hintGridData.horizontalSpan = 2;
        persistHint.setText(this.hint);
        persistHint.setLayoutData((Object)hintGridData);
    }

    public void paste(String text) {
        CustomPasteHandler.paste(text, (Text)hostTextField, portTextField);
    }

    public void verifyText(VerifyEvent e) {
        String currentText = ((Text)e.widget).getText();
        String portID = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
        e.doit = CustomPasteHandler.isValidPort(portID);
    }

    private void defineListenerForAuthenticationType(final Combo authTypeCombo, final Label keyfileLabel, final Composite keyfileComposite, final Label passphraseLabel, final Text passphraseText) {
        authTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AbstractUplinkConnectionDialog.this.useKeyFile = authTypeCombo.getText().equals(AbstractUplinkConnectionDialog.KEYFILE_AUTH_WITH_PASSPHRASE) || authTypeCombo.getText().equals(AbstractUplinkConnectionDialog.KEYFILE_AUTH_WITHOUT_PASSPHRASE);
                AbstractUplinkConnectionDialog.this.usePassphrase = !authTypeCombo.getText().equals(AbstractUplinkConnectionDialog.KEYFILE_AUTH_WITHOUT_PASSPHRASE);
                keyfileLabel.setVisible(AbstractUplinkConnectionDialog.this.useKeyFile);
                keyfileComposite.setVisible(AbstractUplinkConnectionDialog.this.useKeyFile);
                passphraseLabel.setVisible(AbstractUplinkConnectionDialog.this.usePassphrase);
                passphraseText.setVisible(AbstractUplinkConnectionDialog.this.usePassphrase);
                AbstractUplinkConnectionDialog.this.storePasswordButton.setVisible(AbstractUplinkConnectionDialog.this.usePassphrase);
                AbstractUplinkConnectionDialog.this.autoRetryButton.setEnabled(!AbstractUplinkConnectionDialog.this.usePassphrase || AbstractUplinkConnectionDialog.this.storePassphrase);
                if (!AbstractUplinkConnectionDialog.this.storePassphrase) {
                    AbstractUplinkConnectionDialog.this.autoRetryButton.setSelection(false);
                    AbstractUplinkConnectionDialog.this.autoRetry = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void createFileChooserButton(final Composite parent, Composite container, final Text keyfileText) {
        Button keyfileButton = new Button(container, 0);
        keyfileButton.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        keyfileButton.setText("...");
        keyfileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dialog = new FileDialog(parent.getShell());
                dialog.setText("Choose private key file");
                String result = dialog.open();
                if (result != null) {
                    keyfileText.setText(result);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void initVariablesAndCreateListeners(final Text nameTextInit, Text usernameText, Text passphraseText, Text keyfileText, Text qualifierText) {
        hostTextField.addModifyListener(e -> {
            this.host = hostTextField.getText();
            if (this.useDefaultNameButton.getSelection()) {
                if (!hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                    nameTextInit.setText(String.valueOf(hostTextField.getText()) + COLON + portTextField.getText());
                } else {
                    nameTextInit.setText("");
                }
            }
            this.updateOkButtonActivation();
        });
        portTextField.addModifyListener(e -> {
            this.port = portTextField.getText();
            if (this.useDefaultNameButton.getSelection()) {
                if (!hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                    nameTextInit.setText(String.valueOf(hostTextField.getText()) + COLON + portTextField.getText());
                } else {
                    nameTextInit.setText("");
                }
            }
            this.updateOkButtonActivation();
        });
        this.connectionName = nameTextInit.getText();
        nameTextInit.addModifyListener(arg0 -> {
            this.connectionName = nameTextInit.getText();
        });
        this.username = usernameText.getText();
        usernameText.addModifyListener(arg0 -> {
            this.username = usernameText.getText();
            this.updateOkButtonActivation();
        });
        this.passphrase = passphraseText.getText();
        passphraseText.addModifyListener(arg0 -> {
            this.passphrase = passphraseText.getText();
        });
        this.keyfileLocation = keyfileText.getText();
        keyfileText.addModifyListener(arg0 -> {
            this.keyfileLocation = keyfileText.getText();
        });
        this.qualifier = qualifierText.getText();
        qualifierText.addModifyListener(arg0 -> {
            this.qualifier = qualifierText.getText();
        });
        this.isGateway = this.isGatewayButton.getSelection();
        this.isGatewayButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractUplinkConnectionDialog.this.isGateway = AbstractUplinkConnectionDialog.this.isGatewayButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.connectImmediately = this.immediateConnectButton.getSelection();
        this.immediateConnectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractUplinkConnectionDialog.this.connectImmediately = AbstractUplinkConnectionDialog.this.immediateConnectButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.autoRetry = this.autoRetryButton.getSelection();
        this.autoRetryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractUplinkConnectionDialog.this.autoRetry = AbstractUplinkConnectionDialog.this.autoRetryButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.storePassphrase = this.storePasswordButton.getSelection();
        this.storePasswordButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractUplinkConnectionDialog.this.storePassphrase = AbstractUplinkConnectionDialog.this.storePasswordButton.getSelection();
                AbstractUplinkConnectionDialog.this.autoRetryButton.setEnabled(AbstractUplinkConnectionDialog.this.storePassphrase);
                if (!AbstractUplinkConnectionDialog.this.storePassphrase) {
                    AbstractUplinkConnectionDialog.this.autoRetryButton.setSelection(false);
                    AbstractUplinkConnectionDialog.this.autoRetry = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.useDefaultNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractUplinkConnectionDialog.this.useDefaultNameButton.getSelection()) {
                    nameTextInit.setEnabled(false);
                    if (!hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                        nameTextInit.setText(String.valueOf(hostTextField.getText()) + AbstractUplinkConnectionDialog.COLON + portTextField.getText());
                    } else {
                        nameTextInit.setText("");
                    }
                } else {
                    nameTextInit.setEnabled(true);
                    nameTextInit.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateOkButtonActivation();
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        parent.getShell().pack();
        return buttonBar;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(67936);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return Integer.parseInt(this.port);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassphrase() {
        if (this.usePassphrase) {
            return this.passphrase;
        }
        return null;
    }

    public String getKeyfileLocation() {
        if (this.useKeyFile) {
            return this.keyfileLocation;
        }
        return null;
    }

    public boolean isGateway() {
        return this.isGateway;
    }

    public boolean getConnectImmediately() {
        return this.connectImmediately;
    }

    public boolean getAutoRetry() {
        return this.autoRetry;
    }

    protected void activateDefaultName() {
        this.isDefaultName = true;
    }

    protected void deactivateDefaultName() {
        this.isDefaultName = false;
    }

    public boolean shouldStorePassPhrase() {
        if (this.usePassphrase) {
            return this.storePassphrase;
        }
        return false;
    }

    public boolean getUsePassphrase() {
        return this.usePassphrase;
    }

    protected void updateOkButtonActivation() {
        this.getButton(0).setEnabled(!this.host.isEmpty() && !this.port.isEmpty() && !this.username.isEmpty());
    }
}

