/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.login.internal;

import de.rcenvironment.core.authentication.AuthenticationService;
import de.rcenvironment.core.authentication.User;
import de.rcenvironment.core.gui.login.internal.LoginDialogController;
import de.rcenvironment.core.gui.login.internal.Messages;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.login.LoginConfiguration;
import de.rcenvironment.core.login.LoginInput;
import java.text.DateFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoginDialog
extends Dialog {
    private LoginDialogController loginDialogController;
    private String password;
    private Text certificatePathText;
    private Button certificatePathButton;
    private Text keyPathText;
    private Button keyPathButton;
    private Text passwordTextCertificate;
    private Text passwordTextLDAP;
    private Text usernameLdapText;
    private Image iconImage;
    private TabFolder tabFolder;
    private String currentlySelectedTabTitle;
    private User user = null;
    private String usernameLdap;
    private boolean relogin;
    private Button anonymous;
    private boolean anonymousLogin;

    public LoginDialog(AuthenticationService authenticationService, LoginConfiguration settings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.loginDialogController = new LoginDialogController(this, authenticationService, settings);
        this.relogin = false;
    }

    public LoginDialog(User user, AuthenticationService authenticationService, LoginConfiguration settings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.user = user;
        this.loginDialogController = new LoginDialogController(this, authenticationService, settings);
        this.relogin = true;
    }

    public LoginDialog(User user, String username, AuthenticationService authenticationService, LoginConfiguration settings) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.loginDialogController = new LoginDialogController(this, authenticationService, settings);
        this.usernameLdap = username;
        this.user = user;
        this.relogin = true;
    }

    public void setUsernameLDAP(String usernameLDAP) {
        this.usernameLdap = usernameLDAP;
    }

    private void setCurrentlySelectedTab() {
        int index = 0;
        while (index < this.tabFolder.getItemCount()) {
            if (this.currentlySelectedTabTitle.equals(this.tabFolder.getItem(index).getText())) break;
            ++index;
        }
        this.tabFolder.setSelection(this.tabFolder.getItem(index));
    }

    public LoginInput getLoginInput() {
        if (this.currentlySelectedTabTitle.equals(Messages.ldapTabName)) {
            if (this.anonymousLogin) {
                return new LoginInput(this.anonymousLogin);
            }
            return new LoginInput(this.usernameLdap, this.password);
        }
        throw new AssertionError();
    }

    public boolean getAnonymousLogin() {
        return this.anonymousLogin;
    }

    public String getUsernameLDAP() {
        return this.usernameLdap;
    }

    public User getUser() {
        return this.user;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.iconImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.RCE_LOGO_16);
        newShell.setImage(this.iconImage);
        if (!this.relogin) {
            newShell.setText(Messages.loginDialog);
        } else {
            newShell.setText(Messages.reLoginDialog);
        }
        newShell.setActive();
    }

    protected Control createDialogArea(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        TabItem idLoginTab = new TabItem(this.tabFolder, 0);
        idLoginTab.setText(Messages.ldapTabName);
        idLoginTab.setControl((Control)this.createLDAPComposite((Composite)this.tabFolder));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog.this.currentlySelectedTabTitle = LoginDialog.this.tabFolder.getItem(LoginDialog.this.tabFolder.getSelectionIndex()).getText();
                LoginDialog.this.loginDialogController.setTabTitle(LoginDialog.this.currentlySelectedTabTitle);
            }
        });
        this.currentlySelectedTabTitle = this.loginDialogController.getTabTitle();
        this.setCurrentlySelectedTab();
        return this.tabFolder;
    }

    private Composite createLDAPComposite(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(4, 2, true, false);
        composite.setLayoutData((Object)data);
        this.loginDialogController.setUpDialogForLDAP(this.relogin);
        this.createUsernameLdapArea(composite);
        if (this.user != null && this.user.getType() == User.Type.ldap) {
            Label expireLabel = new Label(composite, 0);
            expireLabel.setText(Messages.validTill);
            Text expireText = new Text(composite, 2056);
            expireText.setLayoutData((Object)new GridData(4, 2, true, false));
            expireText.setText(DateFormat.getDateTimeInstance(0, 3).format(this.user.getTimeUntilValid()));
            new Label(composite, 0);
        }
        this.passwordTextLDAP = this.createPasswordArea(composite);
        this.anonymous = new Button(composite, 32);
        this.anonymous.setText(Messages.anonymousLogin);
        this.anonymous.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LoginDialog.this.usernameLdapText.setEnabled(!LoginDialog.this.anonymous.getSelection());
                LoginDialog.this.passwordTextLDAP.setEnabled(!LoginDialog.this.anonymous.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        return composite;
    }

    protected void okPressed() {
        if (this.currentlySelectedTabTitle.equals(Messages.ldapTabName)) {
            this.anonymousLogin = this.anonymous.getSelection();
            if (!this.anonymous.getSelection()) {
                this.usernameLdap = this.usernameLdapText.getText();
                this.password = this.passwordTextLDAP.getText();
                if (this.usernameLdap.isEmpty() || this.password.isEmpty()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.reLoginDialog, (String)Messages.ldapUsernameAndPasswordRequired);
                    return;
                }
            }
        } else {
            throw new AssertionError();
        }
        this.loginDialogController.saveSettings();
        super.okPressed();
        this.relogin = true;
    }

    private void createProxyCertificateArea(Composite composite) {
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.cert);
        Text nameText = new Text(composite, 2122);
        nameText.setLayoutData((Object)new GridData(4, 2, false, false));
        nameText.setText(this.getCertificateText());
        new Label(composite, 0);
        Label expireLabel = new Label(composite, 0);
        expireLabel.setText(Messages.validTill);
        Text expireText = new Text(composite, 2056);
        expireText.setLayoutData((Object)new GridData(4, 2, false, false));
        expireText.setText(DateFormat.getDateTimeInstance(0, 3).format(this.user.getTimeUntilValid()));
        new Label(composite, 0);
    }

    private void createCertificateArea(Composite composite) {
        Label certificateLabel = new Label(composite, 0);
        certificateLabel.setText(Messages.cert);
        this.certificatePathText = new Text(composite, 2056);
        this.certificatePathText.setLayoutData((Object)new GridData(4, 2, false, false));
        this.certificatePathText.setToolTipText(Messages.chooseValidCert);
        this.certificatePathButton = new Button(composite, 8);
        this.certificatePathButton.setText("...");
        this.certificatePathButton.setToolTipText(Messages.chooseNewCert);
    }

    private void createPrivateKeyArea(Composite composite) {
        Label keyLabel = new Label(composite, 0);
        keyLabel.setText(Messages.privateKey);
        this.keyPathText = new Text(composite, 2048);
        this.keyPathText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.keyPathText.setEditable(false);
        this.keyPathText.setToolTipText(Messages.searchMatchingKey);
        this.keyPathButton = new Button(composite, 8);
        this.keyPathButton.setText("...");
        this.keyPathButton.setToolTipText(Messages.chooseNewKey);
    }

    private void createUsernameLdapArea(Composite composite) {
        Label usernameLdapLabel = new Label(composite, 0);
        usernameLdapLabel.setText(Messages.username);
        this.usernameLdapText = new Text(composite, 2048);
        this.usernameLdapText.setText(this.usernameLdap);
        this.usernameLdapText.setLayoutData((Object)new GridData(4, 2, true, false));
        new Label(composite, 0);
    }

    private Text createPasswordArea(Composite composite) {
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(Messages.password);
        Text textField = new Text(composite, 0x400800);
        textField.setText("");
        textField.setToolTipText(Messages.validPassword);
        textField.setData((Object)"LoginDialog.passwordText");
        textField.setLayoutData((Object)new GridData(4, 2, true, false));
        textField.setFocus();
        new Label(composite, 0);
        return textField;
    }

    private String getCertificateText() {
        String pc = this.user.getUserId();
        int certificateHalfLength = pc.length() / 2;
        String secondHalf = pc.substring(certificateHalfLength);
        int commaPosition = secondHalf.indexOf(",");
        int partingPositon = 0;
        if (commaPosition > 0) {
            partingPositon = commaPosition;
        }
        partingPositon = partingPositon + certificateHalfLength + 1;
        return String.valueOf(pc.substring(0, partingPositon)) + "\n" + pc.substring(partingPositon);
    }
}

