/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.configuration.internal;

import de.rcenvironment.core.gui.cluster.configuration.internal.Messages;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobInformationModel;
import de.rcenvironment.core.utils.cluster.ClusterQueuingSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateClusterConnectionConfigurationDialog
extends TitleAreaDialog {
    protected static final int CREATE = 2;
    protected Combo queuingSystemCombo;
    protected Text qstatPathText;
    protected Text showqPathText;
    protected Text qdelPathText;
    protected Text hostText;
    protected Text portText;
    protected Text usernameText;
    protected Text passwordText;
    protected Button savePasswordCheckbox;
    protected Text configurationNameText;
    protected Button defaultConfigurationNameCheckbox;
    protected Button createButton;
    protected List<String> existingConfigurationNames;
    private ClusterQueuingSystem queuingSystem;
    private Map<String, String> pathsToClusterQueuingSystemCommands = new HashMap<String, String>();
    private String host;
    private int port;
    private String username;
    private String password;
    private String configurationName;
    private boolean savePassword;
    private Label showqPathLabel;

    public CreateClusterConnectionConfigurationDialog(Shell parentShell, List<String> existingConfigurationNames) {
        super(parentShell);
        this.existingConfigurationNames = existingConfigurationNames;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.newConfigurationDialogTitle);
        this.setMessage(Messages.newConfigurationDialogMessage);
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(control, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        container.setLayoutData((Object)gridData);
        Label queuingSystemLabel = new Label(container, 0);
        queuingSystemLabel.setText(Messages.queueingSystemLabel);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.queuingSystemCombo = new Combo(container, 12);
        this.queuingSystemCombo.setLayoutData((Object)gridData);
        ClusterQueuingSystem[] clusterQueuingSystemArray = ClusterQueuingSystem.values();
        int n = clusterQueuingSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClusterQueuingSystem system = clusterQueuingSystemArray[n2];
            this.queuingSystemCombo.add(system.name());
            ++n2;
        }
        this.queuingSystemCombo.select(0);
        this.createQueuingSystemCommandPathsLabelsAndTexts(container);
        Label hostLabel = new Label(container, 0);
        hostLabel.setText(Messages.hostLabel);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.hostText = new Text(container, 2048);
        this.hostText.setLayoutData((Object)gridData);
        Label portLabel = new Label(container, 0);
        portLabel.setText(Messages.portLabel);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.portText = new Text(container, 2048);
        this.portText.setLayoutData((Object)gridData);
        this.portText.setText(String.valueOf(22));
        Label usernameLabel = new Label(container, 0);
        usernameLabel.setText(Messages.usernameLabel);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.usernameText = new Text(container, 2048);
        this.usernameText.setLayoutData((Object)gridData);
        Label passwordLabel = new Label(container, 0);
        passwordLabel.setText(Messages.passwordLabel);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.passwordText = new Text(container, 0x400800);
        this.passwordText.setLayoutData((Object)gridData);
        this.passwordText.setEnabled(false);
        new Label(container, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.savePasswordCheckbox = new Button(container, 32);
        this.savePasswordCheckbox.setText(Messages.savePasswordCheckboxLabel);
        this.savePasswordCheckbox.setLayoutData((Object)gridData);
        Label configurationNameLabel = new Label(container, 0);
        configurationNameLabel.setText(Messages.configurationNameLabel);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.configurationNameText = new Text(container, 2048);
        this.configurationNameText.setLayoutData((Object)gridData);
        this.configurationNameText.setEnabled(false);
        new Label(container, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.defaultConfigurationNameCheckbox = new Button(container, 32);
        this.defaultConfigurationNameCheckbox.setText(Messages.useDefaultNameCheckboxLabel);
        this.defaultConfigurationNameCheckbox.setLayoutData((Object)gridData);
        this.defaultConfigurationNameCheckbox.setSelection(true);
        this.setListener();
        return container;
    }

    private void setShowqElementsEnabled() {
        this.showqPathText.setEnabled(this.queuingSystemCombo.getSelectionIndex() == 1);
        this.showqPathLabel.setEnabled(this.queuingSystemCombo.getSelectionIndex() == 1);
    }

    private void setListener() {
        this.queuingSystemCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CreateClusterConnectionConfigurationDialog.this.setShowqElementsEnabled();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CreateClusterConnectionConfigurationDialog.this.validateInput();
            }
        });
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CreateClusterConnectionConfigurationDialog.this.validateInput();
            }
        });
        this.usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CreateClusterConnectionConfigurationDialog.this.validateInput();
            }
        });
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CreateClusterConnectionConfigurationDialog.this.validateInput();
            }
        });
        this.savePasswordCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CreateClusterConnectionConfigurationDialog.this.passwordText.setEnabled(CreateClusterConnectionConfigurationDialog.this.savePasswordCheckbox.getSelection());
                CreateClusterConnectionConfigurationDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.configurationNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CreateClusterConnectionConfigurationDialog.this.validateInput();
            }
        });
        this.defaultConfigurationNameCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CreateClusterConnectionConfigurationDialog.this.configurationNameText.setEnabled(!CreateClusterConnectionConfigurationDialog.this.defaultConfigurationNameCheckbox.getSelection());
                CreateClusterConnectionConfigurationDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    private void createQueuingSystemCommandPathsLabelsAndTexts(Composite container) {
        Label qstatPathLabel = new Label(container, 0);
        qstatPathLabel.setText("Path 'qstat' (optional)");
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.qstatPathText = new Text(container, 2048);
        this.qstatPathText.setLayoutData((Object)gridData);
        Label qdelPathLabel = new Label(container, 0);
        qdelPathLabel.setText("Path 'qdel' (optional)");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.qdelPathText = new Text(container, 2048);
        this.qdelPathText.setLayoutData((Object)gridData);
        this.showqPathLabel = new Label(container, 0);
        this.showqPathLabel.setText("Path 'showq' (optional)");
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.showqPathText = new Text(container, 2048);
        this.showqPathText.setLayoutData((Object)gridData);
        this.setShowqElementsEnabled();
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonBar.setLayout((Layout)layout);
        GridData data = new GridData(4, 1024, true, false);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        buttonBar.setLayoutData((Object)data);
        Control buttonControl = super.createButtonBar(buttonBar);
        buttonControl.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton = this.createButton(parent, 2, Messages.createButtonTitle, true);
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateClusterConnectionConfigurationDialog.this.validateInput()) {
                    CreateClusterConnectionConfigurationDialog.this.saveInput();
                    CreateClusterConnectionConfigurationDialog.this.setReturnCode(2);
                    CreateClusterConnectionConfigurationDialog.this.close();
                }
            }
        });
        Button cancelButton = this.createButton(parent, 1, Messages.cancel, false);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateClusterConnectionConfigurationDialog.this.setReturnCode(1);
                CreateClusterConnectionConfigurationDialog.this.close();
            }
        });
        this.createButton.setEnabled(this.validateInput());
    }

    private boolean validateInput() {
        boolean valid = true;
        if (this.hostText.getText().length() == 0) {
            this.setErrorMessage(Messages.provideHostLabel);
            valid = false;
        }
        if (valid && this.portText.getText().length() == 0) {
            this.setErrorMessage(Messages.providePortLabel);
            valid = false;
        }
        if (valid) {
            try {
                Integer.valueOf(this.portText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.providePortNumberLabel);
                valid = false;
            }
        }
        if (valid && this.usernameText.getText().length() == 0) {
            this.setErrorMessage(Messages.provideUsernameLabel);
            valid = false;
        }
        if (valid && this.savePasswordCheckbox.getSelection() && this.passwordText.getText().length() == 0) {
            this.setErrorMessage(Messages.providePasswordLabel);
            valid = false;
        }
        if (valid) {
            valid = this.isConfigurationNameValid(null);
        }
        if (valid) {
            this.setErrorMessage(null);
        }
        if (this.createButton != null) {
            this.createButton.setEnabled(valid);
        }
        return valid;
    }

    protected boolean isConfigurationNameValid(String currentConfigurationName) {
        boolean valid = true;
        if (!this.defaultConfigurationNameCheckbox.getSelection()) {
            if (this.configurationNameText.getText().length() == 0) {
                this.setErrorMessage(Messages.configurationNameLabel);
                valid = false;
            }
        } else if (this.existingConfigurationNames.contains(String.valueOf(this.usernameText.getText()) + "@" + this.hostText.getText()) && (currentConfigurationName == null || !this.configurationNameText.getText().equals(currentConfigurationName))) {
            this.setErrorMessage(Messages.provideAnotherConfigurationNameLabel);
            valid = false;
        }
        if (this.existingConfigurationNames.contains(this.configurationNameText.getText()) && (currentConfigurationName == null || !this.configurationNameText.getText().equals(currentConfigurationName)) || ClusterJobInformationModel.NOT_CONNECTED.equals(this.configurationNameText.getText())) {
            this.setErrorMessage(Messages.provideAnotherConfigurationNameLabel);
            valid = false;
        }
        return valid;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.queuingSystem = ClusterQueuingSystem.valueOf((String)this.queuingSystemCombo.getItem(this.queuingSystemCombo.getSelectionIndex()));
        this.saveQueuingSystemCommandPath("qstat", this.qstatPathText);
        this.saveQueuingSystemCommandPath("qdel", this.qdelPathText);
        this.saveQueuingSystemCommandPath("showq", this.showqPathText);
        this.host = this.hostText.getText();
        this.port = Integer.valueOf(this.portText.getText());
        this.username = this.usernameText.getText();
        if (this.savePasswordCheckbox.getSelection()) {
            this.password = this.passwordText.getText();
        }
        this.configurationName = this.defaultConfigurationNameCheckbox.getSelection() ? String.valueOf(this.username) + "@" + this.host : this.configurationNameText.getText();
    }

    private void saveQueuingSystemCommandPath(String command, Text commandPathText) {
        String commandPath = commandPathText.getText();
        if (!commandPath.isEmpty()) {
            if (!commandPath.endsWith("/")) {
                commandPath = String.valueOf(commandPath) + "/";
            }
            this.pathsToClusterQueuingSystemCommands.put(command, commandPath);
        }
    }

    public ClusterQueuingSystem getClusterQueuingSystem() {
        return this.queuingSystem;
    }

    public Map<String, String> getPathsToClusterQueuingSystemCommands() {
        return Collections.unmodifiableMap(this.pathsToClusterQueuingSystemCommands);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public boolean savePassword() {
        return this.savePassword;
    }
}

