/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.profile.CommonProfile;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileUtils;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.InstanceValidator;
import de.rcenvironment.core.start.validators.internal.Messages;
import de.rcenvironment.core.start.validators.internal.ProfileDirectoriesAccessibleValidator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ProfileDirectoryVersionValidator
implements InstanceValidator {
    private static final String VALIDATOR_DISPLAY_NAME = "Profile directory version validation";
    private static ConfigurationService configService;
    private final Log log = LogFactory.getLog(this.getClass());

    public InstanceValidationResult validate() {
        Profile userProfile;
        CommonProfile commonProfile;
        try {
            File commonProfileDirectory = ProfileUtils.getProfilesParentDirectory().toPath().resolve("common").toFile();
            commonProfile = new CommonProfile.Builder(commonProfileDirectory).create(false).migrate(false).buildCommonProfile();
        }
        catch (ProfileException profileException) {
            String errorMessage = String.format(Messages.profileNotAccessibleError, configService.getProfileDirectory());
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)VALIDATOR_DISPLAY_NAME, (String)errorMessage);
        }
        InstanceValidationResult commonProfileResult = this.validateProfile(commonProfile);
        if (!InstanceValidationResult.InstanceValidationResultType.PASSED.equals((Object)commonProfileResult.getType())) {
            return commonProfileResult;
        }
        try {
            userProfile = new CommonProfile.Builder(configService.getProfileDirectory()).create(false).migrate(false).buildUserProfile();
        }
        catch (ProfileException profileException) {
            String errorMessage = String.format(Messages.profileNotAccessibleError, configService.getProfileDirectory());
            return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)VALIDATOR_DISPLAY_NAME, (String)errorMessage);
        }
        return this.validateProfile((CommonProfile)userProfile);
    }

    private InstanceValidationResult validateProfile(CommonProfile profile) {
        int profileVersion;
        boolean profileHasUpgradeableVersion;
        boolean profileHasCurrentVersion;
        try {
            profileHasCurrentVersion = profile.hasCurrentVersion();
        }
        catch (ProfileException e) {
            return this.onProfileException(profile, e);
        }
        if (profileHasCurrentVersion) {
            return InstanceValidationResultFactory.createResultForPassed((String)Messages.profileVersionValidationSuccess);
        }
        try {
            profileHasUpgradeableVersion = profile.hasUpgradeableVersion();
        }
        catch (ProfileException e) {
            return this.onProfileException(profile, e);
        }
        String profileID = profile.getName();
        try {
            profileVersion = profile.getVersion();
        }
        catch (ProfileException e) {
            return this.onProfileException(profile, e);
        }
        if (profileHasUpgradeableVersion) {
            return this.buildUpgradeAfterConfirmationResult(profile, profileID, profileVersion);
        }
        return this.buildFailureResult(profileID, profileVersion);
    }

    private InstanceValidationResult buildUpgradeAfterConfirmationResult(CommonProfile profile, String profileID, int profileVersion) {
        String profileDirectoryPath = profile.getProfileDirectory().getAbsolutePath();
        String queryMessage = String.format(Messages.profileUpgradeQuery, profileID, profileDirectoryPath);
        String logMessage = String.format(Messages.profileUpgradeLogMessage, profileID, profileDirectoryPath, profileVersion);
        String userHint = String.format(Messages.profileUpgradeNoQueryUserHint, profileID, profileDirectoryPath, profileVersion);
        InstanceValidationResult.Callback performUpgrade = () -> {
            try {
                profile.upgradeToCurrentVersion();
            }
            catch (IOException e) {
                String errorMessage = String.format(Messages.profileUpgradeTriedAndFailedError, profileID, profileDirectoryPath);
                throw new InstanceValidationResult.CallbackException(errorMessage, (Throwable)e);
            }
        };
        return InstanceValidationResultFactory.createResultForFailureWhichRequiresUserConfirmation((String)VALIDATOR_DISPLAY_NAME, (String)logMessage, (String)queryMessage, (String)userHint, (InstanceValidationResult.Callback)performUpgrade);
    }

    private InstanceValidationResult buildFailureResult(String profileID, int profileVersion) {
        String errorMessage = String.format(Messages.profileUpgradeNotPossibleError, profileID, profileVersion);
        return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)VALIDATOR_DISPLAY_NAME, (String)errorMessage);
    }

    private InstanceValidationResult onProfileException(CommonProfile profile, ProfileException exception) {
        String errorMessage = String.format(Messages.profileVersionNotDeterminedError, profile.getName());
        this.log.error((Object)errorMessage, (Throwable)exception);
        return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)VALIDATOR_DISPLAY_NAME, (String)errorMessage, (String)errorMessage);
    }

    @Reference
    protected void bindConfigurationService(ConfigurationService configIn) {
        configService = configIn;
    }

    public List<Class<? extends InstanceValidator>> getNecessaryPredecessors() {
        ArrayList<Class<? extends InstanceValidator>> predecessors = new ArrayList<Class<? extends InstanceValidator>>();
        predecessors.add(ProfileDirectoriesAccessibleValidator.class);
        return predecessors;
    }
}

