/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.endpoint.api;

import de.rcenvironment.core.component.model.endpoint.api.EndpointChange;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDescription;
import de.rcenvironment.core.component.model.endpoint.api.InitialDynamicEndpointDefinition;
import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class EndpointDescriptionsManager
extends PropertiesChangeSupport
implements Serializable {
    public static final String PROPERTY_ENDPOINT = "de.rcenvironment.rce.component.endpoint.ComponentDescriptionsEndpoint";
    private static final String MESSAGE_DYNAMIC_ENDPOINT_DESCRIPTION_DOESNT_EXIST = "Dynamic endpoint description with name '%s' doesn't exist";
    private static final String NO_DYNAMIC_ENDPOINT_DEFINITION_WITH_ID_S_DECLARED = "No dynamic endpoint definition with id '%s' declared";
    private static final String MESSAGE_DESIRED_ENDPOINT_NAME_ALREADY_EXISTS = "Desired endpoint name already exists: ";
    private static final long serialVersionUID = -5776007445203691291L;
    private final EndpointType endpointType;
    private final EndpointDefinitionsProvider endpointDefinitionsProvider;
    private final Map<String, EndpointDescription> staticEndpointDescriptions;
    private Map<String, EndpointDescription> dynamicEndpointDescriptions = new HashMap<String, EndpointDescription>();
    private final Map<String, EndpointGroupDescription> staticEndpointGroupDescriptions;
    private Map<String, EndpointGroupDescription> dynamicEndpointGroupDescriptions = new HashMap<String, EndpointGroupDescription>();

    public EndpointDescriptionsManager(EndpointDefinitionsProvider endpointDefinitionsProvider, EndpointType endpointType) {
        this.endpointType = endpointType;
        this.endpointDefinitionsProvider = endpointDefinitionsProvider;
        this.staticEndpointDescriptions = this.createStaticEndpointDescriptions(endpointDefinitionsProvider);
        this.staticEndpointGroupDescriptions = this.createStaticEndpointGroupDescriptions(endpointDefinitionsProvider);
    }

    private Map<String, EndpointDescription> createStaticEndpointDescriptions(EndpointDefinitionsProvider provider) {
        HashMap<String, EndpointDescription> descs = new HashMap<String, EndpointDescription>();
        for (EndpointDefinition definition : provider.getStaticEndpointDefinitions()) {
            descs.put(definition.getName(), new EndpointDescription(definition, this.endpointType));
        }
        return descs;
    }

    private Map<String, EndpointGroupDescription> createStaticEndpointGroupDescriptions(EndpointDefinitionsProvider provider) {
        HashMap<String, EndpointGroupDescription> descs = new HashMap<String, EndpointGroupDescription>();
        for (EndpointGroupDefinition definition : provider.getStaticEndpointGroupDefinitions()) {
            descs.put(definition.getName(), new EndpointGroupDescription(definition));
        }
        return descs;
    }

    public void addDynamicEndpointGroupDescription(String endpointGroupId, String name) {
        this.addDynamicEndpointGroupDescription(endpointGroupId, name, true);
    }

    public EndpointGroupDescription addDynamicEndpointGroupDescription(String endpointGroupId, String name, boolean checkIfDeclared) {
        if (!(!checkIfDeclared || this.isDynamicEndpointGroupDefinitionDeclared(endpointGroupId) && this.isValidEndpointGroupName(name))) {
            String message = !this.isDynamicEndpointGroupDefinitionDeclared(endpointGroupId) ? "No dynamic endpoint group definition with id '" + endpointGroupId + "' declared" : "Desired endpoint group name already exists: " + name;
            throw new IllegalArgumentException(message);
        }
        EndpointGroupDescription desc = new EndpointGroupDescription(this.endpointDefinitionsProvider.getDynamicEndpointGroupDefinition(endpointGroupId));
        desc.setName(name);
        desc.setDynamicEndpointIdentifier(endpointGroupId);
        this.dynamicEndpointGroupDescriptions.put(name, desc);
        return desc;
    }

    public EndpointGroupDescription removeDynamicEndpointGroupDescription(String name) {
        return this.dynamicEndpointGroupDescriptions.remove(name);
    }

    public Set<EndpointGroupDescription> getEndpointGroupDescriptions() {
        HashSet<EndpointGroupDescription> descs = new HashSet<EndpointGroupDescription>();
        descs.addAll(this.staticEndpointGroupDescriptions.values());
        descs.addAll(this.dynamicEndpointGroupDescriptions.values());
        return Collections.unmodifiableSet(descs);
    }

    public Set<EndpointGroupDescription> getStaticEndpointGroupDescriptions() {
        return Collections.unmodifiableSet(new HashSet<EndpointGroupDescription>(this.staticEndpointGroupDescriptions.values()));
    }

    public Set<EndpointGroupDescription> getDynamicEndpointGroupDescriptions() {
        return Collections.unmodifiableSet(new HashSet<EndpointGroupDescription>(this.dynamicEndpointGroupDescriptions.values()));
    }

    public EndpointGroupDescription getEndpointGroupDescription(String name) {
        EndpointGroupDescription desc = this.staticEndpointGroupDescriptions.get(name);
        if (desc == null) {
            desc = this.dynamicEndpointGroupDescriptions.get(name);
        }
        return desc;
    }

    public void addInitialDynamicEndpointDescriptions() {
        for (EndpointDefinition definition : this.endpointDefinitionsProvider.getDynamicEndpointDefinitions()) {
            for (InitialDynamicEndpointDefinition initialDefinition : definition.getInitialDynamicEndpointDefinitions()) {
                this.addDynamicEndpointDescription(definition.getIdentifier(), initialDefinition.getName(), initialDefinition.getDataType(), new HashMap<String, String>());
            }
        }
    }

    public Set<EndpointDescription> getEndpointDescriptions() {
        HashMap<String, EndpointDescription> endpointDescs = new HashMap<String, EndpointDescription>();
        endpointDescs.putAll(this.staticEndpointDescriptions);
        endpointDescs.putAll(this.dynamicEndpointDescriptions);
        return this.cloneEndpointDescriptionValues(endpointDescs.values());
    }

    public Set<EndpointDescription> getStaticEndpointDescriptions() {
        return this.cloneEndpointDescriptionValues(this.staticEndpointDescriptions.values());
    }

    public Set<EndpointDescription> getDynamicEndpointDescriptions() {
        return this.cloneEndpointDescriptionValues(this.dynamicEndpointDescriptions.values());
    }

    public Set<EndpointDefinition> getStaticEndpointDefinitions() {
        return Collections.unmodifiableSet(this.endpointDefinitionsProvider.getStaticEndpointDefinitions());
    }

    public Set<EndpointDefinition> getStaticEndpointDefinitions(List<String> names) {
        HashSet<EndpointDefinition> endpointDefinitions = new HashSet<EndpointDefinition>();
        for (String name : names) {
            endpointDefinitions.add(this.getStaticEndpointDefinition(name));
        }
        return endpointDefinitions;
    }

    public EndpointDefinition getStaticEndpointDefinition(String name) {
        return this.endpointDefinitionsProvider.getStaticEndpointDefinition(name);
    }

    public Set<EndpointDefinition> getDynamicEndpointDefinitions() {
        return Collections.unmodifiableSet(this.endpointDefinitionsProvider.getDynamicEndpointDefinitions());
    }

    public Set<EndpointDefinition> getDynamicEndpointDefinitions(List<String> ids) {
        HashSet<EndpointDefinition> endpointDefinitions = new HashSet<EndpointDefinition>();
        for (String id : ids) {
            endpointDefinitions.add(this.getDynamicEndpointDefinition(id));
        }
        return endpointDefinitions;
    }

    public EndpointDefinition getDynamicEndpointDefinition(String id) {
        return this.endpointDefinitionsProvider.getDynamicEndpointDefinition(id);
    }

    private Set<EndpointDescription> cloneEndpointDescriptionValues(Collection<EndpointDescription> endpointDescriptions) {
        HashSet<EndpointDescription> clonedDescs = new HashSet<EndpointDescription>();
        for (EndpointDescription desc : endpointDescriptions) {
            clonedDescs.add(EndpointDescription.copy(desc));
        }
        return clonedDescs;
    }

    public EndpointDescription getEndpointDescription(String name) {
        EndpointDescription endpointDesc = this.getNotClonedEndpointDescription(name);
        if (endpointDesc != null) {
            return EndpointDescription.copy(endpointDesc);
        }
        return null;
    }

    public EndpointDescription addDynamicEndpointDescription(String endpointId, String name, DataType dataType, Map<String, String> metaData) throws IllegalArgumentException {
        if (!this.isDynamicEndpointDefinitionDeclared(endpointId)) {
            throw new IllegalArgumentException(StringUtils.format((String)NO_DYNAMIC_ENDPOINT_DEFINITION_WITH_ID_S_DECLARED, (Object[])new Object[]{endpointId}));
        }
        return this.addDynamicEndpointDescription(endpointId, name, dataType, metaData, UUID.randomUUID().toString(), this.getDynamicEndpointDefinition(endpointId).getParentGroupName(), true);
    }

    public EndpointDescription addDynamicEndpointDescription(String endpointId, String name, DataType dataType, Map<String, String> metaData, boolean checkIfDeclared) throws IllegalArgumentException {
        if (this.isDynamicEndpointDefinitionDeclared(endpointId)) {
            return this.addDynamicEndpointDescription(endpointId, name, dataType, metaData, UUID.randomUUID().toString(), this.getDynamicEndpointDefinition(endpointId).getParentGroupName(), checkIfDeclared);
        }
        if (checkIfDeclared) {
            throw new IllegalArgumentException(StringUtils.format((String)NO_DYNAMIC_ENDPOINT_DEFINITION_WITH_ID_S_DECLARED, (Object[])new Object[]{endpointId}));
        }
        return this.addDynamicEndpointDescription(endpointId, name, dataType, metaData, UUID.randomUUID().toString(), null, checkIfDeclared);
    }

    public EndpointDescription addDynamicEndpointDescription(String endpointId, String name, DataType dataType, Map<String, String> metaData, String parentGroup, boolean checkIfDeclared) throws IllegalArgumentException {
        return this.addDynamicEndpointDescription(endpointId, name, dataType, metaData, UUID.randomUUID().toString(), parentGroup, checkIfDeclared);
    }

    public EndpointDescription addDynamicEndpointDescription(String endpointId, String name, DataType dataType, Map<String, String> metaData, String identifier, String parentGroup, boolean checkIfDeclared) throws IllegalArgumentException {
        if (!(!checkIfDeclared || this.isDynamicEndpointDefinitionDeclared(endpointId) && this.isValidEndpointName(name))) {
            String message = !this.isDynamicEndpointDefinitionDeclared(endpointId) ? StringUtils.format((String)NO_DYNAMIC_ENDPOINT_DEFINITION_WITH_ID_S_DECLARED, (Object[])new Object[]{endpointId}) : MESSAGE_DESIRED_ENDPOINT_NAME_ALREADY_EXISTS + name;
            throw new IllegalArgumentException(message);
        }
        EndpointDescription desc = new EndpointDescription(this.endpointDefinitionsProvider.getDynamicEndpointDefinition(endpointId), identifier);
        desc.setName(name);
        desc.setDynamicEndpointIdentifier(endpointId);
        desc.setDataType(dataType);
        for (String key : metaData.keySet()) {
            desc.setMetaDataValue(key, metaData.get(key));
        }
        if (parentGroup != null) {
            desc.setParentGroupName(parentGroup);
        }
        this.dynamicEndpointDescriptions.put(name, desc);
        this.firePropertyChange(PROPERTY_ENDPOINT, new EndpointChange(EndpointChange.Type.Added, desc, null));
        return desc;
    }

    public EndpointDescription addDynamicEndpointDescription(String endpointId, String name, DataType dataType, Map<String, String> metaData, String identifier) throws IllegalArgumentException {
        if (!this.isDynamicEndpointDefinitionDeclared(endpointId)) {
            throw new IllegalArgumentException(StringUtils.format((String)NO_DYNAMIC_ENDPOINT_DEFINITION_WITH_ID_S_DECLARED, (Object[])new Object[]{endpointId}));
        }
        return this.addDynamicEndpointDescription(endpointId, name, dataType, metaData, identifier, this.getDynamicEndpointDefinition(endpointId).getParentGroupName(), true);
    }

    private boolean isDynamicEndpointGroupDefinitionDeclared(String endpointGroupId) {
        return this.endpointDefinitionsProvider.getDynamicEndpointGroupDefinition(endpointGroupId) != null;
    }

    private boolean isDynamicEndpointDefinitionDeclared(String endpointId) {
        return this.endpointDefinitionsProvider.getDynamicEndpointDefinition(endpointId) != null;
    }

    public EndpointDescription removeDynamicEndpointDescription(String name) {
        EndpointDescription desc = this.dynamicEndpointDescriptions.remove(name);
        this.firePropertyChange(PROPERTY_ENDPOINT, new EndpointChange(EndpointChange.Type.Removed, null, desc));
        return desc;
    }

    public EndpointDescription removeDynamicEndpointDescriptionQuietely(String name) {
        return this.dynamicEndpointDescriptions.remove(name);
    }

    public synchronized EndpointDescription editDynamicEndpointDescription(String oldName, String newName, DataType newDataType, Map<String, String> newMetaData, String newDynEndpointId) throws IllegalArgumentException {
        return this.editDynamicEndpointDescription(oldName, newName, newDataType, newMetaData, newDynEndpointId, this.getDynamicEndpointDefinition(newDynEndpointId).getParentGroupName());
    }

    public synchronized EndpointDescription editDynamicEndpointDescription(String oldName, String newName, DataType newDataType, Map<String, String> newMetaData, String newDynEndpointId, String newParentGroup) throws IllegalArgumentException {
        EndpointDescription description = this.dynamicEndpointDescriptions.remove(oldName);
        if (description == null) {
            throw new IllegalArgumentException(StringUtils.format((String)MESSAGE_DYNAMIC_ENDPOINT_DESCRIPTION_DOESNT_EXIST, (Object[])new Object[]{oldName}));
        }
        EndpointDescription oldDescription = EndpointDescription.copy(description);
        try {
            if (!this.isValidEndpointName(newName)) {
                throw new IllegalArgumentException(MESSAGE_DESIRED_ENDPOINT_NAME_ALREADY_EXISTS + newName);
            }
            description.setName(newName);
            description.setDataType(newDataType);
            description.setMetaData(newMetaData);
            description.getMetaData().put("loopEndpointType_5e0ed1cd", oldDescription.getMetaDataValue("loopEndpointType_5e0ed1cd"));
            if (newDynEndpointId != null) {
                description.setDynamicEndpointIdentifier(newDynEndpointId);
            }
            description.setParentGroupName(newParentGroup);
        }
        catch (IllegalArgumentException e) {
            this.dynamicEndpointDescriptions.put(oldName, description);
            throw e;
        }
        this.dynamicEndpointDescriptions.put(newName, description);
        this.firePropertyChange(PROPERTY_ENDPOINT, new EndpointChange(EndpointChange.Type.Modified, description, oldDescription));
        return description;
    }

    public synchronized EndpointDescription editDynamicEndpointDescription(String oldName, String newName, DataType newDataType, Map<String, String> newMetaData) throws IllegalArgumentException {
        if (this.getEndpointDescription(oldName) == null) {
            throw new IllegalArgumentException(StringUtils.format((String)MESSAGE_DYNAMIC_ENDPOINT_DESCRIPTION_DOESNT_EXIST, (Object[])new Object[]{oldName}));
        }
        return this.editDynamicEndpointDescription(oldName, newName, newDataType, newMetaData, this.getEndpointDescription(oldName).getDynamicEndpointIdentifier());
    }

    public synchronized void addStaticEndpointDescription(EndpointDescription description) {
        this.staticEndpointDescriptions.put(description.getName(), description);
    }

    public synchronized EndpointDescription editStaticEndpointDescription(String name, DataType newDataType, Map<String, String> newMetaData) throws IllegalArgumentException {
        return this.editStaticEndpointDescription(name, newDataType, newMetaData, true);
    }

    public synchronized EndpointDescription editStaticEndpointDescription(String name, DataType newDataType, Map<String, String> newMetaData, boolean checkIfDeclared) throws IllegalArgumentException {
        EndpointDescription description = this.staticEndpointDescriptions.get(name);
        if (description == null) {
            if (checkIfDeclared) {
                throw new IllegalArgumentException("Static endpoint description with name '" + name + "' doesn't exist");
            }
            description = new EndpointDescription(null, this.endpointType);
            description.setName(name);
            description.setDataType(newDataType);
            description.setMetaData(newMetaData);
            this.staticEndpointDescriptions.put(name, description);
            return description;
        }
        EndpointDescription oldDescription = EndpointDescription.copy(description);
        description.setDataType(newDataType);
        description.setMetaData(newMetaData);
        this.firePropertyChange(PROPERTY_ENDPOINT, new EndpointChange(EndpointChange.Type.Modified, description, oldDescription));
        return description;
    }

    public boolean isValidEndpointName(String name) {
        return name != null && !name.isEmpty() && !name.isBlank() && !this.staticEndpointDescriptions.containsKey(name) && !this.dynamicEndpointDescriptions.containsKey(name);
    }

    public boolean isValidEndpointGroupName(String name) {
        return name != null && !name.isEmpty() && !this.staticEndpointGroupDescriptions.containsKey(name) && !this.dynamicEndpointGroupDescriptions.containsKey(name);
    }

    public void addConnectedDataType(String endpointName, DataType dataType) {
        EndpointDescription endpointDesc = this.getNotClonedEndpointDescription(endpointName);
        if (endpointDesc != null) {
            EndpointDescription oldEndpointDesc = EndpointDescription.copy(endpointDesc);
            endpointDesc.addConnectedDataType(dataType);
            this.firePropertyChange(PROPERTY_ENDPOINT, new EndpointChange(EndpointChange.Type.Modified, endpointDesc, oldEndpointDesc));
        }
    }

    public void removeConnectedDataType(String endpointName, DataType dataType) {
        EndpointDescription endpointDesc = this.getNotClonedEndpointDescription(endpointName);
        if (endpointDesc != null) {
            EndpointDescription oldEndpointDesc = EndpointDescription.copy(endpointDesc);
            endpointDesc.removeConnectedDataType(dataType);
            this.firePropertyChange(PROPERTY_ENDPOINT, new EndpointChange(EndpointChange.Type.Modified, endpointDesc, oldEndpointDesc));
        }
    }

    public EndpointType getManagedEndpointType() {
        return this.endpointType;
    }

    private EndpointDescription getNotClonedEndpointDescription(String name) {
        EndpointDescription endpointDesc = this.staticEndpointDescriptions.get(name);
        if (endpointDesc == null) {
            return this.dynamicEndpointDescriptions.get(name);
        }
        return endpointDesc;
    }
}

