/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.impl;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;

public class ComponentExecutionInformationImpl
implements ComponentExecutionInformation {
    private static final long serialVersionUID = -35637831085899098L;
    private String identifier;
    private String instanceName;
    private LogicalNodeId nodeId;
    private String componentIdentifier;
    private NetworkDestination storageNetworkDestination;
    private String workflowInstanceName;
    private String workflowExecutionIdentifier;
    private LogicalNodeId workflowNodeId;

    public ComponentExecutionInformationImpl() {
    }

    public ComponentExecutionInformationImpl(ComponentExecutionContext compExeCtx) {
        this.identifier = compExeCtx.getExecutionIdentifier();
        this.instanceName = compExeCtx.getInstanceName();
        this.nodeId = compExeCtx.getNodeId();
        this.componentIdentifier = compExeCtx.getComponentDescription().getIdentifier();
        this.storageNetworkDestination = compExeCtx.getStorageNetworkDestination();
        this.workflowInstanceName = compExeCtx.getWorkflowInstanceName();
        this.workflowExecutionIdentifier = compExeCtx.getWorkflowExecutionIdentifier();
        this.workflowNodeId = compExeCtx.getWorkflowNodeId();
    }

    @Override
    public String getExecutionIdentifier() {
        return this.identifier;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public LogicalNodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public void setNodeId(LogicalNodeId nodeId) {
        this.nodeId = nodeId;
    }

    public void setIdentifier(String executionIdentifier) {
        this.identifier = executionIdentifier;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setComponentIdentifier(String componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
    }

    @Override
    public NetworkDestination getStorageNetworkDestination() {
        return this.storageNetworkDestination;
    }

    public void setStorageNetworkDestination(NetworkDestination networkDestination) {
        this.storageNetworkDestination = networkDestination;
    }

    @Override
    public String getWorkflowInstanceName() {
        return this.workflowInstanceName;
    }

    public void setWorkflowInstanceName(String workflowInstanceName) {
        this.workflowInstanceName = workflowInstanceName;
    }

    @Override
    public String getWorkflowExecutionIdentifier() {
        return this.workflowExecutionIdentifier;
    }

    public void setWorkflowExecutionIdentifier(String workflowExecutionIdentifier) {
        this.workflowExecutionIdentifier = workflowExecutionIdentifier;
    }

    @Override
    public LogicalNodeId getWorkflowNodeId() {
        return this.workflowNodeId;
    }

    public void setWorkflowNodeId(LogicalNodeId workflowNodeId) {
        this.workflowNodeId = workflowNodeId;
    }
}

