/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.api;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ComponentGroupPathRules {
    protected static final String RCE_COMPONENTS = "RCE Components";
    protected static final int MINIMUM_ID_LENGTH = 2;
    protected static final String MINIMUM_ID_LENGTH_ERROR_MESSAGE = "The minimum allowed length is at least 2 characters.";
    protected static final int MAXIMUM_ID_LENGTH = 100;
    protected static final String MAXIMUM_ID_LENGTH_ERROR_MESSAGE = "The maximum allowed length is %d characters.";
    protected static final Pattern GROUP_PATH_VALID_CHARACTERS_REGEXP = Pattern.compile("[^a-zA-Z0-9 _\\.,\\-\\+\\(\\)\\/]");
    protected static final String INVALID_GROUP_PATH_CHARSET_ERROR_MESSAGE = "Invalid character at position %d (\"%s\") - anything except a-z, A-Z, digits, spaces, and _.,-+()/ is forbidden.";
    protected static final Pattern VALID_GROUP_PATH_FIRST_CHARACTER_REGEXP = Pattern.compile("^[a-zA-Z_].*");
    protected static final String VALID_GROUP_PATH_FIRST_CHARACTER_ERROR_MESSAGE = "It must begin with one of the letters a-z, A-Z, or the underscore (\"_\")";
    protected static final Pattern VALID_GROUP_PATH_LAST_CHARACTER_REGEXP = Pattern.compile(".*[^ \\/]$");
    protected static final String VALID_GROUP_PATH_LAST_CHARACTER_ERROR_MESSAGE = "Spaces or Slashes are allowed, but cannot be the last character.";
    protected static final Pattern INVALID_LEADING_SPACES = Pattern.compile("\\s+\\/");
    protected static final Pattern INVALID_TRADING_SPACES = Pattern.compile("\\/\\s+");
    protected static final String INVALID_LEADING_TRADING_SPACES_ERROR_MESSAGE = "Spaces are not allowed before or after any slash.";
    protected static final Pattern INVALID_SLASHES = Pattern.compile("\\/\\/");
    protected static final String INVALID_DOUBLE_SLASH_ERROR_MESSAGE = "Invalid double slash.";

    private ComponentGroupPathRules() {
    }

    public static Optional<String> validateComponentGroupPathRules(String input) {
        Optional<String> commonValidationError = ComponentGroupPathRules.validateCommonRules(input);
        if (commonValidationError.isPresent()) {
            return commonValidationError;
        }
        Optional<String> groupPathError = ComponentGroupPathRules.validateGroupPathRules(input);
        if (groupPathError.isPresent()) {
            return groupPathError;
        }
        return Optional.empty();
    }

    public static Optional<String> validateCommonRules(String input) {
        if (input == null) {
            return Optional.empty();
        }
        if (input.length() < 2) {
            return Optional.of(MINIMUM_ID_LENGTH_ERROR_MESSAGE);
        }
        if (input.length() > 100) {
            return Optional.of(StringUtils.format((String)MAXIMUM_ID_LENGTH_ERROR_MESSAGE, (Object[])new Object[]{100}));
        }
        if (input.isEmpty()) {
            return Optional.empty();
        }
        if (!VALID_GROUP_PATH_FIRST_CHARACTER_REGEXP.matcher(input).matches()) {
            return Optional.of(VALID_GROUP_PATH_FIRST_CHARACTER_ERROR_MESSAGE);
        }
        if (INVALID_LEADING_SPACES.matcher(input).find() || INVALID_TRADING_SPACES.matcher(input).find()) {
            return Optional.of(INVALID_LEADING_TRADING_SPACES_ERROR_MESSAGE);
        }
        return Optional.empty();
    }

    private static Optional<String> validateGroupPathRules(String input) {
        Matcher invalidCharMatcher = GROUP_PATH_VALID_CHARACTERS_REGEXP.matcher(input);
        if (invalidCharMatcher.find()) {
            return Optional.of(StringUtils.format((String)INVALID_GROUP_PATH_CHARSET_ERROR_MESSAGE, (Object[])new Object[]{invalidCharMatcher.start(0) + 1, invalidCharMatcher.group(0)}));
        }
        if (INVALID_SLASHES.matcher(input).find()) {
            return Optional.of(INVALID_DOUBLE_SLASH_ERROR_MESSAGE);
        }
        if (!VALID_GROUP_PATH_LAST_CHARACTER_REGEXP.matcher(input).matches()) {
            return Optional.of(VALID_GROUP_PATH_LAST_CHARACTER_ERROR_MESSAGE);
        }
        return Optional.empty();
    }
}

