/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.common;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.extras.testscriptrunner.definitions.common.InstanceManagementStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import io.cucumber.java.After;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class RceTestLifeCycleHooks
extends InstanceManagementStepDefinitionBase {
    public RceTestLifeCycleHooks(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @Before
    public void before(Scenario scenario) {
        this.initialize();
        this.executionContext.beforeExecution(scenario);
    }

    @After
    public void after(Scenario scenario) throws OperationFailureException {
        this.tearDownLeftoverRunningInstances();
        this.executionContext.afterExecution(scenario);
    }

    private void initialize() {
        Assert.assertTrue((boolean)this.executionContext.getInstancesById().isEmpty());
        Assert.assertTrue((boolean)this.executionContext.getEnabledInstances().isEmpty());
    }

    private void tearDownLeftoverRunningInstances() throws OperationFailureException {
        String instanceId;
        for (ManagedInstance instance : this.executionContext.getEnabledInstances()) {
            instanceId = instance.getId();
            try {
                if (!INSTANCE_MANAGEMENT_SERVICE.isInstanceRunning(instanceId)) continue;
                this.printToCommandConsole(StringUtils.format((String)"Stopping instance \"%s\" after test scenario \"%s\"", (Object[])new Object[]{instanceId, this.executionContext.getScenarioName()}));
                INSTANCE_MANAGEMENT_SERVICE.stopInstance(this.listOfSingleStringElement(instanceId), this.getTextoutReceiverForIMOperations(), TimeUnit.SECONDS.toMillis(60L));
            }
            catch (IOException e) {
                this.printToCommandConsole("Error shutting down instance " + instanceId + ": " + e.toString());
            }
        }
        for (ManagedInstance instance : this.executionContext.getEnabledInstances()) {
            instanceId = instance.getId();
            try {
                if (!INSTANCE_MANAGEMENT_SERVICE.isInstanceRunning(instanceId)) continue;
                throw this.testAssertionFailure(StringUtils.format((String)"Instance \"%s\" is still detected as \"running\" after the post-test shutdown for scenario \"%s\"", (Object[])new Object[]{instanceId, this.executionContext.getScenarioName()}));
            }
            catch (IOException e) {
                throw this.testExecutionError("Error verifying shutdown state of instance " + instanceId + ": " + e.toString());
            }
        }
    }
}

