/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.joiner.gui;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;

public class JoinerEditDynamicEndpointCommand
extends WorkflowNodeCommand {
    private final DataType newDataType;
    private DataType oldDataType;
    private int inputCount;

    public JoinerEditDynamicEndpointCommand(DataType newDataType) {
        this.newDataType = newDataType;
    }

    public void initialize() {
        ConfigurationDescription config = this.getProperties().getConfigurationDescription();
        this.oldDataType = DataType.valueOf((String)config.getConfigurationValue("datatype"));
        this.inputCount = Integer.valueOf(config.getConfigurationValue("inputCount"));
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        int i = 1;
        while (i <= this.inputCount) {
            EndpointDescription oldInput = this.getWorkflowNode().getInputDescriptionsManager().getEndpointDescription("Input " + this.getString(i));
            EndpointDescription newInput = EndpointDescription.copy((EndpointDescription)oldInput);
            newInput.setDataType(this.newDataType);
            this.getWorkflowNode().getInputDescriptionsManager().editDynamicEndpointDescription(oldInput.getName(), oldInput.getName(), newInput.getDataType(), newInput.getMetaData());
            ++i;
        }
        EndpointDescription oldOutput = this.getWorkflowNode().getOutputDescriptionsManager().getEndpointDescription("Joined");
        EndpointDescription newOutput = EndpointDescription.copy((EndpointDescription)oldOutput);
        newOutput.setDataType(this.newDataType);
        this.getWorkflowNode().getOutputDescriptionsManager().editStaticEndpointDescription(oldOutput.getName(), newOutput.getDataType(), newOutput.getMetaData());
        this.getProperties().getConfigurationDescription().setConfigurationValue("datatype", this.newDataType.name());
    }

    public void undo() {
        int i = 1;
        while (i <= this.inputCount) {
            EndpointDescription oldInput = this.getWorkflowNode().getInputDescriptionsManager().getEndpointDescription("Input " + this.getString(i));
            EndpointDescription newInput = EndpointDescription.copy((EndpointDescription)oldInput);
            newInput.setDataType(this.oldDataType);
            this.getWorkflowNode().getInputDescriptionsManager().editDynamicEndpointDescription(oldInput.getName(), oldInput.getName(), newInput.getDataType(), newInput.getMetaData());
            ++i;
        }
        EndpointDescription oldOutput = this.getWorkflowNode().getOutputDescriptionsManager().getEndpointDescription("Joined");
        EndpointDescription newOutput = EndpointDescription.copy((EndpointDescription)oldOutput);
        newOutput.setDataType(this.oldDataType);
        this.getWorkflowNode().getOutputDescriptionsManager().editStaticEndpointDescription(newOutput.getName(), newOutput.getDataType(), newOutput.getMetaData());
        this.getProperties().getConfigurationDescription().setConfigurationValue("datatype", this.oldDataType.name());
    }

    private String getString(int i) {
        String result = "";
        if (i < 10) {
            result = String.valueOf(result) + "0";
        }
        if (i < 100) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + i;
        return result;
    }
}

