/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.sshremoteaccess;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.ssh.jsch.JschFileTransfer;
import de.rcenvironment.core.utils.ssh.jsch.executor.JSchRCECommandLineExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshRemoteAccessClientComponent
extends DefaultComponent {
    private static final String COLON = ":";
    private static final Log LOG = LogFactory.getLog(SshRemoteAccessClientComponent.class);
    private static final String QUOT = "\"";
    private ObjectMapper mapper;
    private SshConnectionService sshService;
    private TempFileService tempFileService;
    private ComponentDataManagementService datamanagementService;
    private ComponentContext componentContext;
    private String toolName;
    private String toolVersion;
    private String hostId;
    private String connectionId;
    private ComponentLog componentLog;
    private boolean isWorkflow;
    private TypedDatumSerializer serializer;
    private String currentSessionToken;
    private boolean componentCancelled;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.componentLog = componentContext.getLog();
    }

    public void start() throws ComponentException {
        this.mapper = new ObjectMapper();
        this.tempFileService = TempFileServiceAccess.getInstance();
        this.datamanagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.sshService = (SshConnectionService)this.componentContext.getService(SshConnectionService.class);
        this.serializer = ((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getSerializer();
        this.toolName = this.componentContext.getConfigurationValue("toolName");
        this.hostId = this.componentContext.getConfigurationValue("hostId");
        this.toolVersion = this.componentContext.getConfigurationValue("version");
        this.connectionId = this.componentContext.getConfigurationValue("connection");
        this.isWorkflow = Boolean.parseBoolean(this.componentContext.getConfigurationValue("isWorkflow"));
        this.componentCancelled = false;
        if (this.toolName == null || this.toolVersion == null || this.connectionId == null) {
            throw new ComponentException("Configuration for remote tool is not valid.");
        }
        SshConnectionSetup connection = this.sshService.getConnectionSetup(this.connectionId);
        if (connection == null) {
            throw new ComponentException("The SSH connection for this tool does not exist.");
        }
        this.componentLog.componentInfo("Started on logical node " + this.componentContext.getServiceCallContext().getReceivingNode());
        if (this.treatStartAsComponentRun()) {
            this.processInputs();
        }
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getInputs().isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processInputs() throws ComponentException {
        String state;
        File downloadDir;
        JSchRCECommandLineExecutor rceExecutor;
        Session session;
        block23: {
            File uploadDir;
            File tempRootDir;
            HashMap<String, String> inputsMap = new HashMap<String, String>();
            try {
                tempRootDir = this.tempFileService.createManagedTempDir();
                uploadDir = this.prepareUploadDirectory(tempRootDir, inputsMap);
            }
            catch (IOException e1) {
                throw new ComponentException("Upload directory could not be created.", (Throwable)e1);
            }
            session = this.sshService.getAvtiveSshSession(this.connectionId);
            rceExecutor = new JSchRCECommandLineExecutor(session);
            this.initializeRemoteExecutionContext(rceExecutor);
            downloadDir = new File(tempRootDir, "output");
            try {
                JschFileTransfer.uploadDirectoryToRCEInstance((Session)session, (File)uploadDir, (String)StringUtils.format((String)"/ra/%s/input", (Object[])new Object[]{this.currentSessionToken}));
            }
            catch (JSchException | IOException | InterruptedException e2) {
                throw new ComponentException("Uploading input directory via SCP failed", e2);
            }
            String command = this.prepareCommandStringForRemoteExecution(uploadDir, inputsMap, this.currentSessionToken, downloadDir);
            state = "";
            try {
                rceExecutor.start(command);
                Throwable throwable = null;
                Object var10_15 = null;
                try {
                    InputStream stdoutStream = rceExecutor.getStdout();
                    try {
                        try (InputStream stderrStream = rceExecutor.getStderr();){
                            state = this.waitForRemoteToolExecutionAndLogOutput(rceExecutor, this.currentSessionToken, stdoutStream, stderrStream);
                        }
                        if (stdoutStream == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stdoutStream == null) throw throwable;
                        stdoutStream.close();
                        throw throwable;
                    }
                    stdoutStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException e1) {
                throw new ComponentException("Executing SSH command failed", (Throwable)e1);
            }
        }
        if (!state.equals(FinalWorkflowState.FINISHED.toString())) {
            if (!state.equals(FinalWorkflowState.CANCELLED.toString())) throw new ComponentException("Remote component execution failed.");
            if (!this.componentCancelled) {
                throw new ComponentException("Remote component execution failed.");
            }
        }
        this.extractAndSendOutputs(session, this.currentSessionToken, downloadDir);
        try {
            rceExecutor.start(StringUtils.format((String)"ra dispose %s", (Object[])new Object[]{this.currentSessionToken}));
            return;
        }
        catch (IOException e1) {
            throw new ComponentException("Disposing SCP context failed.", (Throwable)e1);
        }
    }

    public synchronized void onProcessInputsInterrupted(ThreadHandler executingThreadHandler) {
        Session session = this.sshService.getAvtiveSshSession(this.connectionId);
        this.componentCancelled = true;
        JSchRCECommandLineExecutor rceExecutor = new JSchRCECommandLineExecutor(session);
        try {
            rceExecutor.start(StringUtils.format((String)"ra cancel %s", (Object[])new Object[]{this.currentSessionToken}));
        }
        catch (IOException e) {
            LOG.error((Object)"Cancelling remote tool failed", (Throwable)e);
            this.componentLog.componentError("Cancelling remote tool failed");
        }
    }

    private String waitForRemoteToolExecutionAndLogOutput(JSchRCECommandLineExecutor rceExecutor, String sessionToken, InputStream stdoutStream, InputStream stderrStream) throws IOException, ComponentException, InterruptedException {
        LineIterator it = IOUtils.lineIterator((InputStream)stdoutStream, null);
        String state = "";
        while (it.hasNext()) {
            String line = it.nextLine();
            if (line.equals("")) {
                throw new ComponentException("Could not execute the remote tool or workflow. Reason: " + it.nextLine());
            }
            String newState = this.parseLogLine(sessionToken, line);
            if (newState.equals("")) continue;
            state = newState;
        }
        rceExecutor.waitForTermination();
        String errStream = IOUtils.toString((InputStream)stderrStream);
        if (!errStream.isEmpty()) {
            LOG.error((Object)errStream);
        }
        return state;
    }

    private String prepareCommandStringForRemoteExecution(File uploadDir, Map<String, String> inputsMap, String sessionToken, File downloadDir) throws ComponentException {
        String command;
        String formattedToolName = QUOT + this.toolName.replace(QUOT, "\"\"") + QUOT;
        String formattedVersion = QUOT + this.toolVersion.replace(QUOT, "\"\"") + QUOT;
        if (this.isWorkflow) {
            command = StringUtils.format((String)"ra run-wf %s --show-output %s %s", (Object[])new Object[]{sessionToken, formattedToolName, formattedVersion, uploadDir.getName(), downloadDir.getName()});
        } else {
            String dynInputs = this.createDynamicInputsString(inputsMap);
            String dynoutputs = this.createDynamicOutputsString();
            String notRequiredInputs = this.createNotRequiredInputsString();
            command = StringUtils.format((String)"ra run-tool %s --show-output -n %s %s %s %s %s %s", (Object[])new Object[]{sessionToken, this.hostId, formattedToolName, formattedVersion, dynInputs, dynoutputs, notRequiredInputs});
        }
        return command;
    }

    private String createDynamicOutputsString() throws ComponentException {
        HashSet dynoutputsSet = new HashSet();
        for (String outputName : this.componentContext.getOutputs()) {
            if (!this.componentContext.isDynamicOutput(outputName)) continue;
            HashMap<String, Object> outputData = new HashMap<String, Object>();
            outputData.put("identifier", this.componentContext.getDynamicOutputIdentifier(outputName));
            outputData.put("name", outputName);
            outputData.put("dataType", this.componentContext.getOutputDataType(outputName));
            HashMap<String, String> metaData = new HashMap<String, String>();
            for (String metaDataKey : this.componentContext.getOutputMetaDataKeys(outputName)) {
                metaData.put(metaDataKey, this.componentContext.getOutputMetaDataValue(outputName, metaDataKey));
            }
            outputData.put("metaData", metaData);
            dynoutputsSet.add(outputData);
        }
        String dynoutputs = "";
        if (!dynoutputsSet.isEmpty()) {
            try {
                dynoutputs = StringUtils.format((String)"--dynOutputs %s", (Object[])new Object[]{this.mapper.writeValueAsString(dynoutputsSet)});
            }
            catch (IOException e) {
                throw new ComponentException("Could not transfer dynamic output descriptions to remote tool: " + e);
            }
        }
        return dynoutputs;
    }

    private String createDynamicInputsString(Map<String, String> inputsMap) throws ComponentException {
        HashSet dynInputsSet = new HashSet();
        for (String inputName : inputsMap.keySet()) {
            if (!this.componentContext.isDynamicInput(inputName)) continue;
            HashMap<String, Object> inputData = new HashMap<String, Object>();
            inputData.put("identifier", this.componentContext.getDynamicInputIdentifier(inputName));
            inputData.put("name", inputName);
            inputData.put("dataType", this.componentContext.getInputDataType(inputName));
            HashMap<String, String> metaData = new HashMap<String, String>();
            for (String metaDataKey : this.componentContext.getInputMetaDataKeys(inputName)) {
                metaData.put(metaDataKey, this.componentContext.getInputMetaDataValue(inputName, metaDataKey));
            }
            inputData.put("metaData", metaData);
            dynInputsSet.add(inputData);
        }
        String dynInputs = "";
        if (!dynInputsSet.isEmpty()) {
            try {
                dynInputs = StringUtils.format((String)"--dynInputs %s", (Object[])new Object[]{this.mapper.writeValueAsString(dynInputsSet)});
            }
            catch (IOException e) {
                throw new ComponentException("Could not transfer dynamic input descriptions to remote tool: " + e);
            }
        }
        return dynInputs;
    }

    private String createNotRequiredInputsString() throws ComponentException {
        HashSet<String> nonReqInputsSet = new HashSet<String>();
        nonReqInputsSet.addAll(this.componentContext.getInputsNotConnected());
        for (String input : this.componentContext.getInputs()) {
            EndpointDefinition.InputExecutionContraint exeConstraint;
            if (this.componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea") == null || !(exeConstraint = EndpointDefinition.InputExecutionContraint.valueOf((String)this.componentContext.getInputMetaDataValue(input, "inputExecutionConstraint_4aae3eea"))).equals((Object)EndpointDefinition.InputExecutionContraint.NotRequired)) continue;
            nonReqInputsSet.add(input);
        }
        String nonReqInputs = "";
        if (!nonReqInputsSet.isEmpty()) {
            try {
                nonReqInputs = StringUtils.format((String)"--nonReqInputs %s", (Object[])new Object[]{this.mapper.writeValueAsString(nonReqInputsSet)});
            }
            catch (IOException e) {
                throw new ComponentException("Could not transfer not connected inputs to remote tool: " + e);
            }
        }
        return nonReqInputs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeRemoteExecutionContext(JSchRCECommandLineExecutor rceExecutor) throws ComponentException {
        try {
            rceExecutor.start("ra init --compact");
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                InputStream stdoutStream = rceExecutor.getStdout();
                try {
                    try (InputStream stderrStream = rceExecutor.getStderr();){
                        rceExecutor.waitForTermination();
                        this.currentSessionToken = IOUtils.toString((InputStream)stdoutStream).trim();
                        if (this.currentSessionToken.contains("Command ra init --compact not executed.")) {
                            throw new ComponentException("Could not initiate remote tool or workflow execution. Reason: " + this.currentSessionToken);
                        }
                        LOG.info((Object)("Received session token " + this.currentSessionToken));
                        String errStream = IOUtils.toString((InputStream)stderrStream);
                        if (!errStream.isEmpty()) {
                            LOG.error((Object)errStream);
                        }
                    }
                    if (stdoutStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stdoutStream == null) throw throwable;
                    stdoutStream.close();
                    throw throwable;
                }
                stdoutStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException e1) {
            throw new ComponentException("Executing SSH command failed", (Throwable)e1);
        }
    }

    private File prepareUploadDirectory(File tempRootDir, Map<String, String> inputsMap) throws IOException {
        File uploadDir = new File(tempRootDir, "input");
        uploadDir.mkdir();
        File inputsFile = new File(uploadDir, "inputs.json");
        if (this.componentContext != null && this.componentContext.getInputsWithDatum() != null) {
            for (String inputName : this.componentContext.getInputsWithDatum()) {
                TypedDatum input = this.componentContext.readInput(inputName);
                switch (input.getDataType()) {
                    case DirectoryReference: {
                        File inputFile = new File(uploadDir, ((DirectoryReferenceTD)input).getDirectoryReference());
                        this.datamanagementService.copyReferenceTDToLocalCompressedFile(this.componentContext, input, inputFile);
                        break;
                    }
                    case FileReference: {
                        File inputDir = new File(uploadDir, ((FileReferenceTD)input).getFileReference());
                        this.datamanagementService.copyReferenceTDToLocalCompressedFile(this.componentContext, input, inputDir);
                    }
                }
                inputsMap.put(inputName, this.serializer.serialize(input));
            }
        }
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(inputsFile, inputsMap);
        return uploadDir;
    }

    private void extractAndSendOutputs(Session session, String sessionToken, File downloadDir) throws ComponentException {
        try {
            JschFileTransfer.downloadDirectory((Session)session, (String)StringUtils.format((String)"/ra/%s/output", (Object[])new Object[]{sessionToken}), (File)downloadDir.getParentFile());
        }
        catch (JSchException | IOException e1) {
            throw new ComponentException("Downloading output directory via SCP failed", e1);
        }
        File outputsFile = new File(downloadDir, "outputs.json");
        if (!outputsFile.exists()) {
            throw new ComponentException("Downloaded directory does not contain file outputs.json");
        }
        try {
            Map outputsMap = (Map)this.mapper.readValue(outputsFile, HashMap.class);
            for (Map.Entry entry : outputsMap.entrySet()) {
                String outputName = (String)entry.getKey();
                if (!this.componentContext.getOutputs().contains(outputName)) {
                    throw new ComponentException("No output with name " + outputName + " defined.");
                }
                for (String output : (List)entry.getValue()) {
                    this.extractAndSendSingleOutput(downloadDir, outputName, output);
                }
            }
        }
        catch (IOException e1) {
            throw new ComponentException("Could not parse file outputs.json: " + e1);
        }
    }

    private void extractAndSendSingleOutput(File downloadDir, String outputName, String output) throws ComponentException, IOException {
        TypedDatum outputTD = this.serializer.deserialize(output);
        if (!outputTD.getDataType().equals((Object)this.componentContext.getOutputDataType(outputName))) {
            throw new ComponentException("Data type of output " + outputName + " does not match the defined type.");
        }
        switch (outputTD.getDataType()) {
            case DirectoryReference: {
                DirectoryReferenceTD newDirTD = this.datamanagementService.createDirectoryReferenceTDFromLocalCompressedFile(this.componentContext, new File(downloadDir, ((DirectoryReferenceTD)outputTD).getDirectoryReference()), ((DirectoryReferenceTD)outputTD).getDirectoryName());
                this.componentContext.writeOutput(outputName, (TypedDatum)newDirTD);
                break;
            }
            case FileReference: {
                FileReferenceTD newFileTD = this.datamanagementService.createFileReferenceTDFromLocalCompressedFile(this.componentContext, new File(downloadDir, ((FileReferenceTD)outputTD).getFileReference()), ((FileReferenceTD)outputTD).getFileName());
                this.componentContext.writeOutput(outputName, (TypedDatum)newFileTD);
                break;
            }
            default: {
                this.componentContext.writeOutput(outputName, outputTD);
            }
        }
    }

    private String parseLogLine(String sessionToken, String line) {
        String state = "";
        if (line.startsWith(StringUtils.format((String)"[%s] StdOut: ", (Object[])new Object[]{sessionToken}))) {
            this.componentLog.toolStdout(line.substring(line.indexOf(COLON) + 2));
        } else if (line.startsWith(StringUtils.format((String)"[%s] State: ", (Object[])new Object[]{sessionToken}))) {
            state = line.substring(line.indexOf(COLON) + 2);
            if (this.isWorkflow) {
                this.componentLog.toolStdout("Workflow state changed, new state: " + WorkflowState.valueOf((String)state).getDisplayName());
            } else {
                this.componentLog.toolStdout("Tool state changed, new state: " + WorkflowState.valueOf((String)state).getDisplayName());
            }
        } else if (line.startsWith(StringUtils.format((String)"[%s] StdErr: ", (Object[])new Object[]{sessionToken}))) {
            this.componentLog.toolStderr(line.substring(line.indexOf(COLON) + 2));
        } else {
            LOG.error((Object)line);
        }
        return state;
    }
}

