/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.variables.legacy;

import de.rcenvironment.core.utils.common.variables.legacy.VariableType;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

@Deprecated
public class TypedValue
implements Serializable {
    public static final TypedValue EMPTY = new TypedValue(VariableType.Empty);
    private static final long serialVersionUID = 8955894133896567250L;
    private final VariableType type;
    private String value;

    public TypedValue(TypedValue from) {
        this.type = from.type;
        this.value = from.value;
    }

    public TypedValue(Serializable value) {
        this.type = TypedValue.determineType(value);
        this.value = this.determineValue(value, this.type);
    }

    public TypedValue(VariableType type) {
        this.type = type;
        this.setDefaultValue();
    }

    public TypedValue(VariableType type, String value) {
        this.type = type;
        this.value = value;
    }

    public TypedValue(Class<? extends Serializable> type, String value) {
        this.type = TypedValue.determineType(type);
        this.setValueFromString(value);
    }

    public TypedValue setStringValue(String stringValue) {
        this.value = stringValue;
        return this;
    }

    public TypedValue setIntegerValue(long intValue) {
        this.value = Long.toString(intValue);
        return this;
    }

    public TypedValue setRealValue(double realValue) {
        this.value = Double.toString(realValue);
        return this;
    }

    public TypedValue setLogicValue(boolean booleanValue) {
        this.value = booleanValue ? "true" : "false";
        return this;
    }

    public VariableType getType() {
        return this.type;
    }

    public String getStringValue() {
        return this.value;
    }

    public long getIntegerValue() {
        return Long.parseLong(this.value.replaceAll("[lL]", "").replaceAll("[\\.,].*$", ""));
    }

    public double getRealValue() {
        return Double.parseDouble(this.value.replaceAll("[dD]", "").replaceAll(",", "."));
    }

    public boolean getLogicValue() {
        if (this.value == null) {
            return false;
        }
        return this.value.equalsIgnoreCase("true");
    }

    public Serializable getValue() {
        Object result = null;
        if (this.value != null) {
            switch (this.type) {
                case Real: {
                    result = this.getRealValue();
                    break;
                }
                case Integer: {
                    result = this.getIntegerValue();
                    break;
                }
                case Logic: {
                    result = this.getLogicValue();
                    break;
                }
                case Empty: {
                    result = null;
                    break;
                }
                default: {
                    result = this.getStringValue();
                }
            }
        }
        return result;
    }

    public TypedValue setValue(Serializable aValue) throws IllegalArgumentException {
        VariableType varType = TypedValue.determineType(aValue);
        if (varType != this.type) {
            throw new IllegalArgumentException("Could not set value to given type: expected " + this.type.toString() + " but found " + varType.toString());
        }
        this.value = this.determineValue(aValue, varType);
        return this;
    }

    public TypedValue setValueFromString(String aValue) {
        switch (this.type) {
            case Logic: {
                this.setStringValue(aValue);
                this.setLogicValue(this.getLogicValue());
                break;
            }
            case Integer: {
                this.setStringValue(aValue);
                this.setIntegerValue(this.getIntegerValue());
                break;
            }
            case Real: {
                this.setStringValue(aValue);
                this.setRealValue(this.getRealValue());
                break;
            }
            case Empty: {
                this.setStringValue(null);
                break;
            }
            default: {
                this.setStringValue(aValue);
            }
        }
        return this;
    }

    public TypedValue setEmptyValue() {
        this.setStringValue(null);
        return this;
    }

    private void setDefaultValue() {
        switch (this.type) {
            case Integer: {
                this.value = "0";
                break;
            }
            case Real: {
                this.value = "0.0";
                break;
            }
            case Logic: {
                this.value = "False";
                break;
            }
            case Empty: {
                this.value = "";
                break;
            }
            default: {
                this.value = "";
            }
        }
    }

    private static VariableType determineType(Serializable valueToDetermine) {
        VariableType varType = null;
        if (valueToDetermine == null) {
            varType = VariableType.Empty;
        } else if (valueToDetermine instanceof String) {
            varType = VariableType.String;
        } else if (valueToDetermine instanceof Integer || valueToDetermine instanceof Long || valueToDetermine instanceof BigInteger) {
            varType = VariableType.Integer;
        } else if (valueToDetermine instanceof Double || valueToDetermine instanceof Float) {
            varType = VariableType.Real;
        } else if (valueToDetermine instanceof Boolean) {
            varType = VariableType.Logic;
        } else if (valueToDetermine instanceof Date) {
            varType = VariableType.Date;
        } else {
            throw new IllegalArgumentException("Could not determine data type in script binding detection");
        }
        return varType;
    }

    private static VariableType determineType(Class<? extends Serializable> typeToDetermine) {
        VariableType varType = null;
        if (typeToDetermine == null) {
            varType = VariableType.Empty;
        } else if (typeToDetermine == String.class) {
            varType = VariableType.String;
        } else if (typeToDetermine == Integer.class || typeToDetermine == Long.class || typeToDetermine == BigInteger.class) {
            varType = VariableType.Integer;
        } else if (typeToDetermine == Double.class || typeToDetermine == Float.class) {
            varType = VariableType.Real;
        } else if (typeToDetermine == Boolean.class) {
            varType = VariableType.Logic;
        } else {
            throw new IllegalArgumentException("Could not determine data type in script binding detection");
        }
        return varType;
    }

    private String determineValue(Serializable valueToDetermine, VariableType varType) {
        String returnValue = null;
        try {
            switch (varType) {
                case Integer: {
                    if (valueToDetermine instanceof Integer) {
                        returnValue = ((Integer)valueToDetermine).toString();
                        break;
                    }
                    if (valueToDetermine instanceof Long) {
                        returnValue = ((Long)valueToDetermine).toString();
                        break;
                    }
                    if (valueToDetermine instanceof BigInteger) {
                        returnValue = ((BigInteger)valueToDetermine).toString();
                    }
                    break;
                }
                case Real: {
                    if (valueToDetermine instanceof Double) {
                        returnValue = ((Double)valueToDetermine).toString();
                        break;
                    }
                    if (valueToDetermine instanceof Float) {
                        returnValue = ((Float)valueToDetermine).toString();
                    }
                    break;
                }
                case Logic: {
                    returnValue = ((Boolean)valueToDetermine).toString();
                    break;
                }
                case Date: {
                    returnValue = ((Date)valueToDetermine).toString();
                    break;
                }
                case Empty: {
                    returnValue = null;
                    break;
                }
                default: {
                    returnValue = (String)((Object)valueToDetermine);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Could not parse numeric value due to unknown format");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Could not determine data value due to null pointer error");
        }
        return returnValue;
    }

    public String toString() {
        return String.valueOf(this.type.name()) + " = " + this.value;
    }
}

