/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.rcenvironment.core.datamanagement.commons.EndpointData;
import de.rcenvironment.core.datamanagement.export.JacksonizedTypedDatumDeserializer;
import de.rcenvironment.core.datamanagement.export.JacksonizedTypedDatumSerializer;
import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matchable;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;

public class PlainEndpoint
implements Comparable<PlainEndpoint>,
Matchable<PlainEndpoint> {
    @JsonProperty
    private String name;
    @JsonSerialize(using=JacksonizedTypedDatumSerializer.class)
    @JsonDeserialize(using=JacksonizedTypedDatumDeserializer.class)
    private TypedDatum datum;
    @JsonProperty
    private Integer counter;

    public PlainEndpoint() {
    }

    public PlainEndpoint(EndpointData endpoint, TypedDatumSerializer typedDatumSerializer) {
        this.name = endpoint.getEndpointInstance().getEndpointName();
        this.counter = endpoint.getCounter();
        this.datum = typedDatumSerializer.deserialize(endpoint.getDatum());
    }

    @Override
    public int compareTo(PlainEndpoint o) {
        if (this.name.equals(o.name)) {
            return this.counter.compareTo(o.counter);
        }
        return this.name.compareTo(o.name);
    }

    @Override
    public MatchResult matches(Map<DataType, Matcher> matchers, PlainEndpoint expected) {
        Matcher matcher;
        MatchResult result = new MatchResult();
        if (!this.name.equals(expected.name)) {
            result.addFailureCause(StringUtils.format((String)"The actual endpoint name %s does not match the expected name %s.", (Object[])new Object[]{this.name, expected.name}));
        }
        if (!this.datum.getDataType().equals((Object)expected.datum.getDataType())) {
            result.addFailureCause(StringUtils.format((String)"The actual TypedDatum's type %s does not match the expected TypedDatum's type %s", (Object[])new Object[]{this.datum.getDataType().toString(), expected.datum.getDataType().toString()}));
        }
        if ((matcher = matchers.get(this.datum.getDataType())) == null) {
            throw new IllegalArgumentException(StringUtils.format((String)"No matcher found for type %s", (Object[])new Object[]{this.datum.getDataType().toString()}));
        }
        MatchResult nestedMatchResult = matcher.matches(this.datum, expected.datum);
        if (!nestedMatchResult.hasMatched()) {
            result.addFailureCause(StringUtils.format((String)"The actual TypedDatum %s does not match the expected TypedDatum %s", (Object[])new Object[]{this.datum, expected.datum}), nestedMatchResult);
        }
        if (!this.counter.equals(expected.counter)) {
            result.addFailureCause(StringUtils.format((String)"The actual counter %d does not match the expected counter %d.", (Object[])new Object[]{this.counter, expected.counter}));
        }
        return result;
    }

    public String toString() {
        return StringUtils.format((String)"Endpoint(%s,%s)", (Object[])new Object[]{this.name, this.datum});
    }
}

