/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc;

import de.rcenvironment.core.communication.api.ReliableRPCStreamHandle;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.io.Serializable;
import java.util.List;

public class ServiceCallRequest
implements Serializable {
    private static final long serialVersionUID = 7198189060827978171L;
    private static final String ERROR_PARAMETERS_NULL = "The parameter \"%s\" must not be null.";
    private LogicalNodeSessionId target;
    private LogicalNodeSessionId caller;
    private final String serviceName;
    private final String methodName;
    private final List<? extends Serializable> parameters;
    private final String reliableRPCStreamId;
    private final transient ReliableRPCStreamHandle senderSideReliableRPCStreamHandle;
    private long sequenceNumber;

    public ServiceCallRequest(LogicalNodeSessionId targetNodeId, LogicalNodeSessionId callerNodeId, String serviceName, String methodName, List<? extends Serializable> parameters, ReliableRPCStreamHandle reliableRPCStreamHandle) {
        Assertions.isDefined((Object)targetNodeId, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"destination"}));
        Assertions.isDefined((Object)callerNodeId, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"sender"}));
        Assertions.isDefined((Object)serviceName, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"serviceName"}));
        Assertions.isDefined((Object)methodName, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"methodName"}));
        this.target = targetNodeId;
        this.caller = callerNodeId;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.parameters = parameters;
        this.senderSideReliableRPCStreamHandle = reliableRPCStreamHandle;
        this.reliableRPCStreamId = reliableRPCStreamHandle != null ? reliableRPCStreamHandle.getStreamId() : null;
    }

    public LogicalNodeSessionId getTargetNodeId() {
        return this.target;
    }

    public LogicalNodeSessionId getCallerNodeId() {
        return this.caller;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<? extends Serializable> getParameterList() {
        return this.parameters;
    }

    public String getReliableRPCStreamId() {
        return this.reliableRPCStreamId;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public ReliableRPCStreamHandle getSenderSideReliableRPCStreamHandle() {
        return this.senderSideReliableRPCStreamHandle;
    }
}

